/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KSMOOTHDOCK_H_
#define _KSMOOTHDOCK_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include <qwidget.h>

#include <kpopupmenu.h>
#include <krootpixmap.h>
#include <kwinmodule.h>

#include "constants.h"
#include "dockitem.h"
#include "tooltip.h"
#include "wallpapermanager.h"

/**
 * @short Application main widget
 * @author the KSmoothDock team <dangvd@yahoo.com>
 * @version 4.0
 */

class AboutDialog;
class ConfigDialog;
class LauncherConfigDialog;
class DockState;
class NormalZoomState;
class ParabolicZoomState;
class ButtonisedState;

class KSmoothDock : public QWidget {
    Q_OBJECT
public:
    // Constructor
    KSmoothDock(bool resetConfig, bool resetLaunchers);

    // Destructor
    virtual ~KSmoothDock();

    friend class DockState;
    friend class NormalZoomState;
    friend class ParabolicZoomState;
    friend class ButtonisedState;

    friend class ConfigDialog;

    // Get the current active window
    WId activeWindow();

    // Get the position of the dock
    PanelPosition getPosition();

    // Get the zoom mode of the dock
    ZoomMode getZoomMode();

    // Get active desktop color
    QColor getActiveDesktopColor();

    // Get inactive desktop color
    QColor getInactiveDesktopColor();

    // Get separator color
    QColor getSeparatorColor();

    // Get clock font face
    QString getClockFontFace();

    // Get small icon size
    int getSmallIconSize();

    // Update tooltip
    void updateTooltip();

    // Update clock
    void updateClock();

    // Show the popup menu
    void showPopupMenu(const QPoint& pos);

    // Config the dock
    void config(int tabIndex);

    // Set the desktop icons area
    static void setDesktopIconsArea(int left, int top, int width, int height);

public slots:
    // Exit the dock
    void exit();

    // Update background, reload the wallpaper if necessary
    void updateBackground(const QPixmap& pix);
    
    // Update background, no wallpaper reload
    void updateBackground();

    // Update the dock when a window has been added
    void windowAdded(WId id);
    
    // Update the dock when a window has been removed
    void windowRemoved(WId id);
    
    // Update the dock when a window has been changed
    void windowChanged(WId id, unsigned int properties);

    // Update the dock when the active window has been changed
    void activeWindowChanged(WId id);

    // Update the dock when the current desktop has been changed
    void currentDesktopChanged(int desktop);

    // Update a specific item
    void updateItem(int itemId);

    // Config the launchers
    void configLaunchers();

    // Config the dock
    void config();

    // Switch the zoom mode
    void switchZoomMode();

    // Hide the dock (to a buttonised state)
    void buttonise();

    // Show the about dialog
    void about();

    // Update the launchers
    void updateLaunchers();

    // Set positions
    void setPositionTop();
    void setPositionBottom();
    void setPositionLeft();
    void setPositionRight();
    void setPosition(PanelPosition position);

    // Switch autohide mode on/off
    void switchAutohideMode();

protected:
    // Paint event handler
    virtual void paintEvent(QPaintEvent* e);

    // Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    // Mouse moved event handler
    virtual void mouseMoveEvent(QMouseEvent* e);

    // Enter event handler
    virtual void enterEvent(QEvent* e);

    // Leave event handler
    virtual void leaveEvent(QEvent* e);

private: // functions
    // Init the dock
    void init();

    // Load configuration data
    void loadConfig(bool reset = false);

    // Save configuration data
    void saveConfig();
    
    // Initiate variables
    void initVariables();
    
    // Load quick launchers
    void loadLaunchers(bool reset = false);
    
    // Create default quick launchers
    void createDefaultLaunchers();

    // Initiate the pager
    void initPager();

    // Load running tasks
    void loadTasks();

    // Add a task
    void addTask(WId id, bool checkPosition = false);

    // Init the clock
    void initClock();

    // Update layout
    void updateLayout(bool reset = true);

    /// Set dock above all applications
    void setDockAbove();

    /// Set dock below all applications
    void setDockBelow();

    // Check kicker position to avoid collision
    void checkKickerPosition();

private: // variables
    // configurable variables //
    
    //  panel components
        
    int m_showPager; // show the pager
    int m_showTaskbar; // show the taskbar
    int m_showWindowsAllDesktops; // show windows from all desktops
    int m_showClock; // show the clock
    
    // icon zooming
    
    ZoomMode m_zoomMode; // zoom mode
    int m_NzZoomSpeed; // zoom animation speed: 1 ... 31 (normal zoom)
    int m_PzZoomSpeed; // zoom animation speed: 1 ... 31 (parabolic zoom)
    
    // arrangement
    
    PanelPosition m_position; // position of KSmoothDock on the screen (top, left, bottom, right)
    
    int m_NzSmallIconSize; // normal zoom's small icon size
    int m_NzBigIconSize; // normal zoom's big icon size
    int m_NzBaseIconSize; // normal zoom's base icon size
    
    int m_PzSmallIconSize; // parabolic zoom's small icon size
    int m_PzBigIconSize; // parabolic zoom's big icon size
    int m_PzBaseIconSize; // parabolic zoom's base icon size
    
    // hiding
    
    int m_isAutohide; // is KSmoothDock autohide?
    
    // appearance
    
    int m_dockOpacity; // dock opacity, ranging from 0 to 100
    int m_showBorders; // show-borders flag
    QColor m_borderColor; // border color
    QColor m_backgroundColor; // background color
    QColor m_separatorColor; // separator bar's color
    QColor m_activeDesktopColor; // the color of the active desktop's border
    QColor m_inactiveDesktopColor; // the color of inactive desktops' border
    
    // misc
    
    int m_showNotification; // show-notification flag        
    int m_screenWidth; // screen width, to support 2 or more physical screens
    
    // tooltip
    
    int m_showTooltip; // show tooltip flag 
    QString m_tooltipFontFace; // font face
    int m_tooltipFontSize; // font size
    int m_tooltipFontIsItalic; // indicate if font is italic
    int m_tooltipFontIsBold; // indicate if font is bold
    QColor m_tooltipFontColor; // font color
    QColor m_tooltipBackgroundColor; // background color
    
    // clock
    
    int m_use24HourClock; // indicate if using 24 hour clock
    QString m_clockFontFace; // clock font face
    int m_clockFontSize; // clock font size
    QColor m_clockFontColor; // clock font color        
    int m_clockFontIsItalic; // indicate if font is italic
    int m_clockFontIsBold; // indicate if font is bold
    
    // non-configurable variables //
    
    QString m_dataPath; // the path to the program data's directory
    QString m_launchersPath; // the path to the directory that contains the launchers
    
    std::vector<DockItem*> m_items; // the list of dock items
    // std::auto_ptr<DockState> m_state; // the dock's current state
    DockState* m_state; // the dock's current state
    NormalZoomState* m_normalZoomState; // NormalZoomState object
    ParabolicZoomState* m_parabolicZoomState; // ParabolicZoomState object
    ButtonisedState* m_buttonisedState; // ButtonisedState object

    WallpaperManager* m_wallpaperManager; // wallpaper manager @NOTE: cannot use auto_ptr because we need to copy the pointer around

    int m_smallIconSize; // small icon size
    int m_bigIconSize; // big icon size
    int m_baseIconSize; // base icon size

    // int m_desktop; // current desktop
    Orientation m_orientation; // orientation of the dock

    std::auto_ptr<AboutDialog> m_aboutDialog; // about dialog
    std::auto_ptr<ConfigDialog> m_configDialog; // config dialog
    std::auto_ptr<LauncherConfigDialog> m_launcherConfigDialog; // launcher config dialog

    KWinModule m_windowManager; // window manager, to get current running tasks...
    std::auto_ptr<KRootPixmap> m_rootPix; // for pseudo-transparency

    Tooltip m_tooltip; // tooltip window

    int m_itemIndexInitialiser;
};

#endif // _KSMOOTHDOCK_H_
