/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NORMALZOOMSTATE_H
#define NORMALZOOMSTATE_H

#include <qobject.h>
#include "dockstate.h"

/**
 * @short Class representing the normal zoom state of the dock
 * @author the KSmoothDock team <dangvd@yahoo.com>
*/

#include <vector>

#include <qtimer.h>

#include <kpixmap.h>

class NormalZoomState : public QObject, public DockState
{
    Q_OBJECT
public:
    /// Constructors
    NormalZoomState(KSmoothDock* dock);

    /// Dock created event
    virtual void dockCreatedEvent();

    /// Update the layout
    virtual void updateLayout(bool reset = true);

    /// Update background
    virtual void updateBackground();

    /// Paint event handler    
    virtual void paintEvent(QPaintEvent* e);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    /// Mouse moved event handler
    virtual void mouseMoveEvent(QMouseEvent* e);

    /// Enter event handler
    virtual void enterEvent(QEvent* e);

    /// Leave event handler
    virtual void leaveEvent(QEvent* e);

    /// Update a specific item
    virtual void updateItem(int itemIndex);

    /// Update the dock when the active window has been changed
    virtual void activeWindowChanged(WId id);

    /// Update autohide mode
    virtual void updateAutohideMode();

public slots:
    /// Zoom timer event handler
    void updateZoom();

    /// Stop launcher acknowledgement
    void stopLauncherAcknowledgement();
private: // functions
    /// Find the index of the item with mouse focus given mouse's x and y position
    int findItemIndex(int x, int y);

    /// Update background image
    void updateBackgroundImage();

    /// Update after showing/un-showing the desktop
    void updateAfterShowingDesktop();

    /// Pause execution
    void pauseExecution();
    
    /// Set mask on/off
    void setMaskOn(bool maskOn);

private: // data
    int m_w; // dock's width
    int m_h; // dock' height

    bool m_isHidden; // indicating the dock is hidden when autohide mode is on

    std::auto_ptr<KPixmap> m_background; // background image
    std::auto_ptr<QPixmap> m_buffer; // off-screen buffer image    

    int m_lastFocusedItemIndex; // the index of the last focused item
    int m_clickedLauncherIndex; // the index of the recently clicked launcher

    std::vector<int> m_itemsSize; // size of the items
    std::vector<int> m_itemsSizeIncrement; // increment in size of the items
    
    unsigned int m_firstIndexToUpdate; // paint event handler will update items with index from m_firstIndexToUpdate to m_lastIndexToUpdate
    unsigned int m_lastIndexToUpdate;

    QTimer* m_timer;
    int m_animationNumSteps; // number of animation steps
    // int m_animationStepDelay; // delay between animation steps (in miliseconds)

    bool m_maskOn; // indicate if we are using the mask on paint event

};

#endif
