/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PARABOLICZOOMSTATE_H
#define PARABOLICZOOMSTATE_H

#include <qobject.h>
#include "dockstate.h"

/**
 * @short Class representing parabolic zoom state of the dock
 * @author the KSmoothDock team <dangvd@yahoo.com>
*/

#include <vector>

#include <qtimer.h>

#include <kpixmap.h>

class ParabolicZoomState : public QObject, public DockState
{
    Q_OBJECT
public:
    /// Constructors
    ParabolicZoomState(KSmoothDock* dock);

    /// Dock created event
    virtual void dockCreatedEvent();

    /// Update the layout
    virtual void updateLayout(bool reset = true);

    /// Update background
    virtual void updateBackground();

    /// Paint event handler    
    virtual void paintEvent(QPaintEvent* e);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    /// Mouse moved event handler
    virtual void mouseMoveEvent(QMouseEvent* e);

    /// Enter event handler
    virtual void enterEvent(QEvent* e);

    /// Leave event handler
    virtual void leaveEvent(QEvent* e);

    /// Update a specific item
    virtual void updateItem(int itemIndex);

    /// Update the dock when the active window has been changed
    virtual void activeWindowChanged(WId id);

    /// Update autohide mode
    virtual void updateAutohideMode();

public slots:
    /// Zoom timer event handler
    void updateZoom();

    /// Stop launcher acknowledgement
    void stopLauncherAcknowledgement();
private: // functions
    /// Find the index of the item with mouse focus given the mouse's x and y position
    int findItemIndex(int x, int y);

    /// Set isMinimised property given the mouse's x and y position
    bool enableZoom(int x, int y);

    /// Set items' position (and size) given the mouse's x and y position
    void setItemsPosition(int x, int y);

    /// Show tooltip at item i
    void showTooltip(int index);

    /// Update background image
    void updateBackgroundImage();

    /// Update after showing/un-showing the desktop
    void updateAfterShowingDesktop();

    /// Update the snapshot, copying from wallpaper image
    void updateSnapshotFromWallpaper();

    /// Update the snapshot, copying from desktop
    void updateSnapshotFromDesktop();

    /// Fade and draw a border on the snapshot (in autohide mode)
    void fadeSnapshot();

    /// Pause execution
    void pauseExecution();

    /// Set mask on/off
    void setMaskOn(bool maskOn);

    /// Parabolic function
    int function(int x);
private: // data
    int m_w; // dock's width
    int m_h; // dock' height
    int m_minW; // dock's width (when minimised)
    int m_minH; // dock's height (when minimised)

    bool m_isMinimised; // the dock is minimised
    bool m_maskOn; // indicate if we are using the mask on paint event

    int m_itemSpacing; // space between items

    std::auto_ptr<KPixmap> m_background; // background image
    std::auto_ptr<QPixmap> m_originalBackground; // original (no effect) background image
    std::auto_ptr<QPixmap> m_buffer; // off-screen buffer image
    std::auto_ptr<QPixmap> m_sideBorder; // side border
    QPixmap m_snapshot; // snapshot of part of the desktop that overlaps with the dock, refreshed everytime the dock is zoomed in

    int m_clickedLauncherIndex; // the index of the recently clicked launcher

    std::vector<int> m_itemsSize; // size of the items
    std::vector<int> m_itemsStartSize; // size of the items, used in animation
    std::vector<int> m_itemsEndSize; // size of the items, used in animation
    
    std::vector<int> m_itemsCenterMin; // center point of the items when minimised
    std::vector<int> m_itemsCenter; // center point of the items
    std::vector<int> m_itemsStartCenter; // used in animation
    std::vector<int> m_itemsEndCenter; // used in animation

    bool m_justEntered; // the mouse has just entered the dock
    bool m_justLeft; // the mouse has just left the dock

    QTimer* m_timer;
    int m_animationNumSteps; // number of animation steps
    int m_animationCurrentStep; // animation's current step
    bool m_inAnimation; // are we in the animation process?
    // int m_animationStepDelay; // delay between animation steps (in miliseconds)

    int m_functionMaxX; // function's max value of x
};

#endif
