/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tooltip.h"

#include <qbitmap.h>
#include <qfontmetrics.h>
#include <qpainter.h>
#include <qpixmap.h>

#include <klocale.h>
#include <kwin.h>

/// PUBLIC ///

/**
 * Constructor
 */

Tooltip::Tooltip(QWidget* parent, const char* name)
 : QWidget(parent, name, WStyle_Customize |  WNoAutoErase | WStyle_NoBorder | WDestructiveClose | WMouseNoMask | WStyle_StaysOnTop | WX11BypassWM) {
    KWin::setOnAllDesktops(winId(), true);
    KWin::setState(winId(), NET::SkipTaskbar | NET::SkipPager | NET::KeepAbove);
}

/**
 * Set tooltip's font color
 */

void Tooltip::setFontColor(QColor color)
{
    m_fontColor = color;
}

/**
 * Set tooltip's background color
 */

void Tooltip::setBackgroundColor(QColor color) {
    m_backgroundColor = color;
}

/**
 * Set tooltip's font face
 */

void Tooltip::setFontFace(QString fontFace)
{
    m_font.setFamily(fontFace);
}

/**
 * Set tooltip's font italic property
 */

void Tooltip::setFontItalic(bool val)
{
    m_font.setItalic(val);
}

/**
 * Set tooltip's font bold property
 */

void Tooltip::setFontBold(bool val)
{
    m_font.setBold(val);
}

/**
 * Set tooltip's font size
 */

void Tooltip::setFontSize(int size)
{
    m_fontSize = size;
    m_font.setPointSize(size);
}

/**
 * Set tooltip's text
 */

void Tooltip::setText(QString s)
{
    m_text = s;
    updateLayout();
}

/**
 * Update tooltip's layout
 */

void Tooltip::updateLayout() {
    QFontMetrics metrics(m_font);
    int w = metrics.width(m_text) + 6; // 6 pixels more
    int h = metrics.height() + 6; // 6 pixels more

    resize(w,h);
    update();
}

/// PROTECTED ///

/**
 * Paint event handler
 */

void Tooltip::paintEvent(QPaintEvent* e) {
    QPixmap pm(size());
    QBitmap bm(size());

    // draw the mask bitmap

    QPainter p0;
    p0.begin(&bm);

    p0.fillRect(rect(), Qt::color0);

    p0.setPen( Qt::color1 );
    p0.setFont(m_font);

    for (int i = -2; i <= 2; i++)
    for (int j = -2; j <= 2; j++) {
        p0.drawText(3 + i, 3 + m_fontSize + j, m_text);
    }

    p0.drawText(3, 3 + m_fontSize, m_text);

    p0.end();

    // draw the buffer pixmap

    QPainter p;
    p.begin(&pm);

    p.setPen(m_backgroundColor);
    p.setFont(m_font);

    for (int i = -2; i <= 2; i++)
    for (int j = -2; j <= 2; j++) {
        p.drawText(3 + i, 3 + m_fontSize + j, m_text);
    }

    // now draw the normal text
    p.setPen(m_fontColor);
    p.setFont(m_font);
    p.drawText(3, 3 + m_fontSize, m_text);

    p.end();

    // update the widget
    bitBlt(this, 0, 0, &pm);
    setMask(bm); // for transparency
}
