
#include <iostream>
#include <kwallet.h>
#include <kpassdlg.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static KCmdLineOptions options[] =
{
    { "+[dialog]", I18N_NOOP( "Dialog message. Leave undefined for default message" ), 0 },
	KCmdLineLastOption
};

int main(int argc, char **argv)
{
	KAboutData about (
		"Ksshagent", 									// appName
		I18N_NOOP("Ksshagent"), 							// programName
		"0.3",										// version
		I18N_NOOP("KDE version of sshaskpass"),						// shortDescription
		KAboutData::License_GPL,							// licenseType
		"(c) 2006 Hans van Leeuwen",							// copyrightStatement statement
		I18N_NOOP("Ksshagent allows you to list, add and remove keys from ssh-agent"),	// text
		"http://hanz.nl",								// homePageAddress
		"hanz@hanz.nl"									// bugsEmailAddress
	);
	about.addAuthor("Hans van Leeuwen", 0, "hanz@hanz.nl");

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	KApplication app;


	// Disable Session Management and DCOP. We don't need it.
	app.disableSessionManagement();
	app.disableAutoDcopRegistration();


	// Declare variables
	QString walletFolder = about.appName();
	QString dialog = I18N_NOOP("Please enter password");	// Default dialog text
	QString keyFile;
	QCString password;

	
	// Parse commandline arguments
	if ( args->count() > 0 ) {
		dialog = args->arg(0);
		keyFile = dialog.section(" ", -2).remove(":");
	}
	args->clear();


	// Open KWallet to see if a password was previously stored.
	KWallet::Wallet *wallet = KWallet::Wallet::openWallet( KWallet::Wallet::NetworkWallet(), 0 );

	if ( wallet && wallet->hasFolder(walletFolder) ) {
		wallet->setFolder(walletFolder);

		QString retrievedPass;

		wallet->readPassword(keyFile, retrievedPass);

		if ( retrievedPass ) {
			password = retrievedPass;
		}
	}


	// Password could not be retrieved from wallet. Open password dialog
	if ( !password ) {
		KPasswordDialog *kpd = new KPasswordDialog(KPasswordDialog::Password, true, 0);
		kpd->setPrompt(dialog);
		kpd->setCaption(i18n("Ksshaskpass"));
		kpd->setAllowEmptyPasswords(false);
		// We don't want to dump core when the password dialog is shown, because it could contain the entered password.
		kpd->disableCoreDumps(); 

		if ( kpd->exec() == KDialog::Accepted ) {
			password = kpd->password();
		}

		// If "Enable Keep" is enabled, open/create a folder in KWallet and store the password.
		if ( kpd->keep() ) {
			if ( !wallet->hasFolder( walletFolder ) ) {
				wallet->createFolder(walletFolder);
			}
			wallet->setFolder(walletFolder);
			wallet->writePassword(keyFile, password);
		}

		delete kpd;
	}


	// Finally return the password.
	std::cout << password;
	//delete password;
	return 0;
}
