/*
Part of KSudoku project
http://ksudoku.sf.net
(c) 2005 Francesco Rossi <redsh@email.it>
(c) 2007 Johannes Bergmeier <Johannes.Bergmeier@gmx.net>
	 Mick Kappenburg <ksudoku@kappenburg.net>
	 Francesco Rossi <redsh@email.it>

This is free software released under GNU GENERAL PUBLIC LICENSE (GPLv2)
See COPYING file in project root directory for more information.

See the credits for this file in AUTHORS file in project root directory
*/
// Johannes Bergmeier <Johannes.Bergmeier@gmx.net>, Francesco Rossi <redsh@email.it>(C) 2007
//
#include "gameseldlg.h" 

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <kmessagebox.h>
#include <qsignalmapper.h>
#include <stdio.h> // TODO rem this
#include <kdialog.h>

namespace ksudoku {


GameSelectionButton::GameSelectionButton(const QString& text, QWidget* parent, const QString& id)
	: QPushButton(text, parent), m_id(id), m_group(0)
{ }

inline GameSelectionGroup* GameSelectionButton::group() const {
	return dynamic_cast<GameSelectionGroup*>(parent());
}


GameSelectionGroup::GameSelectionGroup(const QString& text, QWidget* parent)
	: QWidget(parent), m_text(text), m_gridLayout(0), m_mainLayout(new QVBoxLayout(this)), m_usedCols(1), m_idealCols(1)
{
	m_mainLayout->addWidget (new QLabel("<b>"+text+"</b>", this));
	
	m_gridLayout = new QGridLayout(m_mainLayout);
	m_gridLayout->setSpacing(10);
	m_gridLayout->setMargin(10);
}

GameSelectionButton* GameSelectionGroup::addButton(const QString& id, const QString& text) {
	GameSelectionButton* button = new GameSelectionButton(text, this, id);
	m_buttons.append(button);
	updateColumnCount();
	updateLayout();
	return button;
}

bool GameSelectionGroup::removeButton(const QString& id) {
	GameSelectionButton *button;
    for(button = m_buttons.first(); button; button = m_buttons.next()) {
		if(button->id() == id) {
			m_buttons.remove();
			delete button;
			updateColumnCount();
			updateLayout();
			return true;
		}
	}
	return false;
}

void GameSelectionGroup::updateColumnCount() {
	uint idealCols = m_buttons.count();
	if(idealCols == 0) idealCols = 1;
	if(idealCols > 4) idealCols = 4;
	
	if(idealCols != m_idealCols) {
		m_idealCols = idealCols;
		emit idealColumnCountChanged(idealCols);
	}
}

void GameSelectionGroup::setColumns(uint cols) {
	if(cols == m_usedCols) return;
		
	if(cols < m_usedCols) {
		delete m_gridLayout;
		m_gridLayout = new QGridLayout(m_mainLayout);
		m_gridLayout->setSpacing(10);
		m_gridLayout->setMargin(10);
	}
	
	m_usedCols = cols;


	updateLayout();
}

void GameSelectionGroup::updateLayout() {
	m_gridLayout->expand(1, m_usedCols);
	GameSelectionButton* button;
	uint pos = 0;
	for(button = m_buttons.first(); button; button = m_buttons.next(), pos++) {
		m_gridLayout->addWidget(button, pos / m_usedCols, pos % m_usedCols);
	}
}
GameSelectionDialog::GameSelectionDialog(QWidget* parent) : QWidget(parent) {
	m_mainLayout = new QVBoxLayout(this);
	m_mainLayout->setSpacing(KDialog::spacingHint());
	m_mainLayout->setMargin(KDialog::marginHint());
	
	m_signalMapper = new QSignalMapper(this);
	connect(m_signalMapper, SIGNAL(mapped(const QString&)), this, SLOT(onButtonPressed(const QString&)));
	
	m_mainLayout->addWidget (new QLabel("<center><h1>"+i18n("Welcome to KSudoku")+"</h1></center>", this));

		
};

GameSelectionDialog::~GameSelectionDialog() {
}

void GameSelectionDialog::addEntry(const QString& name, const QString& text, const QString& groupText) {
	GameSelectionGroup* group = 0;
	for(group = m_groups.first(); group; group = m_groups.next()) {
		if(group->text() == groupText) break;
	}
	if(!group) {
		group = new GameSelectionGroup(groupText, this);
		m_mainLayout->addWidget(group);
		m_groups.append(group);
		connect(group, SIGNAL(idealColumnCountChanged(uint)), this, SLOT(updateColumnCount()));
		connect(this, SIGNAL(columnCountChanged(uint)), group, SLOT(setColumns(uint)));
	}
	GameSelectionButton* button = group->addButton(name, text);
	button->show();
	m_signalMapper->setMapping(button, name);
	connect(button, SIGNAL(clicked()), m_signalMapper, SLOT(map()));
}

bool GameSelectionDialog::removeEntry(const QString& name) {
	for(GameSelectionGroup* group = m_groups.first(); group; group = m_groups.next()) {
		if(group->removeButton(name))
			return true;
	}
	return false;
}

void GameSelectionDialog::onButtonPressed(const QString& name) {
	emit gameSelected(name);
}

void GameSelectionDialog::UPDATE()
{
	updateColumnCount();
}

void GameSelectionDialog::updateColumnCount() {
	uint columns = 1;
	for(GameSelectionGroup* group = m_groups.first(); group; group = m_groups.next()) {
		if(group->idealColumns() > columns)
			columns = group->idealColumns();
	}
	emit columnCountChanged(columns);
//	printf("ColCount: %d\n", columns);
	
}

}

#include "gameseldlg.moc"
