/*
Part of KSudoku project
http://ksudoku.sf.net
(c) 2005 Francesco Rossi <redsh@email.it>
(c) 2007 Johannes Bergmeier <Johannes.Bergmeier@gmx.net>
	 Mick Kappenburg <ksudoku@kappenburg.net>
	 Francesco Rossi <redsh@email.it>

This is free software released under GNU GENERAL PUBLIC LICENSE (GPLv2)
See COPYING file in project root directory for more information.

See the credits for this file in AUTHORS file in project root directory
*/
// Johannes Bergmeier <Johannes.Bergmeier@gmx.net>, (C) 2006-2007
//
#ifndef _KSUDOKUSERIALIZER_H_
#define _KSUDOKUSERIALIZER_H_

#include <qvaluelist.h>

class SKSolver;
class QDomElement;
class KURL;
class QWidget;
class QString;

namespace ksudoku {

class Game;
class Puzzle;
class HistoryEvent;
class Serializer {
public:
	static Game deserializeGame(QDomElement element);
	static Puzzle* deserializePuzzle(QDomElement element) ;
	static SKSolver* deserializeGraph(QDomElement element);
	static QValueList<HistoryEvent> deserializeHistory(QDomElement element);
	static HistoryEvent deserializeSimpleHistoryEvent(QDomElement element);
	static HistoryEvent deserializeComplexHistoryEvent(QDomElement element);
	
	static Game load(const KURL& url, QWidget* window, QString* errorMsg = 0);
	static SKSolver* loadCustomShape(const KURL& url, QWidget* window, QString* errorMsg = 0);

	static bool serializeGame(QDomElement& parent, const Game& game);
	static bool serializePuzzle(QDomElement& parent, const Puzzle* puzzle);
	static bool serializeGraph(QDomElement& parent, const SKSolver* solver);
	static bool serializeHistory(QDomElement& parent, const Game& game);
	static bool serializeHistoryEvent(QDomElement& parent, const HistoryEvent& event);
	
	static bool store(const Game& game, const KURL& url, QWidget* window);
	static bool storeCustomShape(const SKSolver* solver, const KURL& url, QWidget* window);

};

}

#endif
