/***************************************************************************
 *   Copyright (C) 2005 Nadeem Hasan <nhasan@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "edgewidget.h"

#include <qpainter.h>

#include <kdebug.h>
#include <kglobalsettings.h>

#define SCALE( x )   ( ( int ) ( ( ( x )*m_scaleFactor )+0.5 ) )
#define UNSCALE( x ) ( ( int ) ( ( ( x )/m_scaleFactor )+0.5 ) )

EdgeWidget::EdgeWidget( QWidget *parent, const char *name )
  : QWidget( parent, name ),
    m_bezel( QRect( QPoint( 1472, 1408 ), QPoint( 5472, 4448 ) ) ),
    m_state( None )
{
  setMouseTracking( true );
  //m_scaleFactor = width()/m_bezel.width();
}

void EdgeWidget::setEdges( const QRect &edges )
{
  m_edges = edges;
}

void EdgeWidget::paintEvent( QPaintEvent * )
{
  QPainter p( this );

  drawPad( &p );

  p.setPen( DotLine );
  //QRect top = topLine();
  //kdDebug() << k_funcinfo << "topLine(): " << top << endl;
  //p.drawLine( top.topLeft(), top.bottomRight() );
}

void EdgeWidget::drawPad( QPainter *p )
{
  QRect r = rect();

  p->fillRect( r, Qt::white );
  p->setPen( KGlobalSettings::buttonBackground().dark( 150 ) );
  p->moveTo( r.left(), r.bottom() );
  p->lineTo( r.right(), r.bottom() );
  p->lineTo( r.right(), r.top() );
  p->lineTo( r.left(), r.top() );
  p->lineTo( r.left(), r.bottom() );
  p->setPen( KGlobalSettings::buttonBackground().dark( 120 ) );
  p->moveTo( r.left()+1, r.bottom()-1 );
  p->lineTo( r.right()-1, r.bottom()-1 );
  p->lineTo( r.right()-1, r.top()+1 );
  p->lineTo( r.left()+1, r.top()+1 );
  p->lineTo( r.left()+1, r.bottom()-1 );
}

void EdgeWidget::resizeEvent( QResizeEvent * )
{
  m_scaleFactor = ( ( double )width() )/m_bezel.width();
  kdDebug() << k_funcinfo << "Resize: " << width() << endl;
  kdDebug() << k_funcinfo << "Scale: " << m_scaleFactor << endl;
}

QRect EdgeWidget::topLine() const
{
  int top = SCALE( m_edges.top() - m_bezel.top() );
  return QRect( QPoint( top, 2 ), QPoint( top, width()-2 ) );
}

#include "edgewidget.moc"
