/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <qcstring.h>
#include <qstring.h>
#include <kconfig.h>


class Configuration: public QObject {
    Q_OBJECT
    
public:
    virtual ~Configuration();
    Configuration(QString confFile);
    /// Reads all the configuration data from the application config file.
    void readSettings();
    /// Writes the configuration data to the application config file.
    void writeSettings();
    /// Reads IP Settings for a given SSID
    int readIpSettings(QString ssid, bool &useDhcp, QString  &ipaddress, QString &netmask, QString & gateway, QString & dns1, QString & dns2, QString & domain, bool & dontOverrideGw, bool & dontOverrideDns,QStringList & dnsSearchlist);
    /// Writes IP Settings for a given SSID
    int writeIpSettings(QString ssid, bool useDhcp, QString ipaddress, QString netmask, QString gateway, QString dns1, QString dns2, QString domain,bool dontOverrideGw,bool dontOverrideDns,QStringList searchlist);
    /// Sets encryption mode for given SSID
    void writeEncryption (QString ssid, bool encryption);
    /// Gets encryption mode for given SSID
    void readEncryption (QString ssid, bool & encryption);
    void readScriptAfterConnect(QString ssid, QString &script, bool &useRootRights);
    void writeScriptAfterConnect(QString ssid, QString script, bool useRootRights);
    void readScriptBeforeDisconnect(QString ssid, QString &script, bool &useRootRights);
    void writeScriptBeforeDisconnect(QString ssid, QString script, bool useRootRights);
    /// Gets default driver for given interface
    void readDriver(QString &driver);
    void writeDriver(QString driver);
    /// Gets last ssid for interface
    void readLastSsid(QString & ssid);
    /// writes last ssid for interface
    void writeLastSsid(QString ssid);
    /// Returns all Networks configured in the config file
    QStringList getNetworks();
    /// Deletes network for given SSID
    void deleteNetwork(QString ssid);
    //bool m_startDhcp;
    bool m_startWpa;
    bool m_startWpaNoQuestion;
    bool m_startMinimized;
    bool m_useCustomWpaConf;
    int m_ap_scan;
    QString m_customWpaConf;
    
private:
    QString m_confFile;
    
};


class mainConfigurationClass: public QObject {
    Q_OBJECT
    
    public:
        virtual ~mainConfigurationClass();
        bool readMonitorInterface(QString interface);
        void writeMonitorInterface(QString interface, bool monitored);
        bool readConfigureInterface(QString interface);
        void writeConfigureInterface(QString interface, bool configure);
        void writeStartMinimized(bool startMinimized);
        bool readShowAvailableOnly();
        void writeShowAvailableOnly (bool showAvailable);
        bool readStartMinimized();
        bool readShowCommands();
        void writeShowCommands (bool showCommands);
        KConfig *m_configuration;
    private:
        mainConfigurationClass();
        QString m_confFile;
        friend mainConfigurationClass& mainConfiguration();

    
};

mainConfigurationClass& mainConfiguration();

/*
// Class to cache passwords
class PasswordCacheClass : public QObject{
    Q_OBJECT
            
    public:
        virtual ~PasswordCacheClass();
        /// Cache the password for m_pwexpire seconds
        void setPassword(const QCString &password);
        /// Retrive cached password
        const QCString& password() const;
        void writePasswordExpire();
        void readPasswordExpire();
        int m_pwexpire;
    
    private:
        PasswordCacheClass();
        PasswordCacheClass(const PasswordCacheClass&);

    // allow this function to create one instance
        friend PasswordCacheClass& PasswordCache();

    //Runtime-only field. Should be empty to indicate no password cached
        QCString m_password;
    
    private slots:    
        void wipePassword();
};
// use this function to access the settings
PasswordCacheClass& PasswordCache();
*/
#endif
