/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef KSCANDLG_H
#define KSCANDLG_H

#include "kscan.h"


class KwlanInterface;
class QString;
class KProcess;
class QTimer;

class KScanDlg : public KScan
{
  Q_OBJECT

public:
  KScanDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KScanDlg();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          closeScanWindow();
  virtual void          addSelected();
  virtual void          bssSelected( QListViewItem * sel );
  virtual void          scanRequest();
  virtual void          updateResults();
  virtual void          setInterface( KwlanInterface *interface );

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
    
private:
    KwlanInterface *m_interface;
    QTimer *m_timer;

};

#endif


