/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/
#ifndef KWLANMAINWIN_H
#define KWLANMAINWIN_H

#include "kwlan.h"
#include "configuration.h"
#include "wpa_ctrl.h"
#include "kwlantraywin.h"
#include "wpamsg.h"
#include <kapplication.h>
#include <qstringlist.h>
#include <qsocketnotifier.h>
#include <qptrlist.h>

class KScanDlg;
class KEventHistoryDlg;
class KUserDataRequestDlg;
class KTempFile;
class KwlanInterface;
class Configuration;
class KDialup;
class KProcess;
class KwlanMainTrayWin;

class KwlanMainWin : public Kwlan
{
    Q_OBJECT

    public:
        KwlanMainWin(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        ~KwlanMainWin();
        /*$PUBLIC_FUNCTIONS$*/
        QStringList getInterfaces()
        {
            return m_interfaces;
        }
    
    signals:
        void sigMonitorInterface(QString interface, bool showWin);
        void sigConfigureInterface(QString interface, bool configure);

    public slots:
        /*$PUBLIC_SLOTS$*/
  virtual void          helpHandbook();
        virtual void          fileSettings();
        virtual void          profileActivate();
        virtual void          cbInterfaceChanged(const QString&);
        virtual void          scan();
        virtual void          profileDelete();
        virtual void          profileModify();
        virtual void          profileNew();
        virtual void          dialupNew();
        virtual void          dialupDelete();
        virtual void          dialupModify();
        virtual void          dialupDisconnect();
        virtual void          dialupConnect();
        virtual int           init();
        virtual void          helpAbout();
        virtual void          fileExit();
        void updateDialupNetworks();
        void updateProfiles();
        void slotInterfaceGone(KwlanInterface *interface);
        void close();
        void slotCheckInterfaces();
        void slotChangeInterface(QString iface);
        void slotHandleMonitorInterface(QString iface, bool monitor);
        void slotHandleConfigureInterface(QString iface, bool configure);

    
        
    protected:
        /*$PROTECTED_FUNCTIONS$*/
    
    protected slots:
        /*$PROTECTED_SLOTS$*/
        
    private:
    
        bool getRootPassword();
        QStringList m_wlanInterfaces;
        QSocketNotifier *m_messageNotifier;
        Configuration *m_configuration;
        QString m_confFile;
        QStringList m_interfaces;
        QPtrList<KwlanInterface> m_interfaceList;
        QString m_ifconfigStdout;
        KwlanMainTrayWin *m_tray;
        QTimer *m_timer;
};

#endif


























