/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include <stdlib.h>

#include "kwlanmainwin.h"
#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <qsocketnotifier.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>

#include "wlanlib.h"
#include "kwlanapplication.h"

static const char description[] =
    I18N_NOOP("Network manager for KDE");

static const char version[] = "0.6.3";


static KCmdLineOptions options[] =
{
    { "debug", I18N_NOOP("print out lots of debug information"), 0 },
    KCmdLineLastOption
};

bool debugOutput;

int main(int argc, char **argv)
{
    KAboutData about("kwlan", I18N_NOOP("Kwlan"), version, description, KAboutData::License_GPL_V2, "(C) 2006 Thomas Michel", 0, 0, "tom.michel@arcor.de");
    about.addAuthor( "Thomas Michel", 0, "tom.michel@arcor.de" );
    about.addAuthor( "Jouni Malinen", I18N_NOOP("Original wpa_gui version"), "jkmaline@cc.hut.fi", 0 );
    about.addAuthor( "Valentine Sinitsyn", I18N_NOOP("Misc patches and improvements"), "e_val@inbox.ru", 0 );
    about.addAuthor("Laurens Vanhove",I18N_NOOP("New icons, improved tooltip design and bugfixes"),"laurens@nature-helps.com",0);
    about.addCredit( "Andrew Barr", I18N_NOOP("Kwlan icons"), "andrew.james.barr@gmail.com", 0 );
    about.addCredit("Percy Leonhard",I18N_NOOP("Source code for interface statistics from knemo"),"percy@eris23.de",0);
    about.addCredit("Jocke Andersson",I18N_NOOP("Bugfixing for connection strength in systray"),"ajocke@gmail.com",0);
    about.addCredit("Hugo Parente Lima",I18N_NOOP("Source code for icons showing I/O and interface statistics using /sys/class"),"hugo_pl@users.sourceforge.net ",0);
     
    about.setOtherText( I18N_NOOP("This product uses wpa_supplicant to configure wireless networks\n"
                        "wpa_supplicant includes software developed\n"
                        "by the OpenSSL Project for use in the\n"
                        "OpenSSL Toolkit (http://www.openssl.org/)\n" ));
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();    
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->isSet("debug"))
    {
            ::debugOutput = TRUE;
    }
    else ::debugOutput = FALSE;
    /*
    if (args->isSet("stop"))
    {
        KwlanApplication::~KwlanApplication();
    }
    */
    if (!KwlanApplication::start()) {
        fprintf(stderr, "Kwlan is already running!\n");
        exit(-1);
    }
    KwlanApplication app;
    app.init();
    return app.exec();
    
}
