#include "node.h"

#define CM_TYPE_EXPLOSION            (cm_explosion_get_type ())
#define CM_EXPLOSION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CM_TYPE_EXPLOSION, CmExplosion))
#define CM_EXPLOSION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  CM_TYPE_EXPLOSION, CmExplosionClass))
#define CM_IS_EXPLOSION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CM_TYPE_EXPLOSION))
#define CM_IS_EXPLOSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CM_TYPE_EXPLOSION))
#define CM_EXPLOSION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  CM_TYPE_EXPLOSION, CmExplosionClass))

typedef struct _CmExplosion CmExplosion;
typedef struct _CmExplosionClass CmExplosionClass;

struct _CmExplosion
{
    CmNode parent_instance;
    
    WsRegion *region;
    GList *polygons;

    gdouble level;
};

struct _CmExplosionClass
{
    CmNodeClass parent_class;
};

GType        cm_explosion_get_type     (void);
CmExplosion *cm_explosion_new          (int          x,
					int          y,
					int          w,
					int          h);
void         cm_explosion_set_geometry (CmExplosion *explosion,
					int          x,
					int          y,
					int          w,
					int          h);
void         cm_explosion_set_region   (CmExplosion *explosion,
					WsRegion    *region);

void	     cm_explosion_set_level    (CmExplosion *explosion,
					double	     level);
