#include "ws.h"
#include "wsint.h"

int
main ()
{
    WsDisplay *dpy1, *dpy2;
    WsSyncCounter *counter1, *counter2;

    g_type_init ();
    
    dpy1 = ws_display_new (NULL);
    dpy2 = ws_display_new (NULL);

    ws_display_init_sync (dpy1);
    ws_display_init_sync (dpy2);
    
    counter1 = ws_sync_counter_new (dpy1, 10);
    counter2 = ws_sync_counter_ensure (dpy2, WS_RESOURCE_XID (counter1));

    ws_display_sync (dpy1);
    
    ws_sync_counter_await (counter1, 11);

    ws_sync_counter_change (counter2, 1);

    g_print ("value: %lld\n", ws_sync_counter_query_value (counter2));
    
    ws_display_sync (dpy1);

    g_print ("success\n");
    return 0;
}
