/**
 * @file libgalago-gtk/galago-gtk-contact-path-bar.h
 *       Contact chooser path bar widget
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_CONTACT_PATH_BAR_H_
#define _GALAGO_GTK_CONTACT_PATH_BAR_H_

typedef struct _GalagoGtkContactPathBar      GalagoGtkContactPathBar;
typedef struct _GalagoGtkContactPathBarClass GalagoGtkContactPathBarClass;
typedef struct _GalagoGtkContactPathBarPriv  GalagoGtkContactPathBarPriv;

#include <libgalago/galago.h>
#include <gtk/gtkhbox.h>

#define GALAGO_GTK_TYPE_CONTACT_PATH_BAR (galago_gtk_contact_path_bar_get_type())
#define GALAGO_GTK_CONTACT_PATH_BAR(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_CONTACT_PATH_BAR, GalagoGtkContactPathBar))
#define GALAGO_GTK_CONTACT_PATH_BAR_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_CONTACT_PATH_BAR, GalagoGtkContactPathBarClass))
#define GALAGO_GTK_IS_CONTACT_PATH_BAR(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_CONTACT_PATH_BAR))
#define GALAGO_GTK_IS_CONTACT_PATH_BAR_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_CONTACT_PATH_BAR))
#define GALAGO_GTK_CONTACT_PATH_BAR_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_CONTACT_PATH_BAR, GalagoGtkContactPathBarClass))

typedef enum
{
	GALAGO_GTK_CONTACT_PATH_BAR_ROOT_SERVICE = 0,
	GALAGO_GTK_CONTACT_PATH_BAR_ROOT_ALL_PEOPLE,
	GALAGO_GTK_CONTACT_PATH_BAR_ROOT_ALL_CONTACTS

} GalagoGtkContactPathBarRootType;

struct _GalagoGtkContactPathBar
{
	GtkHBox parent_object;

	GalagoGtkContactPathBarPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkContactPathBarClass
{
	GtkHBoxClass parent_class;

	/* Signals */
	void (*root_activated)(GalagoGtkContactPathBar *path_bar);

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_contact_path_bar_get_type(void);

GtkWidget *galago_gtk_contact_path_bar_new(void);

void galago_gtk_contact_path_bar_set_root_type(
	GalagoGtkContactPathBar *path_bar,
	GalagoGtkContactPathBarRootType root_type);
void galago_gtk_contact_path_bar_set_service(GalagoGtkContactPathBar *path_bar,
											 GalagoService *service);
void galago_gtk_contact_path_bar_set_person(GalagoGtkContactPathBar *path_bar,
											GalagoPerson *person);
void galago_gtk_contact_path_bar_set_contact(GalagoGtkContactPathBar *path_bar,
											 GalagoAccount *contact);
GalagoGtkContactPathBarRootType galago_gtk_contact_path_bar_get_root_type(
	const GalagoGtkContactPathBar *path_bar);
GalagoService *galago_gtk_contact_path_bar_get_service(
	const GalagoGtkContactPathBar *path_bar);
GalagoPerson *galago_gtk_contact_path_bar_get_person(
	const GalagoGtkContactPathBar *path_bar);
GalagoAccount *galago_gtk_contact_path_bar_get_contact(
	const GalagoGtkContactPathBar *path_bar);

G_END_DECLS

#endif /* _GALAGO_GTK_CONTACT_PATH_BAR_H */

