# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gobject
import utils
import os

from helper import helper


try: 
    import dbus
    import dbus.service
    #Try connection du message bus
    dbus.SessionBus()
    if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
        import dbus.glib
except: dbus_imported = False
else: dbus_imported=True




if not dbus_imported:
    class ListenDBus:
        def __init__(self,win,player,object_path="/org/gnome/listen/"):
            self.player = player
            self.win = win    
    print "No dbus support"
else:
    
    class ListenDBus(dbus.service.Object):
        def __init__(self,win,player,object_path="/org/gnome/listen/"):
            self.player = player
            self.win = win
            self.bus = dbus.SessionBus()
            bus_name = dbus.service.BusName("org.gnome.Listen", bus=self.bus)
            dbus.service.Object.__init__(self, bus_name, object_path)
            #print "DBUS INIT"
    
        @dbus.service.method("org.gnome.Listen")
        def hello(self):
            #self.win.grab_focus()
            if self.win.get_property('visible'):
               self.win.present()
            return "Running"
    
    
        @dbus.service.method("org.gnome.Listen")
        def play(self,uris):
            print "DBUS: play()"
            self.win.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))    
            utils.parse_uris(uris,True,True,self.win.player_ui.playlist.ui.play_uris,False)
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def enqueue(self,uris):
            print "DBUS: enqueue()"    
            self.win.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))    
            utils.parse_uris(uris,True,True,self.win.player_ui.playlist.ui.add_uris,False)
            return "Successful command "
    
    
        @dbus.service.method("org.gnome.Listen")
        def quit(self):
            helper.control("quit")
            return "Successful command "
        
        @dbus.service.method("org.gnome.Listen")
        def previous(self):
            helper.control("previous")
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def next(self):
            helper.control("next")
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def play_pause(self):
            helper.control("play")
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def current_playing(self):
            if not self.player.paused:
                song = self.player.song    
                return str( song.get_str("title")+ " - ("+song.get_str("album")+" - "+song.get_str("artist")+")")
            else:
                return ""