#!/usr/bin/env python2.4
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import os, sys, locale, gettext
if "--help" in sys.argv or "-h" in sys.argv:
    import const
    locale.setlocale(locale.LC_ALL, '')
    gettext.bindtextdomain(const.GETTEXT_APP, const.GETTEXT_DIR)
    gettext.textdomain(const.GETTEXT_APP)
    gettext.install(const.GETTEXT_APP, const.GETTEXT_DIR, unicode=1)    
    from option_parser import ListenOptionParser
    ListenOptionParser()
    sys.exit(0)

import pygtk
pygtk.require("2.0")

import gnome,gnome.ui
gnome.ui.authentication_manager_init()


import gtk,gobject, bonobo
if gtk.pygtk_version < (2,6) or gtk.gtk_version < (2, 6):
    raise ImportError,"Need GTK > 2.6.0"

import pygst
pygst.require("0.10")

import gst
if gst.pygst_version < (0, 10, 1):
    raise ImportError,"Need Gstreamer >= 0.10.1"

import mutagen 
if mutagen.version < (1, 8):
    raise ImportError,"Need mutagen >= 1.8"

# Go to correct path
current_path = os.path.realpath(__file__)
basedir = os.path.dirname(os.path.realpath(__file__))
if not os.path.exists(os.path.join(basedir, "listen.py")):
    if os.path.exists(os.path.join(os.getcwd(), "listen.py")):
        basedir = os.getcwd()
sys.path.insert(0, basedir)
os.chdir(basedir)


import utils, const, stock, config
from widget.splash import Splash
from option_parser import ListenOptionParser

gobject.threads_init()

class ListenApp:#(gnome.ui.App)
    listen_instance = None  
    splash=None  
    def __init__(self):
        #gnome.ui.App.__init__(self)
        #sys.excepthook = self.__cb_exception    
        
        config.init(const.CONFIG_FILE)
        
        #Some distributions don't have module "Image"
        #Why can't he use Listen for a splashscreen ?
        try : import Image
        except: pass
        else:
            if config.get("setting","splash")=="true":
                self.splash = Splash()
                while gtk.events_pending():gtk.main_iteration()
            
        
        
        locale.setlocale(locale.LC_ALL, '')
        gettext.bindtextdomain(const.GETTEXT_APP, const.GETTEXT_DIR)
        gettext.textdomain(const.GETTEXT_APP)
        gettext.install(const.GETTEXT_APP, const.GETTEXT_DIR, unicode=1)
                
        
        self.bonobo_app = bonobo.Application(const.APPNAME)
                         
        listen_is_launched = self.bonobo_app.register_unique(self.bonobo_app.create_serverinfo(("LANG",)))
        
            
        self.bonobo_app.register_message("control",
                         "Control listen",
                         str, (str,str),
                         self.on_control_message)
                         
        self.bonobo_app.register_message("add",
                         "Add to listen",
                         str, (str, str),
                         self.on_add_message)
                         
        option = ListenOptionParser()
        
        if not listen_is_launched:
            option.run_preload()
            
            self.bonobo_app.new_instance(sys.argv)
                
            stock.stock_init()

            self.program = gnome.init(
                const.APPNAME, const.VERSION,
                gnome.libgnome_module_info_get(), sys.argv, []
            )

            client = gnome.ui.master_client()
            client.set_restart_style(gnome.ui.RESTART_IF_RUNNING)
            command = os.path.normpath(os.path.join(os.getcwd(), sys.argv[0]))
            try: client.set_restart_command([command] + sys.argv[1:])
            except TypeError:
                # Fedora systems have a broken gnome-python wrapper for this function.
                # http://www.sacredchao.net/quodlibet/ticket/591
                # http://trac.gajim.org/ticket/929
                client.set_restart_command(len(sys.argv), [command] + sys.argv[1:])
            client.connect('die', gtk.main_quit)
        

            """ Force disable visualisation if gst < 0.10.3 """
            if gst.pygst_version < (0, 10, 3):
                config.set("player","enable_vis","false")
                
            config.write(const.CONFIG_FILE)
            
            from widget.listen import Listen
            self.listen_instance = Listen()
            self.listen_instance.connect("ready",self.on_ready_cb)
            
        bonobo_client = self.bonobo_app.register_unique(self.bonobo_app.create_serverinfo(("LANG",)))
        
        option.run_load(bonobo_client)
        
        
        if not listen_is_launched:
            gtk.main()
        
        self.bonobo_app.unref()
        sys.exit(0)
        
    def on_control_message(self,app_client, message,arg):
        if not self.listen_instance:
            return "Bonobo applcation broken, Listen not instanciante"

        from helper import helper
        if message=="current-song":
            song = self.listen_instance.player_ui.player.song
            if not self.listen_instance.player_ui.player.paused:
                return song.get_str("title")+ " - ("+song.get_str("album")+" - "+song.get_str("artist")+")"
            else:
                return _("No playing song")
        
        elif message=="next":
            helper.control("next")
            return "Command successful"
        
        elif message=="previous":
            helper.control("previous")
            return "Command successful"
        
        elif message=="play-pause":
            helper.control("play")
            return "Command successful"
        
        elif message=="play-device":
            helper.play_device(arg)
            return "Command successful"
        
        elif message=="volume":
            try: value = float(arg)
            except: 
                return _("Fail to set volume")
                
            helper.volume(value)
            return "Command success"
        
        else:
            return "oups"
        
    def on_add_message(self,app_client, message,uris):
        uris = uris.split("<####>")
        if message=="play":
            print "play"
            utils.parse_uris(uris,True,True,self.listen_instance.player_ui.playlist.play_uris,False)
            return "Command successful"
        
        elif message=="queue":
            utils.parse_uris(uris,True,True,self.listen_instance.player_ui.playlist.add_uris,False)
            return "Command successful"
        else:
            return "oups"
        
    def on_ready_cb(self,listen):
        if self.splash!=None:
            self.splash.destroy()
        from song import thread_tag_reader
        thread_tag_reader.run()
            
if __name__ == "__main__":
    ListenApp()

