# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gobject
import gtk
import gnomevfs
import threading
import utils,stock

from  _source import Source,SourceItem,PlaylistSourceItem
from library import SimpleLibrary
from widget.song_view import SortableSongView
from widget.song_menu import SongMenu
from widget.misc import ScrolledWindow

from song import Song,sType
from helper import helper
from hal import hal
try: 
    import musicbrainz2
    import musicbrainz2.disc as disc
    import musicbrainz2.webservice as ws
except:
    print "No Audio cd support (musicbrainz2 missing)"

class MusicBrainzAudioCD:
    def __init__(self,device):
        self.device = device
        try: self.cd = disc.readDisc(device)    
        except: self.disc_id=None
        else: self.disc_id = self.cd.getId()
        
    def get_mb_release_id(self):
        q = ws.Query()
        filter = ws.ReleaseFilter(discId=self.disc_id)    
        
        try: results = q.getReleases(filter=filter)
        except: return None
        else:
            if len(results) > 0:
                return results[0].release.getId()               
        return None
                
    def get_mb_release(self,id):
        q = ws.Query()    
        include = ws.ReleaseIncludes(artist=True, tracks=True)
        try : res = q.getReleaseById(id,include)
        except: return None
        else: return res
        
    
    def get_songs(self):
        if not self.disc_id : 
            print "W:MusicBrainzAudioCD:No disk id"
            return []
        
        release_id = self.get_mb_release_id()
        release = self.get_mb_release(release_id)
        if not release_id or not release: 
            print "W:MusicBrainzAudioCD:No release found"
            cd_tracks = self.cd.getTracks()
            songs = []
            for i in range(0,len(cd_tracks)):
                t = cd_tracks[i]
                s = Song()
                s.set_type(sType.AUDIOCD_TRACKS)
                s["title"] = _("Track")+" %d"%(i+1)
                s["album"] = _("Unknown album")
                s["artist"] = _("Unknown artist")
                s["#track"] = (i+1)
                s["uri"] = "cdda://%d#%s"%(i+1,self.device)
                # an audio CD sector size = 2352 
                # and audio CD encoded at 44.1KHz, Stereo, with 16-bit/sample 
                s["#duration"] = (t[1]*2352)/(2*2*44100)*1000;
                songs.append(s)
            return songs
        
        
        album_name = release.getTitle()
        artist = release.getArtist()
        artist_name = artist.getName()
        date_album = release.getEarliestReleaseDate()
        
        tracks = release.getTracks()
        cd_tracks = self.cd.getTracks()
        
        songs = []
        
        for i in range(0,len(tracks)):
            t = tracks[i]
            cd_t = cd_tracks[i]
            s = Song()
            s.set_type(sType.AUDIOCD_TRACKS)
            s["title"] = t.getTitle()
            s["#date"] = date_album
            s["album"] = album_name
            s["artist"] = artist_name
            s["#track"] = (i+1)
            s["uri"] = "cdda://%d#%s"%(i+1,self.device)
            #s["#duration"] = t.getDuration()
            s["#duration"] = (cd_t[1]*2352)/(2*2*44100)*1000;
            songs.append(s)
        return songs
    
class AudioCDSource(Source):
    display_index = 80
    def __init__(self,player):
        Source.__init__(self,player)

        self.player = player    
        
        self.library = SimpleLibrary("audiocd")

        self.play_device = None
        self.audiocd_items = {}
        helper.connect("play-device",self.on_play_device)
        
    
    def on_play_device(self,helper,path):
        for udi,(item,device) in self.audiocd_items.iteritems():
            if path==device:
                helper.cur_playlist_play(self.library.get_pl_master().get_songs())    
        self.play_device = path
        
    def load(self,player):
        try: 
            import musicbrainz2
        except: pass
        else: hal.register_volume(self.check,self.mount,self.pre_umount,self.umount)
        
    def check(self,hal,volume,udi):
        prop = hal.get_property(udi)
        if prop.has_key("block.is_volume") and prop["block.is_volume"] and \
            prop.has_key("volume.disc.has_audio") and prop["volume.disc.has_audio"]:
                return True
        return False
        
        
    def mount(self,hal,volume,udi):
        prop = hal.get_property(udi)
        
        if prop.has_key("block.device"):
            t = threading.Thread(target=self.post_mount_thread,args=(prop["block.device"],udi))
            t.setDaemon(True)
            t.start()
                
    def post_mount_thread(self,device,udi):
            gobject.idle_add(self.post_mount_cb,MusicBrainzAudioCD(device).get_songs(),device,udi)
        
    def post_mount_cb(self,songs,device,udi):
        if len(songs)>0:
            pl = self.library.auto_gen_playlist(udi,songs)
                    
            view = AudioCDSongView(pl)
            view.get_model().fill(pl.get_songs())
            item = AudioCDSourceItem(self.player,pl,stock.WIKI_CD,songs[0].get_str("album"),ScrolledWindow(view),"audiocd")
            self.audiocd_items[udi] = (item,device)
            if self.play_device==device:
                helper.cur_playlist_play(pl.get_songs())
            self.build_source_items()
                

    def pre_umount(self,hal,volume,udi):
        pass
        
    def umount(self,hal,volume,udi):
        if self.audiocd_items.has_key(udi):
            del self.audiocd_items[udi]
            self.library.delete_auto_gen_playlist(udi)
            self.build_source_items()
                
        
    def build_source_items(self):
        self.items = []
        for udi,(item,device) in self.audiocd_items.iteritems():
            self.items.append(item)
        helper.update_source()
        
        
class AudioCDSourceItem(SourceItem):
    has_top_separateur = False
    has_bottom_separateur = False
    is_droppage = True
    
    def __init__(self,player,pl,stock,label,widget,config_code):
        SourceItem.__init__(self,player,stock,label,widget,config_code)
        self.pl = pl
    
    
    def on_drag_data_get(self,context, selection, info):
        list_uri = list([ song.get("uri") for song in self.pl.get_songs()])
        selection.set("text/listen-songs", 8, "\n".join(list_uri))
        selection.set_uris(list_uri)
        return True
      
    def on_activated(self):
        self.play_playlist()
        
    def play_playlist(self,w=None):
        songs = self.pl.get_songs()
        if len(songs)>0:
            helper.cur_playlist_play(songs)
               
    def enqueue_playlist(self,w):
        songs = self.pl.get_songs()
        if len(songs)>0:
            helper.cur_playlist_enqueue(songs)  
            
    def get_menu(self):
        menu = gtk.Menu()
        item = gtk.ImageMenuItem(stock.PLAY)
        item.connect("activate",self.play_playlist)
        menu.append(item)
        item = gtk.ImageMenuItem(stock.ENQUEUE)
        item.connect("activate",self.enqueue_playlist)
        menu.append(item)
        menu.show_all()
        return menu
        
class AudioCDSongView(SortableSongView):
    def __init__(self,pl):
        super(AudioCDSongView,self).__init__(pl,"audiocd")
        self.menu = SongMenu(None,True,True,False,False,False,False,False)
        self.menu.show_all()
        self.set_menu(self.menu)
          
    
    
    
