# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import shutil, sys
import os,os.path,stat
import urllib,locale
import gtk
import gobject
import gnomevfs
import struct

from time import time,strptime, mktime

import config
import stock
import const

TIP = gtk.Tooltips()
def set_tip(widget,text):
    TIP.set_tip(widget,text,None)

def profiling(func):
    def wrapper(*args,**kwargs):
        class_name = ""
        if hasattr(func,'im_class'):
            class_name = func.im_class__name__+":"
        name = class_name+func.func_name
        date = str(time())
        filename = "listen_profiling_"+name+"_"+date
        from hotshot import stats,Profile
        prof = Profile(filename)
        res = prof.runcall(func,*args,**kwargs)
        prof.close()
        s = stats.load(filename)
        print "\n** "+name+" **\n"
        s.sort_stats("time").print_stats()
        return res
    return wrapper

def print_timing(func):
    def wrapper(*arg):
        t1 = time()
        res = func(*arg)
        t2 = time()
        class_name = ""
        if hasattr(func,'im_class'):
            class_name = func.im_class__name__+":"
        print '%s took %0.3fms' % (class_name+func.func_name, (t2-t1)*1000.0)
        return res
    return wrapper

def format_tag(value):
    if not value:  return ""
    value = value.strip()
    if len(value)>1:
        value = value[:1].upper()+value[1:]
    else:
        value = value.upper()    
    return value

def dbus_service_available(bus,interface,try_start_service=False):
    try: import dbus
    except: return False
    if try_start_service:
        bus.start_service_by_name(interface)
    obj = bus.get_object('org.freedesktop.DBus', '/org/freedesktop/DBus') 
    dbus_iface = dbus.Interface(obj, 'org.freedesktop.DBus') 
    avail = dbus_iface.ListNames() 
    return interface in avail

""" Return all folder in a folder excepted hidden one """
def get_folder_in_folder(dir):
    dirs = set()
    try:hdir = gnomevfs.DirectoryHandle(dir)
    except: 
        print "W:Utils:get_folder_in_folder:",dir,"Not found"
    else:
        try: fileinfo = hdir.next()
        except StopIteration: 
            print "Empty"
        else:
            while fileinfo:
                if fileinfo.name[0] != "." and fileinfo.flags == gnomevfs.FILE_FLAGS_LOCAL and fileinfo.type == gnomevfs.FILE_TYPE_DIRECTORY:
                    dirs.add(dir+gnomevfs.escape_string(fileinfo.name)+"/")
                    to_add = get_folder_in_folder(dir+gnomevfs.escape_string(fileinfo.name)+"/")
                    dirs = dirs.union(to_add)
                try: fileinfo = hdir.next()
                except StopIteration: 
                    break;
    return dirs

""" Return all uri in a folder excepted hidden one """
def parse_folder(dir):
    uris = []
    dir = gnomevfs.make_uri_canonical(dir)
    try:hdir = gnomevfs.DirectoryHandle(dir)
    except: 
        print dir,"Not found"
        return []
    try: fileinfo = hdir.next()
    except StopIteration: return []
    while fileinfo:
        if fileinfo.name[0] != ".":#: and fileinfo.type == gnomevfs.FILE_TYPE_REGULAR:
            uris.append(dir+"/"+gnomevfs.escape_string(fileinfo.name))
        try: fileinfo = hdir.next()
        except StopIteration: break;
        while gtk.events_pending():gtk.main_iteration()
    print "W:Utils:ParseFolder:",len(uris),"founds"
    return uris

""" 
 - Receive a list of uris 
 - expand it 
 - check if exist
 - if directory recursive add all uri in directory
 - if playlist read all uri in playlist
 - return all supported file found
"""
#FIXME: Hum, Need rewritten to async way, because on remote is very slow
def parse_uris(uris,follow_folder=True,follow_playlist=True,func_cb=None,*param):
    from song import VALID_EXTENTIONS
    valid_uris = []
    for uri in uris:
        uri = gnomevfs.make_uri_canonical(uri)
        #Check file exists only is file is local to speed parsing of shared/remote file
        if uri and uri.strip()!="" and (get_protocol(uri)!="file://" or gnomevfs.exists(uri)):
            ext = get_ext(uri)
            info = None
            try:
                #info = gnomevfs.get_file_info(uri)    
                info = gnomevfs.get_file_info(uri,options=gnomevfs.FILE_INFO_FORCE_SLOW_MIME_TYPE)
            except:
                print "W:parse_uris:Failed retreive file info of",uri
                continue

            is_pls = False
            is_m3u = False
            try:
                is_pls = (info.mime_type == "audio/x-scpls")
                is_m3u = (info.mime_type == "audio/x-mpegurl" or info.mime_type == "audio/mpegurl" or info.mime_type == "audio/m3u")
            except:pass
            is_pls = is_pls or (ext == ".pls")
            is_m3u = is_m3u or (ext == ".m3u")
                
            if info and follow_folder and info.type == gnomevfs.FILE_TYPE_DIRECTORY:#info.flags == gnomevfs.FILE_FLAGS_LOCAL and 
                 valid_uris.extend(parse_uris(parse_folder(uri),follow_folder,follow_playlist))
            elif follow_playlist and is_pls:
                valid_uris.extend(parse_uris(get_uris_from_pls(uri),follow_folder,follow_playlist))
            elif follow_playlist and is_m3u:
                valid_uris.extend(parse_uris(get_uris_from_m3u(uri),follow_folder,follow_playlist))
            elif get_protocol(uri)!="file://" or VALID_EXTENTIONS.has_key(ext):
                valid_uris.append(uri)
        while gtk.events_pending():gtk.main_iteration()
    
    return_uris = []
    for u in valid_uris:
        if u not in return_uris:
            return_uris.append(u)
    
    if func_cb:
        gobject.idle_add(func_cb,return_uris,*param)
    print "W:Utils:ParseUris:",len(return_uris),"founds"
    return return_uris

""" Return uri in a m3u playlist """
def get_uris_from_m3u(uri):
    uris = []    
    content = gnomevfs.read_entire_file(uri)
    lines = content.splitlines()
    for line in lines:
        if not line.startswith("#") and line.strip()!="":
            uris.append(line.strip())
    uris = [pls_rebuild_uri(uri,u) for u in uris]
    return uris
    
""" Return uri in a pls playlist """
def get_uris_from_pls(uri):
    uris = []
    content = gnomevfs.read_entire_file(uri)
    lines = content.splitlines()
    for line in lines:

        if line.lower().startswith("file") and line.find("=")!=-1:
           uris.append(line[line.find("=")+1:].strip())
    uris = [pls_rebuild_uri(uri,u) for u in uris]
    return uris

def pls_rebuild_uri(base_uri,uri):
    base_uri = base_uri[:base_uri.rfind("/")]
    if uri.find("://")!=-1:
        return uri
    elif  uri[0] == "/":
        return "file://"+gnomevfs.escape_path_string(uri)
    else:
        return base_uri+"/"+gnomevfs.escape_path_string(uri)

def export_playlist(list_song,filename,type="m3u"):
    if type=="m3u":
        fileout = open(filename, "w")
        fileout.write("\n".join([song.get_path() for song in list_song if song.get_path() != none]))
        fileout.close()
    elif type=="pls":
        fileout = open(filename, "w")
        [ fileout.write("file%d=%s\n"%(i,song.get_path()))  for i,song in enumerate(list_song)  if song.get_path() != none  ]
        fileout.close()
    else:
        raise TypeError, "Unknow playlist type"

def burn(list_song):
    fn = "/tmp/listenburnpl.m3u"
    from song import sType
    export_playlist([s for s in list_song if s.get_type() in sType.file_transfert_to],fn)
    os.spawnlp(os.P_NOWAIT, "serpentine","serpentine","-o",fn)
    
""" 
Return uri found in a string
For now return uri only if one line is one uri
use parse uri to follow directory and playlist
"""
def get_uris_from_plain_text(content,func_cb=None,*param):
    lines = content.splitlines()
    uris = []
    for line in lines:
        if line.strip()!="":
            uris.append(line.strip())
    return parse_uris(uris,True,True,func_cb,*param)

    
    


"""
XML simple un/escape caracter
"""

def xmlescape(str):
    """Escape a string in a manner suitable for XML/Pango."""
    return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;")

def xmlunescape(str):
    """Unescape a string in a manner suitable for XML/Pango."""
    return str.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&")



"""
filename manipulation
"""
def get_protocol(uri):
    if uri.rfind("://")==-1:
        return ""
    protocol = uri[:uri.index("://")+3]
    return protocol.lower()

def get_ext(uri,complete=True):
    if uri.rfind(".")==-1:
        return ""
    if uri.rfind("#")!=-1:
        uri = uri[:uri.rindex("#")]
    if complete:
        return uri[uri.rindex("."):].lower()
    else:
        return uri[uri.rindex(".")+1:].lower()


""" Remove no need str for web service manipulation """
def filter_info_song(str):
    str = str.lower()
    filters = config.get("webservice","filter").split("<###>")
    for filter in filters:
        filter = filter.lower()
        str = str.replace(" "+filter+" "," ")
        if str.rfind(filter)==len(str)-len(filter):
            str = str.replace(" "+filter,"")
    return str

#FIXME: change to gnomevfs method
def move_to_trash(uri):
    path = gnomevfs.get_local_path_from_uri(uri)
    path = os.path.realpath(os.path.expanduser(path))
    if not os.path.exists(path): return False
    #find the trash folder
    home_dir = os.path.realpath(os.path.expanduser("~"))
    dirs_name = path.split("/")
    dirs_name = filter(lambda name: name!="",dirs_name)
    trash_dir = None
    r = range(0,len(dirs_name))
    r.reverse()
    for i in r:
        tmp_path = os.path.realpath("/"+"/".join(dirs_name[:i]))
        if tmp_path == home_dir:
            trash_dir = home_dir+"/.Trash"
            break
        elif os.path.ismount(tmp_path):
            trash_dir = tmp_path+"/.Trash-"+os.environ.get("USER")
            break
        else: continue
    if not trash_dir:
        return False
    if not os.path.exists(trash_dir):
        try:os.makedirs(trash_dir,"0777")
        except: return False

    if path.rfind("/")!=-1:
        filename = path[path.rindex("/")+1:]
    try: shutil.move(path,trash_dir+"/"+filename)
    except: return False
    else: return True

def str_size(nb,average=0,base=1024):
    if average!=0:
        average +=1
    nb = float(nb)
    size_format = ""
    if base==1024:
        units = _("B KiB MiB GiB").split()
    else:
        units = _("B KB MB GB").split()
    for size_format in units:
        if len("%d"%int(nb))<=3:
            break
        nb = float(nb)/float(base)
    nb = "%f"%round(nb,1)
    nb = nb[:nb.rfind(".")+average]+size_format
    return nb

def duration_to_string(value,default="",i=1000):
    if not value: return default
    duration = "%02d:%02d" % ((value/(60*i))%60, (value/(i))%60)
    if value/(60*i)/60>=1:
        duration = "%d:"%(value/(60*i)/60)+duration
    return duration

""" Parse a date and return a time object """
""" Date like  Thu, 02 02 2005 10:25:21 ... """
def strdate_to_time(date):
    #removing timezone
    c = date[-5:-4]
    if (c == '+') or (c == '-'):
        date = date[:-6]

    #FIXME : don't remove use it in strptime
    c = date[-3:]
    if c in ["GMT","CST","EST","PST","EDT","PDT","MST","MDT"]:
        date = date[:-3]

    #Remove day because some field have incorrect string
    c = date.rfind(",")
    if c!=-1:
        date = date [c+1:]
    date = date.strip()

    #trying multiple date formats
    new_date = None

    #Set locale to C to parse date
    locale.setlocale(locale.LC_TIME, "C")

    formats = ["%d %b %Y %H:%M:%S",#without day, short month
                "%d %B %Y %H:%M:%S",#without day, full month
                "%d %b %Y",#only date , short month
                "%d %B %Y",#only date , full month
                "%b %d %Y %H:%M:%S",#without day, short month
                "%B %d %Y %H:%M:%S",#without day, full month
                "%b %d %Y",#only date , short month
                "%B %d %Y",#only date , full month
                ]
    for format in formats:
        try:
            new_date = strptime(date,format)
        except ValueError:
            continue

    locale.setlocale(locale.LC_TIME, '')
    if new_date is None:
        return ""

    return mktime(new_date)

import shutil
import fcntl
import cPickle
def save_db(objs,fn):
    fn=const.CONFIG_DIR+fn
    f = file(fn + ".tmp", "w")
    fcntl.flock(f.fileno(), fcntl.LOCK_EX)
    cPickle.dump(objs, f, cPickle.HIGHEST_PROTOCOL)
    f.close()
    os.rename(fn + ".tmp", fn)   
    
def load_db(fn):   
    fn=const.CONFIG_DIR+fn     
    objs = None
    if os.path.exists(fn):
        f = file(fn, "rb")
        objs = cPickle.load(f)
        """try: objs = cPickle.load(f)
        except:
            print _("W: %s is not a Listen database.") % fn
            try: shutil.copy(fn, fn + ".not-valid")
            except: pass
            objs = None"""
        f.close()
    return objs




""" Convert apple timestamp for ipod """
def time_unix_to_mac(time):
    return time+2082844800
def time_mac_to_unix(time):
    return time-2082844800


""" Remove accents if unicodedata module is present """
#http://wikipython.flibuste.net/moin.py/JouerAvecUnicode
_reptable = {}
def _fill_reptable():
    _corresp = [
        (u"A",  [0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x0100,0x0102,0x0104]),
        (u"AE", [0x00C6]),
        (u"a",  [0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x0101,0x0103,0x0105]),
        (u"ae", [0x00E6]),
        (u"C",  [0x00C7,0x0106,0x0108,0x010A,0x010C]),
        (u"c",  [0x00E7,0x0107,0x0109,0x010B,0x010D]),
        (u"D",  [0x00D0,0x010E,0x0110]),
        (u"d",  [0x00F0,0x010F,0x0111]),
        (u"E",  [0x00C8,0x00C9,0x00CA,0x00CB,0x0112,0x0114,0x0116,0x0118,0x011A]),
        (u"e",  [0x00E8,0x00E9,0x00EA,0x00EB,0x0113,0x0115,0x0117,0x0119,0x011B]),
        (u"G",  [0x011C,0x011E,0x0120,0x0122]),
        (u"g",  [0x011D,0x011F,0x0121,0x0123]),
        (u"H",  [0x0124,0x0126]),
        (u"h",  [0x0125,0x0127]),
        (u"I",  [0x00CC,0x00CD,0x00CE,0x00CF,0x0128,0x012A,0x012C,0x012E,0x0130]),
        (u"i",  [0x00EC,0x00ED,0x00EE,0x00EF,0x0129,0x012B,0x012D,0x012F,0x0131]),
        (u"IJ", [0x0132]),
        (u"ij", [0x0133]),
        (u"J",  [0x0134]),
        (u"j",  [0x0135]),
        (u"K",  [0x0136]),
        (u"k",  [0x0137,0x0138]),
        (u"L",  [0x0139,0x013B,0x013D,0x013F,0x0141]),
        (u"l",  [0x013A,0x013C,0x013E,0x0140,0x0142]),
        (u"N",  [0x00D1,0x0143,0x0145,0x0147,0x014A]),
        (u"n",  [0x00F1,0x0144,0x0146,0x0148,0x0149,0x014B]),
        (u"O",  [0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x00D8,0x014C,0x014E,0x0150]),
        (u"o",  [0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x00F8,0x014D,0x014F,0x0151]),
        (u"OE", [0x0152]),
        (u"oe", [0x0153]),
        (u"R",  [0x0154,0x0156,0x0158]),
        (u"r",  [0x0155,0x0157,0x0159]),
        (u"S",  [0x015A,0x015C,0x015E,0x0160]),
        (u"s",  [0x015B,0x015D,0x015F,0x01610,0x017F]),
        (u"T",  [0x0162,0x0164,0x0166]),
        (u"t",  [0x0163,0x0165,0x0167]),
        (u"U",  [0x00D9,0x00DA,0x00DB,0x00DC,0x0168,0x016A,0x016C,0x016E,0x0170,0x172]),
        (u"u",  [0x00F9,0x00FA,0x00FB,0x00FC,0x0169,0x016B,0x016D,0x016F,0x0171]),
        (u"W",  [0x0174]),
        (u"w",  [0x0175]),
        (u"Y",  [0x00DD,0x0176,0x0178]),
        (u"y",  [0x00FD,0x00FF,0x0177]),
        (u"Z",  [0x0179,0x017B,0x017D]),
        (u"z",  [0x017A,0x017C,0x017E])
        ]
    global _reptable
    for repchar,codes in _corresp :
        for code in codes :
            _reptable[code] = repchar
_fill_reptable()
def remove_accents(s):
    """Suppression des accents et autres marques.
    @param s: le texte a nettoyer.
    @type s: str ou unicode
    @return: le texte nettoye de ses marques diacritiques.
    @rtype: unicode
    """
    if isinstance(s,str) :
        s = unicode(s,"utf8","replace")
    res = []
    for c in s :
        res.append(_reptable.get(ord(c),c))
    return u"".join(res)

#Exception need handle by the call function
def makedirs(uri,perm):
    dirs =  uri[uri.find("://")+3:].split("/")
    cur_dir = get_protocol(uri)
    for dir in dirs:
        cur_dir = cur_dir+"/"+dir
        if not gnomevfs.exists(cur_dir):
            gnomevfs.make_directory(cur_dir,perm)

""" du function in python """
def du(dir, files={}):
    S_IFMT = 0170000
    S_IFDIR = 0040000
    tsz = 0

    try: fns = os.listdir(dir)
    except: return 0

    if not files.has_key(dir): files[dir] = {}
    d = files[dir]

    for fn in fns:
        try:
            fn = os.path.join(dir, fn)
    
            info = os.lstat(fn)

            if info[stat.ST_MODE] & S_IFMT == S_IFDIR:
                sz = du(fn, files) + long(info[stat.ST_SIZE])
            else:
               sz = info[stat.ST_SIZE]
            d[fn] = sz
            tsz = tsz + sz
        except:
            continue
    return tsz

def url_hook(widget,site):
    website(site)

def website(site):
    site = site.replace("\\", "\\\\").replace("\"", "\\\"")
    for s in (["gnome-open","sensible-browser"] +
              os.environ.get("BROWSER","").split(":")):
        if iscommand(s):
            if "%s" in s:
                s = s.replace("%s", '"' + site + '"')
                s = s.replace("%%", "%")
            else: s += " \"%s\"" % site
            if os.system(s + " &") == 0: return True
    else: return False

def iscommand(s):
    """True if 's' exists in the user's path, or is a fully-qualified
    existing path."""

    if s == "" or os.path.sep in s:
        return os.path.exists(s)
    else:
        s = s.split()[0]
        for p in os.environ["PATH"].split(os.path.pathsep):
            p2 = os.path.join(p, s)
            if os.path.exists(p2): return True
        else: return False

# http://developer.gnome.org/doc/API/2.0/glib/glib-running.html
if "G_FILENAME_ENCODING" in os.environ:
    fscoding = os.environ["G_FILENAME_ENCODING"].split(",")[0]
    if fscoding == "@locale": fscoding = locale.getpreferredencoding()
elif "G_BROKEN_FILENAMES" in os.environ:
    fscoding = locale.getpreferredencoding()
else: fscoding = "utf-8"

def fsdecode(s):
    """Decoding a string according to the filesystem encoding."""
    if isinstance(s, unicode): return s
    else: return decode(s, fscoding)

def fsencode(s):
    """Encode a string according to the filesystem encoding, replacing
    errors."""
    if isinstance(s, str): return s
    else: return s.encode(fscoding, 'replace')

def decode(s, charset="utf-8"):
    """Decode a string; if an error occurs, replace characters and append
    a note to the string."""
    try: return s.decode(charset)
    except UnicodeError:
        return s.decode(charset, "replace") + " " + _("[Invalid Encoding]")

def encode(s, charset="utf-8"):
    """Encode a string; if an error occurs, replace characters and append
    a note to the string."""
    try: return s.encode(charset)
    # FIXME: Can *this* happen?
    except UnicodeError:
        return (s + " " + _("[Invalid Encoding]")).encode(charset, "replace")

