# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import re
import gobject
import gnomevfs
import urllib

import utils
from song import Song,sType

"""
    html = get_shoutcast_directory("TopTen",1)
    print get_webradio(html)
"""
SHOUCAST_URL = "http://www.shoutcast.com/"
PLAYLIST_PATTERN = SHOUCAST_URL+"sbin/shoutcast-playlist.pls?rn=%s&file=filename.pls"
class ShoutcastBrowser:
    conf_prefix = "shoutcast"
    def __init__(self):
        self.categorie = []
        
        """ code:list of WebRadio """
        self.cache = {}
        
    """
    Return Categorie dict (key:Name)
    """
    def load(self):
        #FIXME: Add a timeout to refresh categorie
        """ retreive the home page to get categorie """
        if len(self.categorie)>0 : return self.categorie
        html = self.get_shoutcast_directory("TopTen",1)
        m = re.search('<b>Comprehensive Genre List:</b>([.\S\s]*)<b>Limit by Bandwidth</b>',html)
        if not m : 
            print "E:ShoutcastBrowser:Failed to retreive categorie list"
            return {}
        options = m.group(1)
        m = re.findall('<OPTION VALUE="(.+)">(.+)',options)
        for res in m :
            self.categorie.append((res[0],res[1]))
        return self.categorie
    
    def get_shoutcast_directory(self,genre,nb_page=None):
        nb_result = 100 #Locked by shoutcast
        if genre == "TopTen": 
            nb_result = 25
            nb_page = 1
        current_page = 0
        html = ""
        while nb_page==None or current_page < nb_page:
            #print "Retrieve information..."
            """ gnomevfs freeze sometimes use urllib intead """
            #handle_read = gnomevfs.Handle(SHOUCAST_URL+"directory/?numresult=%d&startat=%d&sgenre=%s"%(nb_result,current_page*nb_result,genre))
            
            #FIXME: add proxy
            opener = urllib.FancyURLopener({})
            url = SHOUCAST_URL+"directory/?numresult=%d&startat=%d&sgenre=%s"%(nb_result,current_page*nb_result,gnomevfs.escape_string(genre))
            print "->",url
            try: handle_read = opener.open(url)
            except IOError: return ""
        
            buffer_len = 1024
            
            #print "Reading stream..."
            data = handle_read.read(buffer_len)
            html += data
            while len(data)==1024:
                data = handle_read.read(buffer_len)
                html += data

            current_page += 1
            if current_page > 10 : current_page= 1000000
            handle_read.close()
            print "Stream OEF",nb_page,nb_page==None or current_page < nb_page
            #print "----------------",html
            if nb_page==None:
                m = re.search('Page (\d+) of (\d+)',html)
                if m:
                    print "Page found:",m.group(2)
                    nb_page = int (m.group(2))
                else: #No stream found or 1 page
                    return html
        
        return html
    
    """ 
    This function are threaded 
    it must launch "func_cb(key_categorie,songs)" in a gobject.idle_add
    to populate the song view
    """
    def get_iradio_songs(self,key_categorie,func_cb):
        #FIXME: flush the cache sometimes
        if self.cache.has_key(key_categorie):
            gobject.idle_add(func_cb,key_categorie,self.cache[key_categorie])          
            return 
        
        songs = []    
        html = self.get_shoutcast_directory(key_categorie)
        if not html:
            #Hack to don't code any thing to send no radio on widget
            s = Song()
            s.set_type(sType.LOCAL_FILE)
            s["title"] = _("No radio found")
            gobject.idle_add(func_cb,key_categorie,[s])    
            return 
        row_pattern = """
<tr>.*?<td colspan="12" nowrap align="center"></td>.*?</tr>
(.*?)
<td nowrap align="center" bgcolor="#001E5A" width="10">&nbsp;</td>.*?</tr>
""".replace("\n","")

        radio_pattern = """
<a href="/sbin/shoutcast-playlist\.pls\?rn=(\d+)&file=filename.pls">
.*?<a id="listlinks" target="_scurl" href="(?P<siteweb>[^"]+)">(?P<radioname>[^<]+)</a>
.*?<td nowrap align="center" bgcolor="#.*?"><font face="Arial, Helvetica" size="2" color="#.*?">(?P<person>[0-9]+)/(?P<personmax>[0-9]+)</font></td>
.*?<td nowrap align="center" bgcolor="#.*?">
<font face="Arial, Helvetica" size="2" color="#.*?">(?P<biterate>\d+)</font></td>
""".replace("\n","")

        rows = re.findall(row_pattern,html,re.S)
        for row in rows:
            tradios = re.findall(radio_pattern,row,re.S)
            for info_radio in tradios:
                try:
                    w = Song()
                    w.set_type(sType.REMOTE_WEBRADIO)
                    w["uri"] = PLAYLIST_PATTERN%info_radio[0]
                    w["is_pls"] = True # Important for player it will read the playlist and choose en stream to read
                    w["album"] = info_radio[1].decode("windows-1252")
                    w["title"] = info_radio[2].decode("windows-1252")
                    #w["now_playing"] = info_radio[3]
                    w["#person"] = info_radio[3]#.decode("windows-1252")
                    w["#max_person"] = info_radio[4]#.decode("windows-1252")
                    try:w["#bitrate"] = int(info_radio[5])*1000#.decode("windows-1252")
                    except:pass
                    songs.append(w)
                except Exception, e: 
                    print "E: Error decoding radio data :",e
                
        print "Found web radio: ", len(songs)
        self.cache[key_categorie] = songs
        gobject.idle_add(func_cb,key_categorie,songs)
            

