# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk,gobject,pango
from time import time,sleep
import threading

import const, utils , config

from widget.misc import ScrolledWindow
from widget.view import MultiDragTreeview
from widget.song_view import *
from helper import helper

from song import sType

def make_label(text):
    label = gtk.Label()
    label.set_use_markup(True)
    label.set_markup("<span size=\"large\"><b>"+text+"</b></span>")
    label.set_alignment(0,0.5)
    label.set_size_request(-1,22)
    label.set_ellipsize(pango.ELLIPSIZE_END)
    box = gtk.HBox(False,6)
    box.pack_start(gtk.Arrow(gtk.ARROW_RIGHT,gtk.SHADOW_NONE),False,False)
    box.pack_start(label,True,True)
    return box

class ContextBox(gtk.HBox):
    def __init__(self,player):
        super(ContextBox,self).__init__(True,6)
        
        
        #LASTEST
        self.lastest_view = ContextSongView("lastplayed")
        #PREFERED
        self.prefered_song_view = ContextSongView("playcount")
        
        self.albums_view = AlbumView(True)
        
        
        box = gtk.VBox(False,6)
        box.pack_start(make_label(_("Favorite albums")),False,False)
        box.pack_start(ScrolledWindow(self.albums_view),True,True)
        self.pack_start(box,True,True)
        
        box = gtk.VBox(False,6)
        box.pack_start(make_label(_("Favorite songs")),False,False)
        box.pack_start(ScrolledWindow(self.prefered_song_view),True,True)
        box.pack_start(make_label(_("Last played songs")),False,False)
        box.pack_start(ScrolledWindow(self.lastest_view),True,True)
        self.pack_start(box,True,True)
        
        player.connect("new-song",self.refresh)
        
        self.update = False
        
        self.condition = threading.Condition()
        t = threading.Thread(target=self.thread)
        t.setDaemon(True)
        t.start()

        helper.connect("library-loaded",self.__library_loaded)
        
    def __library_loaded(self,helper,library):
        if config.get("source", "context")!="1": return 
        self.condition.acquire()
        self.update = True
        self.condition.notify()
        self.condition.release()

    def refresh(self,*data):
        gobject.timeout_add(1500,self.idle_refresh)
        
    def idle_refresh(self):
        if config.get("source", "context")!="1": return 
        self.condition.acquire()    
        self.update = True
        self.condition.notify()
        self.condition.release()
        
        
    def thread(self):
        while True:
            self.condition.acquire()
            pl = library_wrapper.get_library("local").get_pl_master()
            while not self.update or not pl:
                self.condition.wait()
                pl = library_wrapper.get_library("local").get_pl_master()
            self.update = False
            self.condition.release()    
            
            if pl:
                songs = pl.get_songs()
                songs = [(song.get("#lastplayed"),song) for song in songs if song.get("#lastplayed")]
                songs.sort()
                songs.reverse()
                songs_lastest = [song[1] for song in songs[:const.CONTEXT_SONG_NUMBER]]

                songs = pl.get_songs()
                songs = [(song.get("#playcount"),song) for song in songs if song.get("#playcount")]
                songs.sort()
                songs.reverse()
                songs = songs[:const.CONTEXT_SONG_NUMBER]
                songs_prefered = [song[1] for song in songs[:const.CONTEXT_SONG_NUMBER]]  
            
                def build_row(album,info):
                    
                    if album=="":
                        title = _("Unknown")
                    else:
                        title = utils.xmlescape(album)
                    nb_song = len(info[0])
                    if nb_song<=1:
                        value = _("song")
                    else:
                        value = _("songs")
        
                    duration  = " - "+utils.duration_to_string(info[2])
        
                    songs = [pl.library.get_song(uri) for uri in info[0]]
                    songs.sort()
                    if not songs[0].get("artist"):
                        title += " - <i>"+_("Unknown")+"</i>"
                    else:
                        title += " - <i>"+songs[0].get_str("artist",True)+"</i>"
        
                    markup = "<b>"+title + "</b>\n%d"%nb_song+" "+value+duration
                    
                    try:pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(songs[0].get_cover(False),40,40)
                    except gobject.GError: pixbuf = const.DEFAULT_COVER_PIXBUF
                    return (songs,markup,pixbuf)
                
                albums_prefered = [(info[1],album,info) for album,info in library_wrapper.get_library("local").albums_cache.iteritems() if album]
                albums_prefered.sort()
                albums_prefered.reverse()
                
                albums_prefered = [build_row(album,info) for playcount,album,info in albums_prefered[:const.CONTEXT_SONG_NUMBER]]
                
            else:
                albums_prefered = []
                songs_prefered = []
                songs_lastest = []
            
            self.condition.acquire()
            if not self.update:
                gobject.idle_add(self.refresh_album,albums_prefered)
                gobject.idle_add(self.lastest_view.get_model().fill,songs_lastest) 
                gobject.idle_add(self.prefered_song_view.get_model().fill,songs_prefered)   
            self.condition.release()
            
    def refresh_album(self,albums):
        self.albums_view.model_song.clear()
        for album in albums:
            self.albums_view.model_song.append(album)
        
class CurrentInfoBox(gtk.HBox):
    def __init__(self,player):
        super(CurrentInfoBox,self).__init__(False,6)
        
        #LASTEST
        self.lastest_view = ContextSongView("lastplayed")
        #PREFERED
        self.prefered_song_view = ContextSongView("playcount")
        self.albums_view = AlbumView(True)
        
        self.albums_label = make_label(utils.xmlescape(_("Albums by")))
        self.prefered_label = make_label(utils.xmlescape(_("Favorite songs of")))
        self.lastest_label = make_label(utils.xmlescape(_("Last played songs of")))
        
        song_box = gtk.VBox(False,6)
        song_box.pack_start(self.albums_label,False,False)
        song_box.pack_start(ScrolledWindow(self.albums_view),True,True)
        self.pack_start(song_box,True,True)
        
        song_box = gtk.VBox(False,6)
        song_box.pack_start(self.prefered_label,False,False)
        song_box.pack_start(ScrolledWindow(self.prefered_song_view),True,True)
        song_box.pack_start(self.lastest_label,False,False)
        song_box.pack_start(ScrolledWindow(self.lastest_view),True,True)
        self.pack_start(song_box,True,True)
        
        player.connect("new-song",self.refresh)
        
        self.cur_song = None

        self.condition = threading.Condition()
        t = threading.Thread(target=self.thread)
        t.setDaemon(True)
        t.start()
        
        helper.connect("library-loaded",self.__library_loaded)

    def __library_loaded(self,helper,library):
        if config.get("source", "current")!="1": return
        self.condition.acquire()
        self.condition.notify()
        self.condition.release()

        
    def refresh(self,player,song):
        if config.get("source", "current")!="1": return
        if not song: return     
        if song.get_type() in [sType.LOCAL_FILE, sType.REMOVABLE_FILE, sType.REMOTE_FILE, sType.AUDIOCD_TRACKS]:
            self.condition.acquire()    
            self.cur_song = song
            self.condition.notify()
            self.condition.release()
            self.albums_label.get_children()[1].set_markup("<span size=\"large\"><b>"+utils.xmlescape(_("Albums by")) +" "+ song.get_str("artist",True)+"</b></span>")
            self.prefered_label.get_children()[1].set_markup("<span size=\"large\"><b>"+utils.xmlescape(_("Favorite songs of")) +" "+ song.get_str("artist",True)+"</b></span>")
            self.lastest_label.get_children()[1].set_markup("<span size=\"large\"><b>"+utils.xmlescape(_("Last played songs of")) +" "+ song.get_str("artist",True)+"</b></span>")
            
        else:   
            self.cur_song = song
            print "W:Context Refresh Not implemented for this Song type",self.cur_song.get_type()
            return
        
        
    def thread(self):
        while True:
            self.condition.acquire()
            pl = library_wrapper.get_library("local").get_pl_master()
            while not self.cur_song or not pl:
                self.condition.wait()
                pl = library_wrapper.get_library("local").get_pl_master()
            cur_song = self.cur_song
            self.cur_song = None
            self.condition.release()
            
            if pl:
                artist = cur_song.get("artist")
                songs = pl.get_songs()
                songs = [(song.get("#lastplayed"),song) for song in songs if song.get("#lastplayed") and cur_song.get("artist")==song.get("artist")]
                songs.sort()
                songs.reverse()
                songs_lastest = [song[1] for song in songs[:const.CONTEXT_SONG_NUMBER]]
            
                songs = pl.get_songs()
                songs = [(song.get("#playcount"),song) for song in songs if song.get("#playcount") and cur_song.get("artist")==song.get("artist")]
                songs.sort()
                songs.reverse()
                songs_prefered = [song[1] for song in songs[:const.CONTEXT_SONG_NUMBER]]  
            
                def build_row(album,info):
                    
                    if album=="":
                        title = _("Unknown")
                    else:
                        title = utils.xmlescape(album)
                    nb_song = len(info[0])
                    if nb_song<=1:
                        value = _("song")
                    else:
                        value = _("songs")
        
                    duration  = " - "+utils.duration_to_string(info[2])
        
                    songs = [pl.library.get_song(uri) for uri in info[0]]
                    songs.sort()
                    markup = "<b>"+title + "</b>\n%d"%nb_song+" "+value+duration
                    return (songs,markup,gtk.gdk.pixbuf_new_from_file_at_size(songs[0].get_cover(False),40,40))
                
                albums_prefered = [(info[1],album,info) for album,info in library_wrapper.get_library("local").albums_cache.iteritems() if info[3]==cur_song.get("artist")]
                albums_prefered.sort()
                albums_prefered.reverse()
            
                albums_prefered = [build_row(album,info) for playcount,album,info in albums_prefered]
            else:
                songs_lastest = []
                songs_prefered = []
                albums_prefered = []
            
            
            
            self.condition.acquire()
            if not self.cur_song:
                gobject.idle_add(self.prefered_song_view.get_model().fill,songs_prefered) 
                gobject.idle_add(self.lastest_view.get_model().fill,songs_lastest) 
                gobject.idle_add(self.refresh_album,albums_prefered)    
            self.condition.release()
        
        
        
    def refresh_album(self,albums):
        self.albums_view.model_song.clear()
        for album in albums:
            self.albums_view.model_song.append(album)
        
class ContextSongView(SongView):
    show_all_columns = True
    def __init__(self,info_to_display,show_album=True):
        
        self.info_to_display = info_to_display
        self.show_album = show_album
        
        pl = library_wrapper.get_library("local").get_pl_master()
        super(ContextSongView,self).__init__(pl,title=(1,gobject.TYPE_STRING))
        
        self.set_menu(SongMenu(pl))

        self.set_headers_visible(False)
        
        c = self.get_column(0)
        c.set_cell_data_func(c.get_cell_renderers()[0], self.cell_data_func)

        helper.connect("library-loaded",self.__library_loaded)

    def __library_loaded(self,helper,library):
        if library_wrapper.get_library("local") == library:
            self.pl = library.get_pl_master()
            self.set_menu(SongMenu(self.pl))

    def cell_data_func(self, column, cell, model, iter):
        song = model.get_value(iter, 0)
        text = "<span><b>"+song.get_str("title",True)+"</b></span><span size=\"small\">"
        if self.info_to_display=="playcount":
            text +=  " <i>"+_("played")+" "+song.get_str("#playcount",True)+" "+_("times")+"</i>"
        elif self.info_to_display=="lastplayed":
            if False and song.get("#lastplayed")!=None:
                text += " <i>"+_("played")+" "+utils.duration_to_string(time()-song.get("#lastplayed"),"00:00",1)+" "+_("ago")+"</i>"
                
        sep = ""
        if song.get("artist"):
            sep = " - "
            text += "\n<i>"+song.get_str("artist",True)+"</i>"
        if self.show_album and song.get("album"):
            text += sep+song.get_str("album",True)
        text += "</span>"

        cell.set_property("markup",text )

class AlbumView(MultiDragTreeview):
    def __init__(self,show_artist=False):
        super(AlbumView,self).__init__()

        self.show_artist = show_artist
        self.model_song = gtk.ListStore(object,str,gtk.gdk.Pixbuf)

        self.renderer_cover = gtk.CellRendererPixbuf()
        self.renderer_cover.set_property("height",50)
        self.renderer_cover.set_property("width",50)
        
        self.renderer_album = gtk.CellRendererText()
        self.renderer_album.set_property("height",50)
        self.renderer_album.set_property("ellipsize",pango.ELLIPSIZE_END)
        #self.renderer_album.set_property("yalign",0)

        targets = [("text/listen-songs", gtk.TARGET_SAME_APP, 1),("text/uri-list", 0, 2)]
        self.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK|gtk.gdk.SHIFT_MASK|gtk.gdk.CONTROL_MASK, targets,
            gtk.gdk.ACTION_COPY)

        self.column_cover = gtk.TreeViewColumn("",self.renderer_cover,pixbuf=2)
        self.column_album = gtk.TreeViewColumn("",self.renderer_album,markup=1)
        self.column_album.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)

        self.append_column(self.column_cover)
        self.append_column(self.column_album)
        self.set_headers_visible(False)
        self.set_rules_hint(True)
        self.connect("row-activated", self.on_row_song_activated)
        self.connect("drag-data-get", self.on_song_drag_data_get)
        self.connect("popup-menu",self.__popup_menu)

        pl = library_wrapper.get_library("local").get_pl_master()
        
        self.set_model(self.model_song)
        self.menu = SongMenu(pl,edit=False,delete=False,deletedisk=False)

        helper.connect("library-loaded",self.__library_loaded)

    def __library_loaded(self,helper,library):
        if library_wrapper.get_library("local") == library:
            self.pl = library.get_pl_master()
            self.menu = SongMenu(self.pl,edit=False,delete=False,deletedisk=False)

    def __popup_menu(self,widget):
        model,rows = self.get_selection().get_selected_rows()
        if len(rows)<0:
            return
        else:
            songs = []
            for row in rows: 
                songs.extend(model[row[0]][0])
            songs.sort()
            if self.menu and songs:
                self.menu.popup(songs)
                
    def on_row_song_activated(self, treeview, path, view_column):
        model, rows = self.get_selection().get_selected_rows()
        for row in rows:
            songs = model.get_value(model.get_iter(row[0]),0)
            songs.sort()
            helper.cur_playlist_play(songs)


    def on_song_drag_data_get(self,treeview, context, selection, info, timestamp):

        model,rows = treeview.get_selection().get_selected_rows()
        if len(rows)<0:
            return
        else:
            songs = []
            for row in rows: 
                songs.extend(model[row[0]][0])
        songs.sort()
        list_uri = list([ song.get("uri") for song in songs])
        selection.set("text/listen-songs", 8, "\n".join(list_uri))
        selection.set_uris(list_uri)



        
