# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import os,sys
import gobject, gtk, pango
import urllib

import amazon

import utils, stock, const

from song import Song
from widget.dialog import WindowBase
from web_threading import WebFetchThread

from helper import helper

import threading

PREVIEW_SIZE = gtk.icon_size_register("preview-cover", const.COVER_SIZE["x"],const.COVER_SIZE["y"])
        
class CoverButton(gtk.Button):
    def __init__(self,halign="top",valign="left"):
        super(CoverButton,self).__init__()
        
        self.halign=halign
        self.valign=valign
        self.set_alignment(0.5,0.5)
        self.set_relief(gtk.RELIEF_NONE)

        image = gtk.image_new_from_stock(stock.ALBUM_ART, PREVIEW_SIZE )
        image.set_size_request(const.COVER_SIZE["x"],const.COVER_SIZE["y"])
        image.set_alignment(0.5,0.5)

        f = gtk.Frame()
        f.add(image)
        f.set_shadow_type(gtk.SHADOW_IN)

        self.add(f)

        utils.set_tip(self,_("Right click: change album cover\nLeft click: show big cover"))

        helper.connect("changed",self.update_cover)

        self.current_song = None
        
        self.next_cover_to_download = None
        
        self.win_preview = gtk.Window(gtk.WINDOW_POPUP)
        self.win_preview.add(gtk.Image())
        
        self.connect('button-press-event', self.__press)
        self.connect('button-release-event', self.__release)

        self.condition = threading.Condition()
        self.thread = threading.Thread(target=self.func_thread)
        self.thread.setDaemon(True)
        self.thread.start()
        
        
    def func_thread(self):
        while True:
            self.condition.acquire()
            while not self.next_cover_to_download:
                self.condition.wait()
            next_cover_to_download = self.next_cover_to_download
            self.next_cover_to_download = None 
            self.condition.release()
            
            self.set_current_cover(True,next_cover_to_download)
        
    def __press(self, widget, event):
        if event.button==1:
            if self.current_song:
                self.win_preview.child.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file(self.current_song.get_cover(False)))
                self.win_preview.realize()
                x,y = self.child.child.window.get_origin()
                if self.halign != "top":
                    y = y - self.win_preview.allocation.height + self.child.child.allocation.height
                if self.valign != "left":
                    x = x - self.win_preview.allocation.width
                x = x+self.child.child.allocation.x
                y = y+self.child.child.allocation.y
                self.win_preview.move(int(x),int(y))
                self.win_preview.show_all()
            return True
        else:
            return False
            
    def __release(self, widget, event):   
        if event.button==1:    
            if self.current_song:     
                self.win_preview.hide_all()
            return True
        elif event.button==3:
            self.open_cover_dialog()
            return True
        else:
            return False
        
    def open_cover_dialog(self,widget=None):
        if self.current_song: AmazonWindow(self.current_song)

    def update_default_cover(self,widget,song):
        if not self.current_song or self.current_song.get_cover_search_str() != song.get_cover_search_str():
            self.child.child.set_from_pixbuf(const.DEFAULT_COVER_PIXBUF_BIG)
        
    def update_cover(self,widget,songs):
        if isinstance(songs,list):
            if self.current_song in songs:
                self.current_song = songs[songs.index(self.current_song)]
        else:
            self.current_song = songs

        if self.current_song!=None:
            if not self.set_current_cover(False):
                self.condition.acquire()  
                self.next_cover_to_download = self.current_song
                self.condition.notify()
                self.condition.release()


    def set_current_cover(self,try_amazon=True,force_song=None):
        if not force_song:
            force_song = self.current_song
        filename = force_song.get_cover(try_amazon)
        try:pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename,const.COVER_SIZE["x"],const.COVER_SIZE["y"])
        except gobject.GError:pass
        else:
            """ If try amazon the call is in thread then use of idle_add """
            if try_amazon:
                gobject.idle_add( self.child.child.set_from_pixbuf,pixbuf)
                del pixbuf
            else:
                self.child.child.set_from_pixbuf(pixbuf)
                del pixbuf
                return const.DEFAULT_COVER!=filename

class PopupWindowCoverButton(gtk.Window):
    def __init__(self):    
        super(PopupWindowCoverButton,self).__init__(gtk.WINDOW_POPUP)
        self.add(CoverButton())
        
        self.id_hide_preview = None
            
        self.connect("enter-notify-event",self.stop_timeout_hide_cover)
        self.connect("leave-notify-event",self.timeout_hide_cover)
        self.child.child.connect("enter-notify-event",self.stop_timeout_hide_cover)
        self.child.child.connect("leave-notify-event",self.timeout_hide_cover)
        self.child.win_preview.connect("show",self.stop_timeout_hide_cover)
        self.child.win_preview.connect("leave-notify-event",self.timeout_hide_cover)
    
    def show_cover(self,song):
        self.stop_timeout_hide_cover()
        self.child.update_cover(None,song)
    
    def timeout_hide_cover(self,*param):
		self.id_hide_preview = gobject.timeout_add(500,self.hide_cover)
        
    def hide_cover(self,*param):
        self.hide_all()
        self.child.win_preview.hide_all()
        
    def stop_timeout_hide_cover(self,*param):
        if self.id_hide_preview!=None: 
            gobject.source_remove(self.id_hide_preview)
            self.hide_cover()
        
class PlayerCoverButton(CoverButton):
    def __init__(self,player):
        super(PlayerCoverButton,self).__init__()    
    
        player.connect("new-song",self.update_cover)
        player.connect("instant-new-song",self.instant_update_cover)
       
    def instant_update_cover(self,widget,song):
        if not song.get_cover(False):
            self.update_default_cover(widget,song)
        else:
            self.update_cover(widget,song)

import re
class AmazonWindow(WindowBase):
    def __init__(self,current_song):
        self.song = Song(current_song)
        self.song.set_type(current_song.get_type())
        image = gtk.Image()
        image.set_from_file(self.song.get_cover(False))
        f = gtk.Frame()
        f.set_shadow_type(gtk.SHADOW_IN)
        f.add(image)
        WindowBase.__init__(self,_("Search an album cover"),None,())

        default_search = utils.remove_accents(self.song.get_cover_search_str())
        #default_search = self.song.get_str("album")
        
        
        self.select = gtk.combo_box_new_text()
        self.select.append_text(_("From Amazon"))
        self.select.append_text(_("From Google Image"))
        self.select.set_active(0)
        self.select.connect("changed",self.change_source)
        
        self.entry = gtk.Entry()
        self.entry.set_text(default_search.replace("+"," "))
        self.entry.set_size_request(300,-1)
        self.entry.connect("activate",self.on_search,1)

        btn_search = gtk.Button(stock=gtk.STOCK_FIND)
        btn_search.connect("clicked",self.on_search,1)
        hbox = gtk.HBox(False,12)
        hbox.pack_start(self.entry,True,True)
        hbox.pack_start(self.select,False,False)
        hbox.pack_start(btn_search,False,False)

        self.box_resultat = gtk.Table(4,2)

        vbox = gtk.VBox(False,0)
        vbox.pack_start(hbox,False,False)
        vbox.pack_start(self.box_resultat,False,False)
        self.add_widget(vbox)
        self.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
        self.add_button(gtk.STOCK_DELETE, gtk.RESPONSE_APPLY)
        self.add_button(gtk.STOCK_OPEN, gtk.RESPONSE_YES)
        self.add_button(gtk.STOCK_GO_BACK, gtk.RESPONSE_NO)
        self.add_button(gtk.STOCK_GO_FORWARD, gtk.RESPONSE_REJECT)

        self.label_error = gtk.Label(_("No result for this request"))
        self.label_error.set_alignment(0.5,0.5)
        self.label_error.set_size_request(-1,200)
        
        self.label_wait = gtk.Label(_("Please wait..."))
        self.label_wait.set_alignment(0.5,0.5)
        self.label_wait.set_size_request(-1,200)

        self.label_start = gtk.Label(" ")
        self.label_start.set_alignment(0.5,0.5)
        self.label_start.set_size_request(-1,200)

        self.box_resultat.resize(1,1)
        self.box_resultat.attach(self.label_start, 0, 1, 0, 1)

        self.download_thread = WebFetchThread(1024,self.fail_fetch)

        self.win_preview = gtk.Window(gtk.WINDOW_POPUP)
        self.win_preview.add(gtk.Image())
        
        self.current_page = 1
        self.show_all()
        self.action_area.get_children()[0].set_sensitive(False)
        self.action_area.get_children()[1].set_sensitive(False)
        reponse = self.run()
        while reponse not in [gtk.RESPONSE_CANCEL,gtk.RESPONSE_DELETE_EVENT]:
            if reponse == gtk.RESPONSE_NO:
                self.on_search(None,self.current_page-1)
            if reponse == gtk.RESPONSE_REJECT:
                self.on_search(None,self.current_page+1)
            if reponse == gtk.RESPONSE_YES:
                self.destroy()
                AlbumCoverWindow(self.song)
                return
            if reponse == gtk.RESPONSE_APPLY:
                new_file = self.song.get_cover_path()
                if os.path.exists(new_file):
                     os.unlink(new_file)
                pixbuf = const.DEFAULT_COVER_PIXBUF_BIG
                pixbuf.save(new_file+".#disable#", "jpeg", {"quality":"85"})
                helper.change_songs([self.song])
                self.destroy()
                return
            reponse = self.run()
        self.destroy()
    
    def fail_fetch(self,*args):
        self.current_page = 1
        self.box_resultat.foreach(self.box_resultat.remove)
        self.box_resultat.resize(1,1)
        self.box_resultat.attach(self.label_error, 0, 1, 0, 1)    
        self.action_area.get_children()[1].set_sensitive(False)
        self.action_area.get_children()[0].set_sensitive(False)
        self.show_all()
        print "W:AmazonWindow:Failed fetch"
        
    def change_source(self,w):
        self.current_page = 1
        self.on_search(None,1)
        
    def on_search(self,btn,page):
        self.box_resultat.foreach(self.box_resultat.remove)    
        self.box_resultat.resize(1,1)
        self.box_resultat.attach(self.label_wait, 0, 1, 0, 1)    
        self.action_area.get_children()[1].set_sensitive(False)
        self.action_area.get_children()[0].set_sensitive(False)    
        
        self.show_all()
        if self.select.get_active()==0:
            gobject.idle_add(self.on_search_amazon,page)   
        else:
            gobject.idle_add(self.on_search_google,page)  
        
        
    def on_search_google(self,page):
        art = self.entry.get_text().encode('utf-8')   
        if page%2==0:
            g_page = (page-1)*16
        else:
            g_page = (page-2)*16
        
        url = "http://images.google.com/images?svnum=10&hl=fr&lr=&start=%d&safe=off&q=%s"%(g_page,urllib.quote(art))
        
        self.download_thread.fetch_url(url,self.on_search_google_cb,page)
            
    def on_search_google_cb(self,html,page):
        
        html = html.read()
        res = re.findall("dyn.Img(.*?);",html,re.S)
        if not res : 
            self.fail_fetch()
            return 
        """
        TEMPLATE FOR GRABING COVER FROM GOOGLE 
        dyn.Img("http://musiques.mysic.fr/Artiste/Tryo&h=160&w=160&sz=8&hl=fr&sig2=gbJeAjLgIUEC1FCwxCdOMQ&start=4","","5SKdeaR4fTaiFM:","http://images.mysic.fr/B000B8520Y.01.M_Faut%2BQu%2BIls%2BS%2BActivent.jpg","98","98","<b>Faut</b> <b>Qu</b> <b>Ils</b> <b>S</b> <b>Activent</b>","","","160 x 160 pixels - 8 ko","jpg","musiques.mysic.fr","","")
        """
        mid = len(res)/2
        if page%2==0:
            res = res[ : mid-1 ]
        else:
            res = res[ mid : ]

        items = []
        for item in res:
            info = item.replace('dyn.Img("',"").replace('")',"").split('","')
            items.append((info[3],re.sub("<.*?>","",info[6]),""))
            
        self.populate(page,items)


    def on_search_amazon(self,page):
        art = self.entry.get_text().encode('utf-8')
        amazon.setLicense("0RKH4ZH1JCFZHMND91G2")
        try:
            bags = amazon.searchByKeyword(art,page=page,type="lite", product_line="music")
        except:
            self.fail_fetch()
            return
            
        items = []
        for bag in bags:
            artists = bag.Artists.Artist
            if isinstance(artists,list):
                artists = artists[0]    
            items.append((bag.ImageUrlLarge,bag.ProductName,artists))
            
        
        self.populate(page,items)
                

    def populate(self,page,items):
        self.box_resultat.foreach(self.box_resultat.remove)     
        self.current_page = page
        i = 0
        top_attach = 0
        left_attach = 0
        if self.current_page == 1:
            self.action_area.get_children()[1].set_sensitive(False)
        else:
            self.action_area.get_children()[1].set_sensitive(True)
        if len(items)<10:
            self.action_area.get_children()[0].set_sensitive(False)
        else:
            self.action_area.get_children()[0].set_sensitive(True)

        height= int(round(len(items)/2,1))
        if len(items)%2!=0: height += 1
        #if height>8 : height=8
        self.box_resultat.resize(height,2)

        for url,label1,label2 in items:

            
            image = gtk.Image()
            image.fullsize = None
            loader = gtk.gdk.PixbufLoader()
            loader.set_size(const.COVER_SAVE_SIZE["x"],const.COVER_SAVE_SIZE["y"])
            def on_closed(loader,image):
                if image!=None:
                    image.fullsize = loader.get_pixbuf()
                    if image.fullsize!=None:
                        image.set_from_pixbuf(image.fullsize.scale_simple(40,40, gtk.gdk.INTERP_NEAREST))
            loader.connect("closed", on_closed ,image)
            
            def thread(url,loader,image):
                def write(loader,data,image):
                    try:
                        loader.write(data)
                        loader.close()
                    except gobject.GError:
                        print "W:Webinfo:Incorrect image format"
                        pass
                try:sock = urllib.urlopen(url)
                except: 
                    try:loader.close()
                    except gobject.GError:pass
                else:
                    data = sock.read()
                    sock.close()
                    gobject.idle_add(write,loader,data,image)
                
            t = threading.Thread(target=thread,args=(url,loader,image))
            t.setDaemon(True)
            t.start()
            
            image.set_size_request(40,40)
            label = gtk.Label()
            label.set_markup("<b>"+utils.xmlescape(label1)+"</b>\n"+utils.xmlescape(label2))
            label.set_property("ellipsize",pango.ELLIPSIZE_END)
            label.set_alignment(0,0.5)
            box= gtk.HBox(False,6)
            box.pack_start(image,False,False)
            box.pack_start(label,True,True)

            btn_cover = gtk.Button()#"test-%d"%i)
            btn_cover.set_alignment(0.5,0.5)
            btn_cover.connect("clicked",self.on_cover_clicked)#,image_path)
        
            btn_cover.connect('button-press-event', self.__press)
            btn_cover.connect('button-release-event', self.__release)
        
            btn_cover.set_relief(gtk.RELIEF_NONE)
            btn_cover.add(box)
            right_attach = left_attach+1
            bottom_attach = top_attach+1
            self.box_resultat.attach(btn_cover, left_attach, right_attach, top_attach, bottom_attach)
            i += 1
            if i%2==0:
                top_attach += 1
                left_attach = 0
            else:
                left_attach += 1
        self.show_all()
      
    def __press(self, widget, event):
        if event.button==3:
            if widget.child.get_children()[0].fullsize:
                self.win_preview.child.set_from_pixbuf(widget.child.get_children()[0].fullsize)
                x,y = self.window.get_origin()
                self.win_preview.move(int(x+widget.child.get_children()[0].allocation.x),int(y+widget.child.get_children()[0].allocation.y))
                self.win_preview.show_all()
            return True
        else:
            return False
            
    def __release(self, widget, event):   
        if event.button==3: 
            if widget.child.get_children()[0].fullsize:    
                self.win_preview.hide_all()
            return True
        else:
            return False  
        
    def on_cover_clicked(self,btn):#,image_path):
        #pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(image_path,const.COVER_SIZE["x"],const.COVER_SIZE["y"])
        #pixbuf = btn.get_children()[0].get_children()[0].get_pixbuf()
        pixbuf = btn.get_children()[0].get_children()[0].fullsize
        self.song.remove_cover()
        new_file = self.song.get_cover_path()
        if os.path.exists(new_file):
             os.unlink(new_file)
        if os.path.exists(new_file+".#disable#"):
             os.unlink(new_file+".#disable#")
        pixbuf.save(new_file, "jpeg", {"quality":"85"})
        del pixbuf
        helper.change_songs([self.song])
        self.emit("response",gtk.RESPONSE_DELETE_EVENT)

class AlbumCoverWindow(gtk.FileChooserDialog):
    def __init__(self,current_song):
        song = Song(current_song)
        song.set_type(current_song.get_type())

        gtk.FileChooserDialog.__init__(self,_("Choose an album cover"), None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))

        btn = self.add_button(_("Internet search"),gtk.RESPONSE_HELP)
        btn.set_image(gtk.image_new_from_stock(gtk.STOCK_FIND, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.set_current_folder(os.path.expanduser("~/"))

        file = ''
        ffilter = gtk.FileFilter()
        ffilter.set_name(_("Image files"))
        ffilter.add_mime_type("image/bmp")
        ffilter.add_mime_type("image/gif")
        ffilter.add_mime_type("image/jpeg")
        ffilter.add_mime_type("image/png")
        ffilter.add_mime_type("image/svg+xml")

        self.add_filter(ffilter)
        self.set_size_request(500,350)
        
        response = self.run()
        if response == gtk.RESPONSE_OK:
            file = self.get_filename()
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(file,const.COVER_SAVE_SIZE["x"],const.COVER_SAVE_SIZE["y"])
            new_file = song.get_cover_path()
            if os.path.exists(new_file):
                 os.unlink(new_file)
            if os.path.exists(new_file+".#disable#"):
                 os.unlink(new_file+".#disable#")
            pixbuf.save(new_file, "jpeg", {"quality":"85"})
            del pixbuf
            helper.change_songs([song])
            self.destroy()
        elif response == gtk.RESPONSE_HELP:
            self.destroy()
            AmazonWindow(song)
        else:
            self.destroy()
