
/*
 * LaTeX Symbols Selector
 *
 * Copyright (C) 2006 Tomasz Mka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GUI_H
#define _GUI_H

#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gdk-pixdata.h>

enum {
    COL_PIXBUF = 0,
    COL_NAME,
    NUM_COLS
};

enum {
    SELECTED = 1,
    SENT_TO_GVIM = 2,
    SENT_TO_CLIPBOARD = 4
};

enum {
    GROUP_ACCENTS = 0,
    GROUP_ARROWS,
    GROUP_DELIMITERS,
    GROUP_GREEK_LETTERS,
    GROUP_MISCELLANEOUS,
    GROUP_OPERATORS,
    GROUP_RELATIONS,
    GROUP_TEXT_MODE,
    GROUP_AMS_ACCENTS,
    GROUP_AMS_ARROWS,
    GROUP_AMS_DELIMITERS,
    GROUP_AMS_MISCELLANEOUS,
    GROUP_AMS_OPERATORS,
    GROUP_AMS_RELATIONS
};

void        gui_create_window       (void);
void        display_names_list      (void);
void        set_cursor_on_group     (gint group);
void        display_symbols_list    (gint setnumber);


#endif /* _GUI_H */

