/*  Window monitor / client manager
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include <iostream>
#include "clientmgr.h"

using namespace std;

void ClientMgr::setMenuPref(unsigned long clientPtr, rfbServerDataMenuPrefReq *menuPref)
{
  localePrefMap[clientPtr] = string((char *)menuPref->locale);
}

void ClientMgr::setIconPref(unsigned long clientPtr, rfbServerDataIconPrefReq *_iconPref)
{
  IconPref iconPref;
  iconPref.bpp        = _iconPref->bpp;
  iconPref.size       = _iconPref->size;
  iconPref.formatType = _iconPref->formatType;
  iconPrefMap[clientPtr] = iconPref;
}

void ClientMgr::clientGone(unsigned long clientPtr)
{
  localePrefMap.erase(clientPtr);
  iconPrefMap.erase(clientPtr);
}

const string* ClientMgr::getLocalePref(unsigned long clientPtr)
{
  LocaleMap::iterator i = localePrefMap.find(clientPtr);
  if (i != localePrefMap.end())
    return &(i->second);
  return NULL;
}

const ClientMgr::IconPref* ClientMgr::getIconPref(unsigned long clientPtr)
{
  IconPrefMap::iterator i = iconPrefMap.find(clientPtr);
  if (i != iconPrefMap.end())
    return &(i->second);
  return NULL;
};

bool ClientMgr::foreachIconPref(IconPrefCallback func, void *_this, void* param)
{
  bool result = true;
  for (IconPrefMap::iterator i = iconPrefMap.begin(); i != iconPrefMap.end(); i++) {
    if (!(*func)(i->first, i->second, _this, param))
      result = false;
  }
  return result;
}


