/*  Window monitor / icon manager
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef ICONMGR_H
#define ICONMGR_H

#include <string>
#include <vector>
#include "clientmgr.h"
#include "conffile.h"

using namespace std;

class IconMgr {
  ClientMgr& clientMgr;
  struct Item {
    string dir;
    ConfigFile::SpItemMapMap index;
  };
  typedef vector<Item> ThemeList;
  ThemeList themeList;
  void addIconTheme(const char *theme);
  inline void addIconTheme(string &theme) {
    addIconTheme(theme.c_str());
  }
  bool lookupIcon(string& iconname, string& retPath, ClientMgr::IconPref& iconInfo, Item item);

 public:
  IconMgr(ClientMgr& clientMgr);
  ~IconMgr();

  void setIconTheme(const char *theme);
  inline void setIconTheme(string &theme) {
    setIconTheme(theme.c_str());
  }
  bool lookupIcon(string& iconname, unsigned long clientPtr, string& retPath, ClientMgr::IconPref& retIconInfo);
};

#endif /*ICONMGR_H*/
