/*  Window monitor / tmpfile manager
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "windowmonitor.h"
#include "tmpfilemgr.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

const char TmpFileMgr::tmpFileTemplate[] = "/tmp/metavnc-XXXXXX";

TmpFileMgr::TmpFileMgr()
{
}

TmpFileMgr::~TmpFileMgr()
{
  TmpFileDB::iterator it;
  for (it = tmpFileDB.begin(); it != tmpFileDB.end(); it++) {
DEBUG_PRINTF(("deleting %s\n", it->second.c_str()));
    unlink(it->second.c_str());
  }
  tmpFileDB.clear();
}

// lookup a temporary file from name
// name     : key
// realpath : pathname of the temporary file if found
// return value : file descriptor of the temporary file or -1 on error
int TmpFileMgr::lookupTmpFile(const string& name, string &realpath)
{
  TmpFileDB::iterator it = tmpFileDB.find(name);
  if (it == tmpFileDB.end())
    return -1;	// not found

  realpath = it->second;
  return open(realpath.c_str(), O_EXCL);
}

// create a temporary file from name
// name     : key
// realpath : pathname of the temporary file
// return value : file descriptor of the temporary file or -1 on error
int TmpFileMgr::createTmpFile(const string& name, string &realpath)
{
  TmpFileDB::iterator it = tmpFileDB.find(name);
  if (it != tmpFileDB.end())
    return -1;	// name already exists

  char *tmpname = strdup(tmpFileTemplate);
  int fd = mkstemp(tmpname);
  chmod(tmpname, 0644);
  realpath = tmpname;
  free(tmpname);

  if (fd == -1)
    return -1;	// error

  tmpFileDB.insert(TmpFileDB::value_type(name, realpath));
  return fd;
}
