/*
 *  Copyright (C) 2004 UCHINO Satoshi.  All Rights Reserved.
 *  Copyright (C) 2002 Alan Hourihane.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *
 *  Author: Alan Hourihane <alanh@fairlite.demon.co.uk>
 */
/*
 *  Modified for MetaVNC by UCHINO Satoshi <utinos@users.sourceforge.net>
 *  The xf4vnc original extensions are replaced with the RealVNC 4.0
 *  extensions (VncExtInit.cc: Copyright (C) 2002-2004 RealVNC Ltd.)
 *  to support the vncconfig command.
 */

#include "rfb.h"
#include "extnsionst.h"
#include "selection.h"
#define _VNC_SERVER
#include "vncstr.h"
#ifdef XFree86LOADER
#include "xf86Module.h"
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef CHROMIUM
extern void rfbSendChromiumStart(unsigned int ipaddress, unsigned int port);
extern void rfbChromiumMonitorWindowID(unsigned int cr_windowid, unsigned long windowid);
int GenerateVncChromiumConnectedEvent(int sock);
#endif

extern void rfbUserAllow(int sock, int accept);

int VncSelectNotify(ClientPtr client, BOOL onoff);
int GenerateVncConnectedEvent(int sock);
int GenerateVncDisconnectedEvent(int sock);
void VncExtensionInit(void);

static int VncErrorBase = 0;  /* first vnc error number */
static int VncEventBase = 0;  /* first vnc event number */

unsigned long VncResourceGeneration = 0;

#ifdef REALVNC4_EXT

static void SendSelectionChangeEvent(Atom selection);

extern Selection *CurrentSelections;
extern int NumCurrentSelections;

static char* clientCutText = 0;
static int clientCutTextLen = 0;

typedef struct VncInputSelect {
  ClientPtr client;
  Window window;
  int mask;
  struct VncInputSelect* next;
} VncInputSelect;
static VncInputSelect* vncInputSelectHead = 0;

static int nPrevSelections = 0;
static TimeStamp* prevSelectionTimes = 0;

/*XXX support these two parameters for now */
#define ACCEPT_CUT_TEXT "AcceptCutText"
#define SEND_CUT_TEXT "SendCutText"
static int acceptCutText = 1;
static int sendCutText = 1;

/*
 * vncBlockHandler - called just before the X server goes into select().  Call
 * on to the block handler for each desktop.  Then check whether any of the
 * selections have changed, and if so, notify any interested X clients.
 */

static void vncBlockHandler(pointer data, OSTimePtr timeout, pointer readmask)
{
  int i;
  /* XXX
  fd_set* fds = (fd_set*)readmask;
  for (int scr = 0; scr < screenInfo.numScreens; scr++) {
    if (desktop[scr]) {
      desktop[scr]->blockHandler(fds);
    }
  }
  */
  if (nPrevSelections != NumCurrentSelections) {
    prevSelectionTimes
      = (TimeStamp*)xnfrealloc(prevSelectionTimes,
                               NumCurrentSelections * sizeof(TimeStamp));
    for (i = nPrevSelections; i < NumCurrentSelections; i++) {
      prevSelectionTimes[i].months = 0;
      prevSelectionTimes[i].milliseconds = 0;
    }
    nPrevSelections = NumCurrentSelections;
  }
  for (i = 0; i < NumCurrentSelections; i++) {
    if (CurrentSelections[i].lastTimeChanged.months
        != prevSelectionTimes[i].months ||
        CurrentSelections[i].lastTimeChanged.milliseconds
        != prevSelectionTimes[i].milliseconds)
    {
      SendSelectionChangeEvent(CurrentSelections[i].selection);
      prevSelectionTimes[i] = CurrentSelections[i].lastTimeChanged;
    }
  }
}

static void vncWakeupHandler(pointer data, int nfds, pointer readmask)
{
  /* XXX
  fd_set* fds = (fd_set*)readmask;

  for (int scr = 0; scr < screenInfo.numScreens; scr++) {
    if (desktop[scr]) {
      desktop[scr]->wakeupHandler(fds, nfds);
    }
  }
  */
}

static void vncClientStateChange(CallbackListPtr* p1, pointer p2, pointer p)
{
  ClientPtr client = ((NewClientInfoRec*)p)->client;
  if (client->clientState == ClientStateGone) {
    VncInputSelect** nextPtr = &vncInputSelectHead;
    VncInputSelect* cur;
    for (cur = vncInputSelectHead; cur; cur = *nextPtr) {
      if (cur->client == client) {
        *nextPtr = cur->next;
        xfree(cur);
        continue;
      }
      nextPtr = &cur->next;
    }
  }
}

void vncClientCutText(const char* str, int len)
{
  xVncExtClientCutTextNotifyEvent ev;
  VncInputSelect* cur;
  if (clientCutText)
    xfree(clientCutText);
  clientCutText = (char *)xalloc(len * sizeof(char));
  memcpy(clientCutText, str, len);
  clientCutTextLen = len;
  ev.type = VncEventBase + VncExtClientCutTextNotify;
  for (cur = vncInputSelectHead; cur; cur = cur->next) {
    if (cur->mask & VncExtClientCutTextMask) {
      ev.sequenceNumber = cur->client->sequence;
      ev.window = cur->window;
      ev.time = GetTimeInMillis();
      if (cur->client->swapped) {
        int n;
        swaps(&ev.sequenceNumber, n);
        swapl(&ev.window, n);
        swapl(&ev.time, n);
      }
      WriteToClient(cur->client, sizeof(xVncExtClientCutTextNotifyEvent),
                    (char *)&ev);
    }
  }
}

static void SendSelectionChangeEvent(Atom selection)
{
  xVncExtSelectionChangeNotifyEvent ev;
  VncInputSelect* cur;
  ev.type = VncEventBase + VncExtSelectionChangeNotify;
  for (cur = vncInputSelectHead; cur; cur = cur->next) {
    if (cur->mask & VncExtSelectionChangeMask) {
      ev.sequenceNumber = cur->client->sequence;
      ev.window = cur->window;
      ev.selection = selection;
      if (cur->client->swapped) {
        int n;
        swaps(&ev.sequenceNumber, n);
        swapl(&ev.window, n);
        swapl(&ev.selection, n);
      }
      WriteToClient(cur->client, sizeof(xVncExtSelectionChangeNotifyEvent),
                    (char *)&ev);
    }
  }
}

static int ProcVncExtSetParam(ClientPtr client)
{
  REQUEST(xVncExtSetParamReq);
  char *param;
  xVncExtSetParamReply rep;
  int n;
  char *tok;
  int *pvalue;
  REQUEST_FIXED_SIZE(xVncExtSetParamReq, stuff->paramLen);
  param = (char *)malloc(sizeof(char) * stuff->paramLen+1);
  if (param == NULL)
    return (client->noClientException);
  strncpy(param, (char*)&stuff[1], stuff->paramLen);
  param[stuff->paramLen] = 0;

  rep.type = X_Reply;
  rep.length = 0;
  rep.sequenceNumber = client->sequence;
  
  tok = strtok(param, "=");
  pvalue = NULL;
  if (strcmp(tok, ACCEPT_CUT_TEXT) == 0) {
    pvalue = &acceptCutText;
  } else if (strcmp(tok, SEND_CUT_TEXT) == 0) {
    pvalue = &sendCutText;
  }
  if (pvalue && (tok = strtok(NULL, "=")) != NULL) {
    *pvalue = atoi(tok);
    rep.success = 1;
  }

  if (client->swapped) {
    swaps(&rep.sequenceNumber, n);
    swapl(&rep.length, n);
  }
  WriteToClient(client, sizeof(xVncExtSetParamReply), (char *)&rep);
  free(param);
  return (client->noClientException);
}

static int SProcVncExtSetParam(ClientPtr client)
{
  register char n;
  REQUEST(xVncExtSetParamReq);
  swaps(&stuff->length, n);
  REQUEST_AT_LEAST_SIZE(xVncExtSetParamReq);
  return ProcVncExtSetParam(client);
}

static int ProcVncExtGetParam(ClientPtr client)
{
  REQUEST(xVncExtGetParamReq);
  char *param;
  xVncExtGetParamReply rep;
  int n;
  int len;
  int value;
  char valueStr[4];	/* XXX suppose the value is less than 10 */
  REQUEST_FIXED_SIZE(xVncExtGetParamReq, stuff->paramLen);

  param = (char *)malloc(sizeof(char) * stuff->paramLen+1);
  if (param == NULL)
    return (client->noClientException);

  strncpy(param, (char*)&stuff[1], stuff->paramLen);
  param[stuff->paramLen] = 0;

  rep.type = X_Reply;
  rep.sequenceNumber = client->sequence;
  rep.success = 0;
  value = -1; /* XXX -1 means none */
  if (strcmp(param, ACCEPT_CUT_TEXT) == 0) {
    value = acceptCutText;
    rep.success = 1;
  } else if (strcmp(param, SEND_CUT_TEXT) == 0) {
    value = sendCutText;
    rep.success = 1;
  }
  len = 0;
  if (value != -1) {
    valueStr[0] = '0' + (value % 10);
    valueStr[1] = '\0';
    len = 1;
  }
  rep.length = (len + 3) >> 2;
  rep.valueLen = len;
  if (client->swapped) {
    swaps(&rep.sequenceNumber, n);
    swapl(&rep.length, n);
    swaps(&rep.valueLen, n);
  }
  WriteToClient(client, sizeof(xVncExtGetParamReply), (char *)&rep);
  if (value != -1)
    WriteToClient(client, len, valueStr);
  free(param);
  return (client->noClientException);
}

static int SProcVncExtGetParam(ClientPtr client)
{
  register char n;
  REQUEST(xVncExtGetParamReq);
  swaps(&stuff->length, n);
  REQUEST_AT_LEAST_SIZE(xVncExtGetParamReq);
  return ProcVncExtGetParam(client);
}

static int ProcVncExtSetServerCutText(ClientPtr client)
{
  REQUEST(xVncExtSetServerCutTextReq);
  char* str;
  REQUEST_FIXED_SIZE(xVncExtSetServerCutTextReq, stuff->textLen);
  str = (char *)xalloc((stuff->textLen+1) * sizeof(char));
  if (str == NULL)
    return client->noClientException; /*XXX BadAlloc */
  strncpy(str, (char*)&stuff[1], stuff->textLen);
  str[stuff->textLen] = 0;
  rfbSendServerCutText(str, stuff->textLen);
  xfree(str);
  return (client->noClientException);
}

static int SProcVncExtSetServerCutText(ClientPtr client)
{
  register char n;
  REQUEST(xVncExtSetServerCutTextReq);
  swaps(&stuff->length, n);
  REQUEST_AT_LEAST_SIZE(xVncExtSetServerCutTextReq);
  swapl(&stuff->textLen, n);
  return ProcVncExtSetServerCutText(client);
}

static int ProcVncExtGetClientCutText(ClientPtr client)
{
  xVncExtGetClientCutTextReply rep;
  int n;
  rep.type = X_Reply;
  rep.length = (clientCutTextLen + 3) >> 2;
  rep.sequenceNumber = client->sequence;
  rep.textLen = clientCutTextLen;
  if (client->swapped) {
    swaps(&rep.sequenceNumber, n);
    swapl(&rep.length, n);
    swapl(&rep.textLen, n);
  }
  WriteToClient(client, sizeof(xVncExtGetClientCutTextReply), (char *)&rep);
  if (clientCutText)
    WriteToClient(client, clientCutTextLen, clientCutText);
  return (client->noClientException);
}

static int SProcVncExtGetClientCutText(ClientPtr client)
{
  register char n;
  REQUEST(xVncExtGetClientCutTextReq);
  swaps(&stuff->length, n);
  REQUEST_SIZE_MATCH(xVncExtGetClientCutTextReq);
  return ProcVncExtGetClientCutText(client);
}

static int ProcVncExtSelectInput(ClientPtr client)
{
  REQUEST(xVncExtSelectInputReq);
  VncInputSelect** nextPtr = &vncInputSelectHead;
  VncInputSelect* cur;
  REQUEST_SIZE_MATCH(xVncExtSelectInputReq);
  for (cur = vncInputSelectHead; cur; cur = *nextPtr) {
    if (cur->client == client && cur->window == stuff->window) {
      cur->mask = stuff->mask;
      if (!cur->mask) {
        *nextPtr = cur->next;
        xfree(cur);
      }
      break;
    }
    nextPtr = &cur->next;
  }
  if (!cur) {
    cur = (VncInputSelect *)xalloc(sizeof(VncInputSelect));
    if (cur) {
      cur->client = client;
      cur->window = stuff->window;
      cur->mask   = stuff->mask;
      cur->next   = vncInputSelectHead;
      vncInputSelectHead = cur;
#if 0
    } else {
      return BadAlloc;
#endif
    }
  }
  return (client->noClientException);
}

static int SProcVncExtSelectInput(ClientPtr client)
{
  register char n;
  REQUEST(xVncExtSelectInputReq);
  swaps(&stuff->length, n);
  REQUEST_SIZE_MATCH(xVncExtSelectInputReq);
  swapl(&stuff->window, n);
  swapl(&stuff->mask, n);
  return ProcVncExtSelectInput(client);
}

#else /*REALVNC4_EXT*/

static RESTYPE VncNotifyList;

static XID faked;

typedef struct _VncNotifyListRec {
  struct _VncNotifyListRec *next;
  ClientPtr client;
} VncNotifyListRec, *VncNotifyListPtr;

static int
ProcVncQueryVersion(ClientPtr client)
{
    xVncQueryVersionReply 	rep;

    REQUEST_SIZE_MATCH(xVncQueryVersionReq);
    rep.type        	= X_Reply;
    rep.sequenceNumber 	= client->sequence;
    rep.length         	= 0;
    rep.majorVersion  	= VNC_MAJOR_VERSION;
    rep.minorVersion  	= VNC_MINOR_VERSION;
    if(client->swapped)
    {
	register char n;
    	swaps(&rep.sequenceNumber, n);
	swaps(&rep.majorVersion, n);
	swaps(&rep.minorVersion, n);
    }
    (void)WriteToClient(client, SIZEOF(xVncQueryVersionReply),
			(char *)&rep);
    return (client->noClientException);
} /* ProcVncQueryVersion */

static int
ProcVncConnection(ClientPtr client)
{
    REQUEST(xVncConnectionReq);
    xVncConnectionReply 	rep;

    rfbUserAllow( stuff->sock, stuff->accept );

    REQUEST_SIZE_MATCH(xVncConnectionReq);
    rep.type        	= X_Reply;
    rep.sequenceNumber 	= client->sequence;
    rep.length         	= 0;
    rep.sock  		= 0;
    rep.accept  	= 0;
    if(client->swapped)
    {
	register char n;
    	swaps(&rep.sequenceNumber, n);
	swaps(&rep.sock, n);
	swaps(&rep.accept, n);
    }
    (void)WriteToClient(client, SIZEOF(xVncConnectionReply),
			(char *)&rep);
    return (client->noClientException);
} /* ProcVncConnection */

static int
ProcVncSelectNotify(ClientPtr client)
{
    REQUEST(xVncSelectNotifyReq);
    xVncSelectNotifyReply 	rep;

    VncSelectNotify(client, stuff->onoff);

    REQUEST_SIZE_MATCH(xVncSelectNotifyReq);
    rep.type        	= X_Reply;
    rep.sequenceNumber 	= client->sequence;
    rep.length         	= 0;
    if(client->swapped)
    {
	register char n;
    	swaps(&rep.sequenceNumber, n);
    }
    (void)WriteToClient(client, SIZEOF(xVncSelectNotifyReply),
			(char *)&rep);
    return (client->noClientException);

}

static int
ProcVncListConnections(ClientPtr client)
{
    xVncListConnectionsReply 	rep;
    rfbClientPtr cl;
    int count = 0;
    struct in_addr ipaddress;
    xVncConnectionListInfo Info;

    /* count connections */
    for (cl = rfbClientHead; cl; cl = cl->next)
#ifdef CHROMIUM
    /* 
     * Fix this, as it should be generic, but we're only using it
     * for Chromium at the moment, so we only list the connections
     * that have a valid chromium encoding. We should be able to list
     * any type requested. FIXME! XXXX
     * See furthur down this function too!!!
     */
	    if (cl->enableChromiumEncoding)
#endif
	    	count++;

    REQUEST_SIZE_MATCH(xVncListConnectionsReq);
    rep.type        	= X_Reply;
    rep.sequenceNumber 	= client->sequence;
    rep.count		= count;
    rep.length 		= count * sizeof(xVncConnectionListInfo) >> 2;
    if(client->swapped)
    {
	register char n;
    	swaps(&rep.sequenceNumber, n);
    	swaps(&rep.count, n);
    }
    (void)WriteToClient(client, SIZEOF(xVncListConnectionsReply),
			(char *)&rep);

    for (cl = rfbClientHead; cl; cl = cl->next) {
#ifdef CHROMIUM
        /* 
         * Fix this, as it should be generic, but we're only using it
         * for Chromium at the moment, so we only list the connections
         * that have a valid chromium encoding. We should be able to list
         * any type requested. FIXME! XXXX
         */
	if (!cl->enableChromiumEncoding)
	    continue;
#endif
	inet_aton(cl->host, &ipaddress);
	memcpy(&Info, &ipaddress, sizeof(struct in_addr));
	WriteToClient(client, SIZEOF(xVncConnectionListInfo), (char*)&Info);
    }

    return (client->noClientException);
} /* ProcVncListConnections */

#ifdef CHROMIUM
static int
ProcVncChromiumStart(ClientPtr client)
{
    REQUEST(xVncChromiumStartReq);
    xVncChromiumStartReply 	rep;

    rfbSendChromiumStart(stuff->ipaddress, stuff->port);

    REQUEST_SIZE_MATCH(xVncChromiumStartReq);
    rep.type        	= X_Reply;
    rep.sequenceNumber 	= client->sequence;
    rep.length         	= 0;
    if(client->swapped)
    {
	register char n;
    	swaps(&rep.sequenceNumber, n);
    }
    (void)WriteToClient(client, SIZEOF(xVncChromiumStartReply),
			(char *)&rep);
    return (client->noClientException);
} /* ProcVncChromiumStart */

static int
ProcVncChromiumMonitor(ClientPtr client)
{
    REQUEST(xVncChromiumMonitorReq);
    xVncChromiumMonitorReply 	rep;

    rfbChromiumMonitorWindowID(stuff->cr_windowid, stuff->windowid);

    REQUEST_SIZE_MATCH(xVncChromiumMonitorReq);
    rep.type        	= X_Reply;
    rep.sequenceNumber 	= client->sequence;
    rep.length         	= 0;
    if(client->swapped)
    {
	register char n;
    	swaps(&rep.sequenceNumber, n);
    }
    (void)WriteToClient(client, SIZEOF(xVncChromiumMonitorReply),
			(char *)&rep);
    return (client->noClientException);
} /* ProcVncChromiumMonitor */
#endif /* CHROMIUM */

#endif /*REALVNC4_EXT*/

static int
ProcVncDispatch(ClientPtr client)
{
    REQUEST(xReq);

    switch (stuff->data)
    {
#ifdef REALVNC4_EXT
    case X_VncExtSetParam:
	return ProcVncExtSetParam(client);
    case X_VncExtGetParam:
	return ProcVncExtGetParam(client);
    case X_VncExtGetParamDesc:
	return BadRequest; /*XXX*/
    case X_VncExtListParams:
	return BadRequest; /*XXX*/
    case X_VncExtSetServerCutText:
	return ProcVncExtSetServerCutText(client);
    case X_VncExtGetClientCutText:
	return ProcVncExtGetClientCutText(client);
    case X_VncExtSelectInput:
	return ProcVncExtSelectInput(client);
    case X_VncExtConnect:
	return BadRequest; /*XXX*/
#else /*REALVNC4_EXT*/
    case X_VncQueryVersion:
	return ProcVncQueryVersion(client);
    case X_VncSelectNotify:
	return ProcVncSelectNotify(client);
    case X_VncConnection:
	return ProcVncConnection(client);
    case X_VncListConnections:
	return ProcVncListConnections(client);
#ifdef CHROMIUM
    case X_VncChromiumStart:
	return ProcVncChromiumStart(client);
    case X_VncChromiumMonitor:
	return ProcVncChromiumMonitor(client);
#endif
#endif /*REALVNC4_EXT*/
    default:
	return BadRequest;
    }
} /* ProcVncDispatch */

#ifdef REALVNC4_EXT
#else /*REALVNC4_EXT*/

static int
SProcVncQueryVersion(ClientPtr client)
{
    REQUEST(xVncQueryVersionReq);
    register char 	n;

    swaps(&stuff->length, n);
    REQUEST_SIZE_MATCH(xVncQueryVersionReq);
    swaps(&stuff->majorVersion, n);
    swaps(&stuff->minorVersion,n);
    return ProcVncQueryVersion(client);
} /* SProcVncQueryVersion */

static int
SProcVncSelectNotify(ClientPtr client)
{
    REQUEST(xVncSelectNotifyReq);
    register char 	n;

    swaps(&stuff->length, n);
    REQUEST_SIZE_MATCH(xVncSelectNotifyReq);
    return ProcVncSelectNotify(client);
} /* SProcVncSelectNotify */

static int
SProcVncListConnections(ClientPtr client)
{
    REQUEST(xVncListConnectionsReq);
    register char 	n;

    swaps(&stuff->length, n);
    REQUEST_SIZE_MATCH(xVncListConnectionsReq);
    return ProcVncListConnections(client);
} /* SProcVncListConnections */

#ifdef CHROMIUM
static int
SProcVncChromiumStart(ClientPtr client)
{
    REQUEST(xVncChromiumStartReq);
    register char 	n;

    swaps(&stuff->ipaddress, n);
    swaps(&stuff->port, n);
    swaps(&stuff->length, n);
    REQUEST_SIZE_MATCH(xVncChromiumStartReq);
    return ProcVncChromiumStart(client);
} /* SProcVncChromiumStart */

static int
SProcVncChromiumMonitor(ClientPtr client)
{
    REQUEST(xVncChromiumMonitorReq);
    register char 	n;

    swaps(&stuff->length, n);
    swaps(&stuff->windowid, n);
    swaps(&stuff->cr_windowid, n);
    REQUEST_SIZE_MATCH(xVncChromiumMonitorReq);
    return ProcVncChromiumMonitor(client);
} /* SProcVncChromiumMonitor */
#endif /* CHROMIUM */

static int
SProcVncConnection(ClientPtr client)
{
    REQUEST(xVncConnectionReq);
    register char 	n;

    swaps(&stuff->length, n);
    REQUEST_SIZE_MATCH(xVncConnectionReq);
    swaps(&stuff->sock, n);
    swaps(&stuff->accept,n);
    return ProcVncConnection(client);
} /* SProcVncConnection */

#endif /*REALVNC4_EXT*/

static int
SProcVncDispatch(ClientPtr client)
{
    REQUEST(xReq);

    switch (stuff->data)
    {
#ifdef REALVNC4_EXT
    case X_VncExtSetParam:
	return SProcVncExtSetParam(client);
    case X_VncExtGetParam:
	return SProcVncExtGetParam(client);
    case X_VncExtGetParamDesc:
	return BadRequest; /*XXX*/
    case X_VncExtListParams:
	return BadRequest; /*XXX*/
    case X_VncExtSetServerCutText:
	return SProcVncExtSetServerCutText(client);
    case X_VncExtGetClientCutText:
	return SProcVncExtGetClientCutText(client);
    case X_VncExtSelectInput:
	return SProcVncExtSelectInput(client);
    case X_VncExtConnect:
	return BadRequest; /*XXX*/
#else /*REALVNC4_EXT*/
    case X_VncQueryVersion:
	return SProcVncQueryVersion(client);
    case X_VncSelectNotify:
	return SProcVncSelectNotify(client);
    case X_VncConnection:
	return SProcVncConnection(client);
    case X_VncListConnections:
	return SProcVncListConnections(client);
#ifdef CHROMIUM
    case X_VncChromiumStart:
	return SProcVncChromiumStart(client);
    case X_VncChromiumMonitor:
	return SProcVncChromiumMonitor(client);
#endif
#endif /*REALVNC4_EXT*/
	default:
	    return BadRequest;
    }
} /* SProcVncDispatch */

#ifndef REALVNC4_EXT /* xf4vnc */

static void 
SwapVncConnectedEvent(xVncConnectedEvent *from, xVncConnectedEvent *to)
{
    to->type = from->type;
    to->detail = from->detail;
    cpswaps(from->sequenceNumber, to->sequenceNumber);
    cpswapl(from->connected, to->connected);
}

#ifdef CHROMIUM
static void 
SwapVncChromiumConnectedEvent(xVncConnectedEvent *from, xVncConnectedEvent *to)
{
    to->type = from->type;
    to->detail = from->detail;
    cpswaps(from->sequenceNumber, to->sequenceNumber);
    cpswapl(from->connected, to->connected);
}
#endif

static void 
SwapVncDisconnectedEvent(xVncConnectedEvent *from, xVncConnectedEvent *to)
{
    to->type = from->type;
    to->detail = from->detail;
    cpswaps(from->sequenceNumber, to->sequenceNumber);
    cpswapl(from->connected, to->connected);
}

#endif /*!REALVNC4_EXT*/

int
GenerateVncConnectedEvent(int sock)
{
#ifndef REALVNC4_EXT /* xf4vnc */
    VncNotifyListPtr pn;

    pn = (VncNotifyListPtr)LookupIDByType(faked, VncNotifyList);

    while (pn)
      {
	if (pn->client) 
	{
    	  xVncConnectedEvent conn;
    	  SOCKLEN_T peer_len;
    	  struct sockaddr_in peer;

    	  conn.type = VncEventBase + XVncConnected;
    	  conn.sequenceNumber = pn->client->sequence;
    	  conn.connected = sock;

    	  peer_len = sizeof(peer);
    	  if (getpeername(sock, (struct sockaddr *) &peer, &peer_len) == -1)
		conn.ipaddress = 0;
   	  else
		conn.ipaddress = (CARD32)peer.sin_addr.s_addr;

	  (void) TryClientEvents(pn->client, (xEventPtr)&conn, 1, NoEventMask,
				 NoEventMask, NullGrab);
	}
	pn = pn->next;
    }

#endif /*REALVNC4_EXT*/
    return 1;
}

#ifdef CHROMIUM
int
GenerateVncChromiumConnectedEvent(int sock)
{
#ifndef REALVNC4_EXT /* xf4vnc */
    VncNotifyListPtr pn;

    pn = (VncNotifyListPtr)LookupIDByType(faked, VncNotifyList);

    while (pn)
      {
	if (pn->client) 
	{
    	  xVncConnectedEvent conn;
    	  SOCKLEN_T peer_len;
    	  struct sockaddr_in peer;

    	  conn.type = VncEventBase + XVncChromiumConnected;
    	  conn.sequenceNumber = pn->client->sequence;
    	  conn.connected = sock;

    	  peer_len = sizeof(peer);
    	  if (getpeername(sock, (struct sockaddr *)&peer, &peer_len) == -1)
		conn.ipaddress = 0;
   	  else
		conn.ipaddress = (CARD32)peer.sin_addr.s_addr;

	  (void) TryClientEvents(pn->client, (xEventPtr)&conn, 1, NoEventMask,
				 NoEventMask, NullGrab);
	}
	pn = pn->next;
    }

#endif /*REALVNC4_EXT*/
    return 1;
}
#endif /* CHROMIUM */

int
GenerateVncDisconnectedEvent(int sock)
{
#ifndef REALVNC4_EXT /* xf4vnc */
    VncNotifyListPtr pn;

    pn = (VncNotifyListPtr)LookupIDByType(faked, VncNotifyList);

    while (pn)
      {
	if (pn->client) 
	{
    	  xVncDisconnectedEvent conn;
    	  conn.type = VncEventBase + XVncDisconnected;
    	  conn.sequenceNumber = pn->client->sequence;
    	  conn.connected = sock;
	  (void) TryClientEvents(pn->client, (xEventPtr)&conn, 1, NoEventMask,
				 NoEventMask, NullGrab);
	}
	pn = pn->next;
    }

#endif /*REALVNC4_EXT*/
    return 1;
}

static void
VncResetProc(ExtensionEntry *extEntry)
{
} /* VncResetProc */

#ifndef REALVNC4_EXT

int
VncSelectNotify(
  ClientPtr client,
  BOOL onoff
){
  VncNotifyListPtr pn,tpn,fpn;

  if (!faked)
	faked = FakeClientID(client->index);

  pn = (VncNotifyListPtr)LookupIDByType(faked, VncNotifyList);

  if (!onoff && !pn) return Success;

  if (!pn) 
    {
      if (!(tpn = (VncNotifyListPtr)xalloc(sizeof(VncNotifyListRec))))
	return BadAlloc;
      tpn->next = (VncNotifyListPtr)NULL;
      tpn->client = (ClientPtr)NULL;
      if (!AddResource(faked, VncNotifyList, tpn))
	{
	  xfree(tpn);
	  return BadAlloc;
	}
    }
  else
    {
      fpn = (VncNotifyListPtr)NULL;
      tpn = pn;

      /* FIXME - NEED TO HAVE AN OPTION FOR SINGLE CLIENT ONLY!!! */

      while (tpn)
	{
	  if (tpn->client == client) 
	    {
	      if (!onoff) tpn->client = (ClientPtr)NULL;
	      return Success;
	    }
	  if (!tpn->client) fpn = tpn; /* TAKE NOTE OF FREE ENTRY */
	  tpn = tpn->next;
	}

      /* IF TUNNING OFF, THEN JUST RETURN */

      if (!onoff) return Success;

      /* IF ONE ISN'T FOUND THEN ALLOCATE ONE AND LINK IT INTO THE LIST */

      if (fpn)
	{
	  tpn = fpn;
	}
      else
	{
	  if (!(tpn = (VncNotifyListPtr)xalloc(sizeof(VncNotifyListRec))))
	    return BadAlloc;
	  tpn->next = pn->next;
	  pn->next = tpn;
	}
    }

  /* INIT CLIENT PTR IN CASE WE CAN'T ADD RESOURCE */
  /* ADD RESOURCE SO THAT IF CLIENT EXITS THE CLIENT PTR WILL BE CLEARED */

  tpn->client = (ClientPtr)NULL;

  AddResource(faked, VncNotifyList, tpn);

  tpn->client = client;
  return Success;

}

static int
VncDestroyNotifyList(pointer pn, XID id)
{
  VncNotifyListPtr cpn = (VncNotifyListPtr) pn;

  cpn->client = NULL;

  return Success;
}

static Bool
CreateResourceTypes(void)
{
  if (VncResourceGeneration == serverGeneration) return TRUE;

  VncResourceGeneration = serverGeneration;

  if (!(VncNotifyList = CreateNewResourceType(VncDestroyNotifyList)))
    {
      ErrorF("CreateResourceTypes: failed to allocate vnc notify list resource.\n");
      return FALSE;
    }

  return TRUE;

}
#endif /*!REALVNC4_EXT*/

#if XFREE86VNC
static unsigned long vncCreateScreenResourcesIndex;
static unsigned long vncExtGeneration = 0;
extern Bool VNCInit(ScreenPtr pScreen, unsigned char *FBStart);

/* copied from miscrinit.c */
typedef struct
{
    pointer pbits; /* pointer to framebuffer */
    int width;    /* delta to add to a framebuffer addr to move one row down */
} miScreenInitParmsRec, *miScreenInitParmsPtr;

static Bool
vncCreateScreenResources(ScreenPtr pScreen)
{
  int ret = TRUE;
  CreateScreenResourcesProcPtr CreateScreenResources =
    (CreateScreenResourcesProcPtr)(pScreen->devPrivates[vncCreateScreenResourcesIndex].ptr);
  miScreenInitParmsPtr pScrInitParms;

  pScrInitParms = (miScreenInitParmsPtr)pScreen->devPrivate;

  if ( pScreen->CreateScreenResources != vncCreateScreenResources ) {
    /* Can't find hook we are hung on */
	xf86DrvMsg(pScreen->myNum, X_WARNING /* X_ERROR */,
		  "vncCreateScreenResources %p called when not in pScreen->CreateScreenResources %p n",
		   vncCreateScreenResources, pScreen->CreateScreenResources );
  }

  /* Now do our stuff */
  VNCInit(pScreen, pScrInitParms->pbits);

  /* Unhook this function ... */
  pScreen->CreateScreenResources = CreateScreenResources;
  pScreen->devPrivates[vncCreateScreenResourcesIndex].ptr = NULL;

  /* ... and call the previous CreateScreenResources fuction, if any */
  if (NULL!=pScreen->CreateScreenResources) {
    ret = (*pScreen->CreateScreenResources)(pScreen);
  }

#ifdef DEBUG
  ErrorF("vncCreateScreenResources() returns %d\n", ret);
#endif
  return (ret);
}
#endif

void
VncExtensionInit(void)
{
    ExtensionEntry	*extEntry;

#if XFREE86VNC
    if (vncExtGeneration != serverGeneration) {
	unsigned int i;

	vncExtGeneration = serverGeneration;

    	if ( ((vncCreateScreenResourcesIndex = AllocateScreenPrivateIndex()) < 0) ||
	     ((vncScreenPrivateIndex = AllocateScreenPrivateIndex()) < 0) ||
	     ((rfbGCIndex = AllocateGCPrivateIndex()) < 0) )
		return;

    	for (i = 0 ; i < screenInfo.numScreens; i++) 
	{
      	    screenInfo.screens[i]->devPrivates[vncCreateScreenResourcesIndex].ptr
	 		= (void*)(xf86Screens[i]->pScreen->CreateScreenResources);
      	    xf86Screens[i]->pScreen->CreateScreenResources = vncCreateScreenResources;
    	}

	gethostname(rfbThisHost, 255);
    }
#endif

#ifndef REALVNC4_EXT
    if (!CreateResourceTypes())
	    return;
#endif /*!REALVNC4_EXT*/

    extEntry = AddExtension(VNC_EXTENSION_NAME,
			    XVncNumberEvents, XVncNumberErrors,
			    ProcVncDispatch, SProcVncDispatch,
                            VncResetProc, StandardMinorOpcode);
    if (!extEntry) {
      FatalError("VncExtensionInit: AddExtension failed\n");
    }

    VncErrorBase = extEntry->errorBase;
    VncEventBase = extEntry->eventBase;

#ifdef REALVNC4_EXT
    if (!AddCallback(&ClientStateCallback, vncClientStateChange, 0)) {
      FatalError("VncExtensionInit: AddCallback failed\n");
    }
    /*XXX*/
    RegisterBlockAndWakeupHandlers(vncBlockHandler, vncWakeupHandler, 0);
#else /* REALVNC4_EXT */
    EventSwapVector[VncEventBase + XVncConnected] =
	(EventSwapPtr)SwapVncConnectedEvent;
    EventSwapVector[VncEventBase + XVncDisconnected] =
	(EventSwapPtr)SwapVncDisconnectedEvent;
#ifdef CHROMIUM
    EventSwapVector[VncEventBase + XVncChromiumConnected] =
	(EventSwapPtr)SwapVncChromiumConnectedEvent;
#endif
#endif /*REALVNC4_EXT*/
} /* VncExtensionInit */
