# Ming/Slide
# $Id: $
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

require 'ming/slide/slidemovie'
require 'ming/slide/slideitem'

require 'ming/ming'
include Ming

class SlidePage

  attr_reader :movie, :clip, :width, :height, :level
  attr_accessor :style, :effect, :blank

  def initialize(slide, page, effect=nil)
	@slide = slide
	@movie = slide.movie
	@width = slide.width
	@height = slide.height	
	@title = slide.title
	@page = page
	@effect = effect

	@blank = [[[10, 10], [@width - 10, @height - 10]]]

	@scenario = Array.new

	@style = 'plain'

	@clip = SWFMovieClip.new
	
	set_background

	@level = Hash.new
	['itemlist', 'enumlist', 'desclist', 'methodlist'].each do |l|
	  @level[l] = 0
	end

	@enum_counter = []

  end

  def set_background

	shape = SWFShape.new
	shape.set_right_fill(shape.add_fill(0xff, 0xff, 0xff))
	shape.draw_line(@width, 0)
	shape.draw_line(0, @height)
	shape.draw_line(- @width, 0)
	shape.draw_line(0, - @height)

	@clip.add(shape)

  end

  def display

	@scenario.each do |i|
	  if i
		i.display unless i.displayed?
	  end
	  
	  self
	end

	replace(@effect)

	set_controller

	@clip.next_frame

	@movie.label_frame(label(@page))
	@movie.next_frame

  end

  def replace(effect, option=nil)
	effect = 'default' unless effect

	__send__('replace_' + effect, option)

	@movie.add(SWFAction.new('stop();'))
  end

  def replace_default(option=nil)
	item = @movie.add(@clip)
  end;

  def add(method, *option)
	i = __send__('add_' + method, option)
	@scenario.push i

	i
  end

  def add_headline(option)
	Headline.new(self, option)
  end

  def add_textblock(option)
	string = option[0]
	TextBlock.new(self, string)
  end

  def add_verbatim(option)
	string = option[0]
	Verbatim.new(self, string)
  end

  def start(method)
	@level[method] = @level[method] + 1

	case method
	when 'enumlist'
	  @enum_counter[@level['enumlist']] = 1
	end

  end

  def end(method)
	case method
	when 'enumlist'
	  @enum_counter[@level['enumlist']] = nil
	end

	@level[method] = @level[method] - 1
  end

  def add_itemlist(option)
	string = option[0]
	lev = @level['itemlist']
	
	ItemList.new(self, [string, lev])
  end

  def add_enumlist(option)
	string = option[0]
	lev = @level['enumlist']
	num = @enum_counter[lev]

	list = EnumList.new(self, [string, lev, num])
	@enum_counter[lev] = @enum_counter[lev] + 1
	
	list
  end

  def add_desclist(option)
	string = option[0]

	DescList.new(self, string)
  end

  def set_controller
	shape = SWFShape.new
	shape.set_right_fill(shape.add_fill(0xff, 0xff, 0xff, 0xff))
	shape.draw_line(@width, 0)
	shape.draw_line(0, @height)
	shape.draw_line(- @width, 0)
	shape.draw_line(0, - @height)

	go_next = SWFAction.new(%Q[gotoAndStop('#{label(@page + 1)}');])
	go_prev = SWFAction.new(%Q[gotoAndStop('#{label(@page - 1)}');])
	play = SWFAction.new(%Q[play();])
	max_win_act = %q{
      fscommand('allowscale', 'true');
      fscommand('fulscreen', 'true');
      getURL("JavaScript:fullScreen('slide.swf')", '_top');
    }
    max_win = SWFAction.new(max_win_act)

	@movie.remove(@slide.controller) if @slide.controller
	button = SWFButton.new
	button.add_shape(shape, SWFBUTTON_HIT)
	[' ', 'n', 'N'].each do |key|
	  button.add_action(go_next, key_press(key))
	end

	['p', 'P'].each do |key|
	  button.add_action(go_prev, key_press(key))
	end

	["\e", 'm'].each do |key|
	  button.add_action(max_win, key_press(key))
	end

	button.add_action(play, SWFBUTTON_DOWN)

	controller = @movie.add(button)
	@slide.controller = controller
  end

  def label(num)
	ret = 'a'
	num.times do
	  ret.succ!
	end

	ret
  end

  def reduce_blank(idx, dx, dy)
	lx, ly = @blank[idx][0]
	rx, ry = @blank[idx][1]
	
	@blank[idx] = [[lx + dx, ly + dy], [rx + dx, ry + dy]]
  end

end
