###############################################################################
# mod_uploader / aclocal.m4
###############################################################################
# Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
#
# All rights reserved.
#
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any
# damages arising from the use of this software.
#
# Permission is granted to anyone to use this software for any
# purpose, including commercial applications, and to alter it and
# redistribute it freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must
#    not claim that you wrote the original software. If you use this
#    software in a product, an acknowledgment in the product
#    documentation would be appreciated but is not required.
#
# 2. Altered source versions must be plainly marked as such, and must
#    not be misrepresented as being the original software.
#
# 3. This notice may not be removed or altered from any source
#    distribution.
#
# $Id: aclocal.m4 615 2005-09-06 07:48:53Z svn $
###############################################################################

AC_DEFUN(AC_CHECK_MCPU, [
AC_ARG_WITH(mcpu,
        [  --with-mcpu=CPU         set optimization target (ie: pentium4, athlon-xp, ...)],
        [MCPU=${withval}], [MCPU='no'])
AC_MSG_CHECKING([for optimization target])
if test "$MCPU" = no; then
    AC_MSG_RESULT(no)
else
    CFLAGS_OLD=$CFLAGS
    CFLAGS="-mcpu=$MCPU"
    AC_LANG(C)
    AC_COMPILE_IFELSE([int i = 0;], , [MCPU='no'])
    if test "$MCPU" = no; then
        AC_MSG_RESULT([ignored])
    else
        AC_MSG_RESULT($MCPU)
        MCPU_OPT="-mcpu=$MCPU"
    fi
    CFLAGS=$CFLAGS_OLD
fi
AC_SUBST(MCPU_OPT)
])

AC_DEFUN(AC_CHECK_MARCH, [
AC_ARG_WITH(march,
        [  --with-march=CPU        set CPU type (ie: pentium4, athlon-xp, ...)],
        [MARCH=${withval}], [MARCH='no'])
AC_MSG_CHECKING([for CPU type])
if test "$MARCH" = no; then
    AC_MSG_RESULT(no)
else
    CFLAGS_OLD=$CFLAGS
    CFLAGS="$CFLAGS -march=$MARCH"
    AC_LANG(C)
    AC_COMPILE_IFELSE([int i = 0;], , [MARCH='no'])
    if test "$MARCH" = no; then
        AC_MSG_RESULT([ignored])
    else
        AC_MSG_RESULT($MARCH)
        MARCH_OPT="-march=$MARCH"
    fi
    CFLAGS=$CFLAGS_OLD
fi
AC_SUBST(MARCH_OPT)
])

AC_DEFUN(AC_CHECK_LIBTOOL, [
AC_ARG_WITH(libtool,
        [  --with-libtool=LIBTOOL  set path to libtool program],
        [LIBTOOL=${withval}], [LIBTOOL='no'])
if test "$LIBTOOL" = no; then
    AC_PATH_PROG(GLIBTOOL, glibtool, no, /sw/bin:/usr/bin:/usr/local/bin)
    LIBTOOL=$GLIBTOOL

    if test "$LIBTOOL" = no; then
        AC_PATH_PROG(LIBTOOL, libtool, no, /sw/bin:/usr/bin:/usr/local/bin)
    fi 
fi
if [ ! test -x $LIBTOOL ]; then
    AC_MSG_ERROR([libtool is required. Try --with-libtool option.])
fi 
])

AC_DEFUN(AC_CHECK_APXS2, [
AC_ARG_WITH(apxs2,
        [  --with-apxs2=APXS       set path to apxs program],
        [APXS2=${withval}], [APXS2='no'])
if test "$APXS2" = no; then
    AC_PATH_PROG(APXS2, apxs2, no,
                 /usr/sbin:/usr/local/sbin:/usr/bin:/usr/local/bin:/usr/local/apache2/bin)

    if test "$APXS2" = no; then
        AC_PATH_PROG(APXS, apxs, no,
                     /usr/pkg/sbin:/sw/sbin:/usr/sbin:/usr/local/sbin:/usr/bin:/usr/local/bin:/usr/local/apache2/bin)
        APXS2=$APXS
    fi
fi
if [ ! test -x $APXS2 ]; then
    AC_MSG_ERROR([apxs2 is required. Try --with-apxs2 option.])
fi 
])

AC_DEFUN(AC_CHECK_APACHE_VERSION, [
HTTPD=`$APXS2 -q SBINDIR`/`$APXS2 -q TARGET`
APACHE_VERSION=`$HTTPD -v | grep Apache/2.`
AC_MSG_CHECKING([for Apache version])
if test "$APACHE_VERSION" != ''; then
    AC_MSG_RESULT([ok])
else
    AC_MSG_ERROR([Apache HTTP Server 2 is required.])
fi
])

AC_DEFUN(AC_CHECK_APACHE_MOD_DSO, [
HTTPD=`$APXS2 -q SBINDIR`/`$APXS2 -q TARGET`
AC_MSG_CHECKING([for DSO enabled])
if test `$HTTPD -l | grep mod_so.c`; then
    AC_MSG_RESULT([ok])
else
    AC_MSG_ERROR([DSO is disabled.])
fi
])

AC_DEFUN(AC_CHECK_APACHE2CTL, [
AC_ARG_WITH(apctl2,
        [  --with-apctl2=APCTL     set path to apachectl program],
        [APACHE2CTL=${withval}], [APACHE2CTL='no'])
if test "$APACHE2CTL" = no; then
    AC_PATH_PROG(APACHE2CTL, apache2ctl, no,
                 /usr/sbin:/usr/local/sbin:/usr/bin:/usr/local/bin:/usr/local/apache2/bin)

    if test "$APACHE2CTL" = no; then
        AC_PATH_PROG(APACHECTL, apachectl, no,
                     /usr/pkg/sbin:/sw/sbin:/usr/sbin:/usr/local/sbin:/usr/bin:/usr/local/bin:/usr/local/apache2/bin)
        APACHE2CTL=$APACHECTL
    fi
fi
if [ ! test -x $APACHE2CTL ]; then
    AC_MSG_ERROR([apache2ctl is required. Try --with-ap2ctl option.])
fi
])

AC_DEFUN(AC_CHECK_APRCONF, [
AC_ARG_WITH(aprconf,
        [  --with-aprconf=APRCONF  set path to apr-config program],
        [APRCONF=${withval}], [APRCONF='no'])
if test "$APRCONF" = no; then
    AC_PATH_PROG(APRCONF, apr-config, no,
                 /usr/pkg/bin:/sw/bin:/usr/sbin:/usr/local/sbin:/usr/bin:/usr/local/bin:/usr/local/apache2/bin:/usr/local/lib/apache2)
fi
if [ ! test -x $APRCONF ]; then
    AC_MSG_ERROR([apr-config is required. Try --with-aprconf option.])
fi 
])

AC_DEFUN(AC_CHECK_MAGICKCONF, [
AC_ARG_WITH(mconf,
        [  --with-mconf=MCONF      set path to Magick++-config program],
        [MCONF=${withval}], [MCONF='no'])
if test "$MCONF" = no; then
    AC_PATH_PROG(MCONF, Magick++-config, no, /sw/bin:/usr/sbin:/usr/local/sbin:/usr/bin:/usr/local/bin)
fi
if [ ! test -x $MCONF ]; then
    AC_MSG_ERROR([Magick++-config is required. Try --with-mconf option.])
fi 
])

AC_DEFUN(AC_CHECK_ICONV_CONST, [
AC_ARG_ENABLE(iconv-const,
        [  --enable-iconv-const      set type of iconv 2nd argument],
        [ICONV_CONST='const'], [ICONV_CONST=''])
AC_MSG_CHECKING([for set type of iconv 2nd argument])
AC_MSG_RESULT($ICONV_CONST)
AC_SUBST(ICONV_CONST)
])

AC_DEFUN(AC_CHECK_IE_NAME_CODE, [
AC_ARG_WITH(ie-name-code,
        [  --with-ie-name-code=CODE set type of Internet Explorer filename encoding],
        [IE_NAME_CODE=${withval}], [IE_NAME_CODE='cp932'])
AC_MSG_CHECKING([for type of Internet Explorer filename encoding])
AC_MSG_RESULT($IE_NAME_CODE)
AC_SUBST(IE_NAME_CODE)
])

# Local Variables:
# mode: autoconf
# buffer-file-coding-system: euc-japan-dos
# End:
