/******************************************************************************
 * mod_uploader / RssView.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateExecutor.h 160 2005-03-19 18:17:33Z svn $
 *****************************************************************************/

#ifndef RSSVIEW_H
#define RSSVIEW_H

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include "PageView.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include "httpd.h"
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "apr_pools.h"
#include "apr_time.h"

#include <cstdlib>

using namespace std;

/**
 * @brief RSS Ϥ륯饹
 */
class RssView : public PageView
{
public:
    static const char content_type[];
    static const char image_type_prefix[];

    void exec(apr_pool_t *pool, request_rec *request, const char *base_url,
              UploadItemList *item_list, apr_size_t per_page_item_number);
private:
    static const apr_size_t MAX_TIME_LENGTH;
    static const char TIME_FORMAT[];
    static const apr_size_t TIME_ZONE_OFFSET;

    typedef UploadItemList::item_info item_info;
    typedef struct Handle {
        apr_pool_t * const pool;
        request_rec * const request;
        const char * const base_url;

        Handle(apr_pool_t *pool, request_rec *request, const char *base_url)
            : pool(pool),
              request(request),
              base_url(base_url)
        {

        }
    } handle;

    static void print(handle *h, item_info *item);
    static void print(handle *h, const char *str);
    static const char *time_str(apr_pool_t *pool, apr_time_t time);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
