/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.statistics.CategoryTimeBox;
import base.statistics.TimeAveBox;
import base.topology.Line;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Arrays;

public class SummaryArrow {
    private static Stroke Line_Stroke = new BasicStroke(3.0f);
    private static long Arrow_Log_Base = 10L;
    private static Stroke[] Line_Strokes = new Stroke[10];

    private static int drawForward(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, double start_time, float start_ypos, double final_time, float final_ypos) {
        int jTail;
        int iTail;
        int jHead;
        int iHead;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        boolean isStartVtxInImg = iStart > 0;
        boolean isFinalVtxInImg = iFinal < coord_xform.getImageWidth();
        double slope = 0.0;
        if (!isStartVtxInImg || !isFinalVtxInImg) {
            if (iStart != iFinal) {
                slope = (double)(jFinal - jStart) / (double)(iFinal - iStart);
            } else {
                return 0;
            }
        }
        if (isStartVtxInImg) {
            iHead = iStart;
            jHead = jStart;
        } else {
            iHead = 0;
            jHead = (int)Math.rint((double)jStart - slope * (double)iStart);
        }
        if (isFinalVtxInImg) {
            iTail = iFinal;
            jTail = jFinal;
        } else {
            iTail = coord_xform.getImageWidth();
            jTail = (int)Math.rint((double)jFinal + slope * (double)(iTail - iFinal));
        }
        Stroke orig_stroke = null;
        if (stroke != null) {
            orig_stroke = g.getStroke();
            g.setStroke(stroke);
        }
        g.setColor(color);
        g.drawLine(iHead, jHead, iTail, jTail);
        if (stroke != null) {
            g.setStroke(orig_stroke);
        }
        return 1;
    }

    public static void setTimeBoundingBox(TimeAveBox avebox, double starttime, double finaltime) {
        CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
        Arrays.sort(typeboxes, CategoryTimeBox.INCL_RATIO_ORDER);
        boolean isInclusive = true;
        double duration = finaltime - starttime;
        for (int idx = typeboxes.length - 1; idx >= 0; --idx) {
            CategoryTimeBox typebox = typeboxes[idx];
            double interval = duration * (double)typebox.getCategoryRatio(isInclusive);
            typebox.setEarliestTime(starttime);
            typebox.setLatestFromEarliest(interval);
        }
    }

    public static void setBaseOfLogOfObjectNumToArrowWidth(int new_log_base) {
        Arrow_Log_Base = new_log_base;
    }

    private static Stroke getArrowStroke(double fnum) {
        int idx;
        long inum = Math.round(fnum);
        for (idx = 0; idx < Line_Strokes.length && (inum /= Arrow_Log_Base) != 0L; ++idx) {
        }
        if (idx < Line_Strokes.length) {
            return Line_Strokes[idx];
        }
        return Line_Strokes[Line_Strokes.length - 1];
    }

    public static int draw(Graphics2D g, TimeAveBox avebox, CoordPixelXform coord_xform, float start_ypos, float final_ypos) {
        float head_ypos = start_ypos;
        float tail_ypos = final_ypos;
        CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
        int count = 0;
        Stroke arrow_stroke = SummaryArrow.getArrowStroke(avebox.getAveNumOfRealObjects());
        CategoryTimeBox typebox = typeboxes[typeboxes.length - 1];
        double head_time = typebox.getEarliestTime();
        double tail_time = typebox.getLatestTime();
        double slope = (double)(tail_ypos - head_ypos) / (tail_time - head_time);
        double intercept = (double)head_ypos - slope * head_time;
        for (int idx = typeboxes.length - 1; idx >= 0; --idx) {
            typebox = typeboxes[idx];
            Color color = typebox.getCategoryColor();
            head_time = typebox.getEarliestTime();
            tail_time = typebox.getLatestTime();
            tail_ypos = (float)(slope * tail_time + intercept);
            count += SummaryArrow.drawForward(g, color, arrow_stroke, coord_xform, head_time, head_ypos, tail_time, tail_ypos);
        }
        return count;
    }

    public static Object containsPixel(TimeAveBox avebox, CoordPixelXform coord_xform, Point pt, float start_ypos, float final_ypos) {
        float head_ypos = start_ypos;
        float tail_ypos = final_ypos;
        CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
        CategoryTimeBox typebox = typeboxes[typeboxes.length - 1];
        double head_time = typebox.getEarliestTime();
        double tail_time = typebox.getLatestTime();
        double slope = (double)(tail_ypos - head_ypos) / (tail_time - head_time);
        double intercept = (double)head_ypos - slope * head_time;
        for (int idx = 0; idx < typeboxes.length; ++idx) {
            typebox = typeboxes[idx];
            head_time = typebox.getEarliestTime();
            if (!Line.containsPixel(coord_xform, pt, head_time, head_ypos, tail_time = typebox.getLatestTime(), tail_ypos = (float)(slope * tail_time + intercept))) continue;
            return avebox;
        }
        return null;
    }

    static {
        for (int idx = Line_Strokes.length - 1; idx >= 0; --idx) {
            SummaryArrow.Line_Strokes[idx] = new BasicStroke(idx + 1);
        }
    }
}

