/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.input.InputLog;

public class PrintSerially {
    private static String in_filename;
    private static Drawable.Order dobj_order;
    private static int itrTopoLevel;
    private static double time_init_ftr;
    private static double time_final_ftr;
    private static boolean printCategoryMap;
    private static boolean printTreeDir;
    private static boolean printLineIDMaps;
    private static boolean printDrawables;
    private static String help_msg;

    public static final void main(String[] args) {
        String err_msg;
        PrintSerially.parseCmdLineArgs(args);
        InputLog slog_ins = new InputLog(in_filename);
        if (slog_ins == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!slog_ins.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((err_msg = slog_ins.getCompatibleHeader()) != null) {
            System.err.print(err_msg);
            InputLog.stdoutConfirmation();
        }
        slog_ins.initialize();
        System.out.println(slog_ins.toString(printCategoryMap, printTreeDir, printLineIDMaps));
        if (!printDrawables) {
            slog_ins.close();
            System.exit(0);
        }
        TreeDir treedir = slog_ins.getTreeDir();
        TreeDirValue root_dir = (TreeDirValue)treedir.get(treedir.firstKey());
        TimeBoundingBox timeframe = new TimeBoundingBox(root_dir.getTimeBoundingBox());
        PrintSerially.scaleTimeBounds(timeframe);
        boolean isStartTimeOrdered = dobj_order.isStartTimeOrdered();
        boolean isIncreTimeOrdered = dobj_order.isIncreasingTimeOrdered();
        double prev_bordertime = isIncreTimeOrdered ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        int dobj_count = 0;
        Iterator dobj_itr = slog_ins.iteratorOfRealDrawables(timeframe, dobj_order, itrTopoLevel);
        while (dobj_itr.hasNext()) {
            Drawable dobj = (Drawable)dobj_itr.next();
            double dobj_bordertime = dobj.getBorderTime(isStartTimeOrdered);
            if (isIncreTimeOrdered) {
                if (prev_bordertime > dobj_bordertime) {
                    System.out.print("  *****  ");
                }
            } else if (prev_bordertime < dobj_bordertime) {
                System.out.print("  *****  ");
            }
            System.out.println(++dobj_count + ": " + dobj);
            prev_bordertime = dobj_bordertime;
        }
        slog_ins.close();
    }

    private static void printClogArrowMessageSize(Drawable dobj) {
        int infovals_length;
        if (dobj.getCategory().getTopology().isArrow() && (infovals_length = dobj.getInfoLength()) >= 2) {
            Integer msg_sz = (Integer)dobj.getInfoValue(1).getValue();
            System.out.println(dobj.getInfoKey(1) + msg_sz);
        }
    }

    private static void scaleTimeBounds(TimeBoundingBox endtimes) {
        double time_init = endtimes.getEarliestTime();
        double time_final = endtimes.getLatestTime();
        double time_range = time_final - time_init;
        endtimes.setEarliestTime(time_init + time_init_ftr * time_range);
        endtimes.setLatestTime(time_init + time_final_ftr * time_range);
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    String arg_str;
                    if (argv[idx].equals("-h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (argv[idx].equals("-c") || argv[idx].equals("-category")) {
                        printCategoryMap = true;
                        printTreeDir = false;
                        printLineIDMaps = false;
                        printDrawables = false;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-d") || argv[idx].equals("-directory")) {
                        printCategoryMap = false;
                        printTreeDir = true;
                        printLineIDMaps = false;
                        printDrawables = false;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-c") || argv[idx].equals("-ycoordmap")) {
                        printCategoryMap = false;
                        printTreeDir = false;
                        printLineIDMaps = true;
                        printDrawables = false;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-is") || argv[idx].equals("-incre_starttime")) {
                        dobj_order = Drawable.INCRE_STARTTIME_ORDER;
                        printDrawables = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-ds") || argv[idx].equals("-decre_starttime")) {
                        dobj_order = Drawable.DECRE_STARTTIME_ORDER;
                        printDrawables = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-ie") || argv[idx].equals("-incre_endtime")) {
                        dobj_order = Drawable.INCRE_FINALTIME_ORDER;
                        printDrawables = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-de") || argv[idx].equals("-decre_endtime")) {
                        dobj_order = Drawable.DECRE_FINALTIME_ORDER;
                        printDrawables = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-s") || argv[idx].equals("-state")) {
                        itrTopoLevel = 2;
                        printDrawables = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-a") || argv[idx].equals("-arrow")) {
                        itrTopoLevel = 1;
                        printDrawables = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-ts")) {
                        arg_str = argv[++idx];
                        time_init_ftr = Double.parseDouble(arg_str);
                        err_msg.append("\n time_start_factor = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-tf")) {
                        arg_str = argv[++idx];
                        time_final_ftr = Double.parseDouble(arg_str);
                        err_msg.append("\n time_final_factor = " + arg_str);
                        ++idx;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + PrintSerially.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = argv[idx];
                ++idx;
            }
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            String idx_order_str = PrintSerially.indexOrderStr(idx);
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + PrintSerially.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
        if (time_init_ftr > time_final_ftr || time_init_ftr < 0.0 || time_final_ftr > 1.0) {
            System.err.println("Invalid time_init_factor and time_final_factor!");
            System.err.println("time_init_factor = " + time_init_ftr);
            System.err.println("time_final_factor = " + time_final_ftr);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        itrTopoLevel = 0;
        time_init_ftr = 0.0;
        time_final_ftr = 1.0;
        printCategoryMap = true;
        printTreeDir = true;
        printLineIDMaps = true;
        printDrawables = true;
        help_msg = "Usage: java slog2.input.PrintSerially [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]           \t Display this message.\n\t [-c|-category] DEF          \t Print category map only.\n\t [-d|-directory] DEF         \t Print directory tree only.\n\t [-y|-ycoordmap] DEF         \t Print Y-coord. map only.\n\t [-s|-state] DEF             \t Print states only.\n\t [-a|-arrow] DEF             \t Print arrows only.\n\t [-is|-incre_starttime] DEF  \t Print in increasing starttime order.\n\t [-ds|-decre_starttime]      \t Print in decreasing starttime order.\n\t [-ie|-incre_endtime]        \t Print in increasing endtime order.\n\t [-de|-decre_endtime]        \t Print in decreasing endtime order.\n\t [-ts time_start_factor]     \t Default value is 0.0 (min).\n\t [-tf time_final_factor]     \t Default value is 1.0 (max).\n*** The options marked by DEF are enabled by default.\n";
    }
}

