/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.io.File;
import javax.swing.JFileChooser;
import viewer.common.LogPermitDirFilter;
import viewer.common.LogRefuseDirFilter;

public class LogFileChooser
extends JFileChooser {
    private boolean isApplet;

    public LogFileChooser(boolean isTopApplet) {
        super(System.getProperty("user.dir"));
        super.setDialogTitle("Select SLOG-2 file");
        this.isApplet = isTopApplet;
        if (this.isApplet) {
            super.setAcceptAllFileFilterUsed(false);
            LogRefuseDirFilter filter = new LogRefuseDirFilter(new String[]{"slog2"});
            super.setFileFilter(filter);
        } else {
            LogPermitDirFilter filter = new LogPermitDirFilter(new String[]{"slog2"});
            super.addChoosableFileFilter(filter);
            filter = new LogPermitDirFilter(new String[]{"clog2"});
            super.addChoosableFileFilter(filter);
            filter = new LogPermitDirFilter(new String[]{"clog"});
            super.addChoosableFileFilter(filter);
            filter = new LogPermitDirFilter(new String[]{"rlog"});
            super.addChoosableFileFilter(filter);
            filter = new LogPermitDirFilter(new String[]{"slog2", "clog2", "clog", "rlog"});
            super.addChoosableFileFilter(filter);
        }
    }

    public boolean isTraversable(File file) {
        if (this.isApplet) {
            if (file != null) {
                return !file.isDirectory();
            }
            return false;
        }
        return super.isTraversable(file);
    }
}

