/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import viewer.common.Parameters;
import viewer.common.PreferencePanel;
import viewer.common.Routines;
import viewer.common.TopWindow;

public class PreferenceFrame
extends JFrame
implements ActionListener {
    private PreferencePanel pptys_panel;
    private JButton update_btn;
    private JButton save_btn;
    private JButton close_btn;

    public PreferenceFrame() {
        super("Preferences");
        super.setDefaultCloseOperation(0);
        TopWindow.Preference.disposeAll();
        TopWindow.Preference.setWindow(this);
        Container root_panel = this.getContentPane();
        root_panel.setLayout(new BoxLayout(root_panel, 1));
        this.pptys_panel = new PreferencePanel();
        this.pptys_panel.updateAllFieldsFromParameters();
        JScrollPane scroller = new JScrollPane(this.pptys_panel);
        Dimension screen_size = Routines.getScreenSize();
        scroller.setMinimumSize(new Dimension(100, 100));
        scroller.setMaximumSize(new Dimension(screen_size.width / 2, screen_size.height * 4 / 5));
        scroller.setPreferredSize(new Dimension(this.pptys_panel.getPreferredSize().width * 10 / 9, screen_size.height * 3 / 5));
        root_panel.add(scroller);
        JPanel mid_panel = new JPanel();
        mid_panel.setLayout(new BoxLayout(mid_panel, 0));
        mid_panel.add(Box.createHorizontalGlue());
        this.update_btn = new JButton("update");
        this.update_btn.setToolTipText("Update all parameters based on the current preference");
        this.update_btn.addActionListener(this);
        mid_panel.add(this.update_btn);
        mid_panel.add(Box.createHorizontalGlue());
        this.save_btn = new JButton("save");
        this.save_btn.setToolTipText("Save preference to Jumpshot-4 setup file");
        this.save_btn.addActionListener(this);
        mid_panel.add(this.save_btn);
        mid_panel.add(Box.createHorizontalGlue());
        root_panel.add(mid_panel);
        JPanel end_panel = new JPanel();
        end_panel.setLayout(new BoxLayout(end_panel, 0));
        end_panel.add(Box.createHorizontalGlue());
        this.close_btn = new JButton("close");
        this.close_btn.setToolTipText("Close this window");
        this.close_btn.addActionListener(this);
        end_panel.add(this.close_btn);
        end_panel.add(Box.createHorizontalGlue());
        root_panel.add(end_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PreferenceFrame.this.setVisible(false);
            }
        });
    }

    public void setVisible(boolean val) {
        super.setVisible(val);
        TopWindow.Control.setEditPreferenceButtonEnabled(!val);
    }

    public void updateAllParametersFromFields() {
        this.pptys_panel.updateAllParametersFromFields();
    }

    public void updateAllFieldsFromParameters() {
        this.pptys_panel.updateAllFieldsFromParameters();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.update_btn) {
            this.pptys_panel.updateAllParametersFromFields();
        } else if (evt.getSource() == this.save_btn) {
            this.pptys_panel.updateAllParametersFromFields();
            Parameters.writeToSetupFile(this);
        } else if (evt.getSource() == this.close_btn) {
            this.setVisible(false);
        }
    }
}

