/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Category;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import logformat.clog2TOdrawable.InputLog;

public class Print {
    public static final void main(String[] args) {
        Category objdef;
        Kind next_kind;
        if (args.length != 1) {
            System.err.println("It needs the filename to be the only command line arguemnt");
            System.exit(0);
        }
        String filename = args[0];
        ArrayList<Category> objdefs = new ArrayList<Category>();
        HashMap<Topology, Category> shadefs = new HashMap<Topology, Category>();
        long Nobjs = 0L;
        Date time1 = new Date();
        InputLog dobj_ins = new InputLog(filename);
        Date time2 = new Date();
        while ((next_kind = dobj_ins.peekNextKind()) != Kind.EOF) {
            if (next_kind == Kind.TOPOLOGY) {
                Topology topo = dobj_ins.getNextTopology();
                objdef = Category.getShadowCategory(topo);
                objdefs.add(objdef);
                shadefs.put(topo, objdef);
            }
            if (next_kind == Kind.CATEGORY) {
                objdef = dobj_ins.getNextCategory();
                objdefs.add(objdef);
            }
            if (next_kind != Kind.PRIMITIVE) continue;
            Primitive drawobj = dobj_ins.getNextPrimitive();
            System.out.println(++Nobjs + ", " + drawobj);
        }
        dobj_ins.close();
        Date time3 = new Date();
        System.err.println("\n\t Shadow Category Definitions : ");
        Iterator shadefs_itr = shadefs.entrySet().iterator();
        while (shadefs_itr.hasNext()) {
            System.err.println(shadefs_itr.next());
        }
        System.err.println("\n\t Primitive Category Definitions : ");
        Iterator objdefs_itr = objdefs.iterator();
        while (objdefs_itr.hasNext()) {
            objdef = (Category)objdefs_itr.next();
            System.err.println(objdef.toString());
        }
        System.err.println("\n");
        System.err.println("Number of Primitives = " + Nobjs);
        System.err.println("Number of Unmatched Events = " + dobj_ins.getNumberOfUnMatchedEvents());
        System.err.println("Total ByteSize of the logfile = " + dobj_ins.getTotalBytesRead());
        System.err.println("timeElapsed between 1 & 2 = " + (time2.getTime() - time1.getTime()) + " msec");
        System.err.println("timeElapsed between 2 & 3 = " + (time3.getTime() - time2.getTime()) + " msec");
    }
}

