/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Category;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.slog2.BufForObjects;
import logformat.slog2.IteratorOfAllDrawables;
import logformat.slog2.IteratorOfBackDrawables;
import logformat.slog2.IteratorOfForeDrawables;
import logformat.slog2.LineIDMap;

public class BufForShadows
extends BufForObjects {
    private static final int INIT_BYTESIZE = 42;
    private Map buf4shadows;
    private Map shadowdefs_map;
    private List buf4nestable;
    private List buf4nestless;
    private Drawable.Order buf4dobj_order;
    private boolean isOutputBuf;
    private boolean haveObjectsBeenSaved;
    private int total_bytesize;

    public BufForShadows(boolean isForOutput) {
        this.isOutputBuf = isForOutput;
        if (this.isOutputBuf) {
            this.buf4shadows = new HashMap();
            this.buf4nestable = new ArrayList();
            this.buf4nestless = new ArrayList();
            this.buf4dobj_order = Drawable.INCRE_FINALTIME_ORDER;
        } else {
            this.buf4shadows = null;
            this.buf4nestable = null;
            this.buf4nestless = null;
            this.buf4dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        }
        this.shadowdefs_map = null;
        this.haveObjectsBeenSaved = false;
        this.total_bytesize = 42;
    }

    public void setMapOfTopologyToShadowDef(Map in_shadefs) {
        this.shadowdefs_map = in_shadefs;
    }

    public int getByteSize() {
        return this.total_bytesize;
    }

    public void add(Primitive prime) {
        ArrayList<Topology> key = new ArrayList<Topology>();
        Topology topo = prime.getCategory().getTopology();
        key.add(topo);
        key.addAll(prime.getListOfVertexLineIDs());
        Shadow sobj = (Shadow)this.buf4shadows.get(key);
        if (sobj == null) {
            Category shadowdef = (Category)this.shadowdefs_map.get(topo);
            shadowdef.setUsed(true);
            sobj = new Shadow(shadowdef, prime);
            this.buf4shadows.put(key, sobj);
            this.total_bytesize += sobj.getByteSize();
        } else {
            this.total_bytesize -= sobj.getByteSize();
            sobj.mergeWithPrimitive(prime);
            this.total_bytesize += sobj.getByteSize();
        }
    }

    public void empty() {
        if (this.haveObjectsBeenSaved) {
            this.buf4nestable.clear();
            this.buf4nestless.clear();
            this.buf4dobj_order = Drawable.INCRE_FINALTIME_ORDER;
            this.buf4shadows.clear();
            this.haveObjectsBeenSaved = false;
            this.total_bytesize = 42;
        }
    }

    public void mergeWith(BufForShadows buf) {
        Iterator entries = buf.buf4shadows.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry key_sobj = entries.next();
            List key = (List)key_sobj.getKey();
            Shadow sobj = (Shadow)this.buf4shadows.get(key);
            if (sobj == null) {
                sobj = new Shadow((Shadow)key_sobj.getValue());
                this.buf4shadows.put(key, sobj);
                this.total_bytesize += sobj.getByteSize();
                continue;
            }
            this.total_bytesize -= sobj.getByteSize();
            sobj.mergeWithShadow((Shadow)key_sobj.getValue());
            this.total_bytesize += sobj.getByteSize();
        }
    }

    public void initializeMapOfCategoryWeights() {
        Iterator sobjs_itr = this.buf4shadows.values().iterator();
        while (sobjs_itr.hasNext()) {
            ((Shadow)sobjs_itr.next()).initializeMapOfCategoryWeights();
        }
    }

    public void finalizeMapOfCategoryWeights() {
        Iterator sobjs_itr = this.buf4shadows.values().iterator();
        while (sobjs_itr.hasNext()) {
            ((Shadow)sobjs_itr.next()).finalizeMapOfCategoryWeights();
        }
    }

    public int getNumOfPrimitives() {
        if (this.isOutputBuf) {
            return this.buf4shadows.size();
        }
        return this.buf4nestable.size() + this.buf4nestless.size();
    }

    public int getNumOfDrawables() {
        return this.getNumOfPrimitives();
    }

    private long getNumOfRealObjects() {
        long Nrobjs = 0L;
        if (this.isOutputBuf) {
            Iterator objs_itr = this.buf4shadows.values().iterator();
            while (objs_itr.hasNext()) {
                Nrobjs += ((Shadow)objs_itr.next()).getNumOfRealObjects();
            }
        } else {
            Iterator objs_itr = this.buf4nestable.iterator();
            while (objs_itr.hasNext()) {
                Nrobjs += ((Shadow)objs_itr.next()).getNumOfRealObjects();
            }
            objs_itr = this.buf4nestless.iterator();
            while (objs_itr.hasNext()) {
                Nrobjs += ((Shadow)objs_itr.next()).getNumOfRealObjects();
            }
        }
        return Nrobjs;
    }

    public Iterator nestableForeIterator(TimeBoundingBox tframe, boolean isComposite) {
        return new IteratorOfForeDrawables(this.buf4nestable, tframe);
    }

    public Iterator nestlessForeIterator(TimeBoundingBox tframe) {
        return new IteratorOfForeDrawables(this.buf4nestless, tframe);
    }

    public Iterator nestableBackIterator(TimeBoundingBox tframe, boolean isComposite) {
        return new IteratorOfBackDrawables(this.buf4nestable, tframe);
    }

    public Iterator nestlessBackIterator(TimeBoundingBox tframe) {
        return new IteratorOfBackDrawables(this.buf4nestless, tframe);
    }

    public LineIDMap getIdentityLineIDMap() {
        return BufForObjects.toIdentityLineIDMap(this.buf4shadows.values());
    }

    public void reorderDrawables(Drawable.Order dobj_order) {
        if (!this.buf4dobj_order.equals(dobj_order)) {
            this.buf4dobj_order = dobj_order;
            Collections.sort(this.buf4nestable, this.buf4dobj_order);
            Collections.sort(this.buf4nestless, this.buf4dobj_order);
        }
    }

    public void summarizeCategories() {
        Iterator sobjs_itr = this.buf4shadows.values().iterator();
        while (sobjs_itr.hasNext()) {
            Shadow sobj = (Shadow)sobjs_itr.next();
            sobj.summarizeCategories(super.getDuration());
        }
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        super.writeObject(outs);
        Iterator objs_itr = this.buf4shadows.values().iterator();
        while (objs_itr.hasNext()) {
            Shadow sobj = (Shadow)objs_itr.next();
            if (sobj.getCategory().getTopology().isState()) {
                this.buf4nestable.add(sobj);
                continue;
            }
            this.buf4nestless.add(sobj);
        }
        this.reorderDrawables(Drawable.INCRE_STARTTIME_ORDER);
        int Nobjs = this.buf4nestless.size();
        outs.writeInt(Nobjs);
        Iterator sobjs_itr = this.buf4nestless.iterator();
        while (sobjs_itr.hasNext()) {
            ((Shadow)sobjs_itr.next()).writeObject(outs);
        }
        Nobjs = this.buf4nestable.size();
        outs.writeInt(Nobjs);
        sobjs_itr = this.buf4nestable.iterator();
        while (sobjs_itr.hasNext()) {
            ((Shadow)sobjs_itr.next()).writeObject(outs);
        }
        this.haveObjectsBeenSaved = true;
    }

    public BufForShadows(MixedDataInput ins, Map categorymap) throws IOException {
        this(false);
        this.readObject(ins, categorymap);
    }

    public void readObject(MixedDataInput ins, Map categorymap) throws IOException {
        Shadow sobj;
        int idx;
        super.readObject(ins);
        int Nobjs = ins.readInt();
        this.buf4nestless = new ArrayList(Nobjs);
        for (idx = 0; idx < Nobjs; ++idx) {
            sobj = new Shadow(ins);
            sobj.resolveCategory(categorymap);
            this.buf4nestless.add(sobj);
            this.total_bytesize += sobj.getByteSize();
        }
        Nobjs = ins.readInt();
        this.buf4nestable = new ArrayList(Nobjs);
        for (idx = 0; idx < Nobjs; ++idx) {
            sobj = new Shadow(ins);
            sobj.resolveCategory(categorymap);
            this.buf4nestable.add(sobj);
            this.total_bytesize += sobj.getByteSize();
        }
    }

    public String toString() {
        IteratorOfAllDrawables sobjs_itr;
        StringBuffer rep = new StringBuffer("    BufForShadows{ ");
        rep.append(super.toString());
        rep.append(" Nrobjs=" + this.getNumOfRealObjects());
        rep.append(" }\n");
        if (this.isOutputBuf) {
            sobjs_itr = this.buf4shadows.values().iterator();
        } else {
            IteratorOfForeDrawables nestable_itr = new IteratorOfForeDrawables(this.buf4nestable, this);
            IteratorOfForeDrawables nestless_itr = new IteratorOfForeDrawables(this.buf4nestless, this);
            sobjs_itr = new IteratorOfAllDrawables(nestable_itr, nestless_itr, this.buf4dobj_order);
        }
        int idx = 1;
        while (sobjs_itr.hasNext()) {
            rep.append(idx + ": " + sobjs_itr.next() + "\n");
            ++idx;
        }
        return rep.toString();
    }
}

