/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Coord;
import base.drawable.Primitive;
import base.drawable.YCoordMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import logformat.clog2TOdrawable.CommLineID;

public class CommLineIDMap
extends TreeMap {
    public CommLineIDMap() {
        super(Coord.LINEID_ORDER);
    }

    public void addCommLineID(CommLineID commlineID) {
        super.put(new Coord(0.0, commlineID.lineID), commlineID);
    }

    public void setCommLineIDUsed(Primitive prime) {
        CommLineID commlineID = (CommLineID)super.get(prime.getStartVertex());
        if (commlineID != null) {
            commlineID.setUsed(true);
        }
        if (prime.getCategory().getTopology().isArrow() && (commlineID = (CommLineID)super.get(prime.getFinalVertex())) != null) {
            commlineID.setUsed(true);
        }
    }

    public void initialize() {
    }

    public void finish() {
        Iterator commlineID_itr = super.values().iterator();
        while (commlineID_itr.hasNext()) {
            CommLineID commlineID = (CommLineID)commlineID_itr.next();
            if (commlineID.isUsed()) continue;
            commlineID_itr.remove();
        }
    }

    public List createYCoordMapList() {
        int num_rows = super.size();
        int num_cols4world = 2;
        int world_idx = 0;
        int[] world_elems = new int[num_rows * num_cols4world];
        int num_cols4comm = 3;
        int comm_idx = 0;
        int[] comm_elems = new int[num_rows * num_cols4comm];
        Iterator commlineID_itr = super.values().iterator();
        while (commlineID_itr.hasNext()) {
            CommLineID commlineID = (CommLineID)commlineID_itr.next();
            world_elems[world_idx++] = commlineID.lineID;
            world_elems[world_idx++] = commlineID.wrank;
            comm_elems[comm_idx++] = commlineID.lineID;
            comm_elems[comm_idx++] = commlineID.icomm;
            comm_elems[comm_idx++] = commlineID.rank;
        }
        YCoordMap world_viewmap = new YCoordMap(num_rows, num_cols4world, "CommWorld View", new String[]{"world_rank"}, world_elems, null);
        YCoordMap comm_viewmap = new YCoordMap(num_rows, num_cols4comm, "Multi-Communicator View", new String[]{"commID", "rank"}, comm_elems, null);
        ArrayList<YCoordMap> ycoordmap_list = new ArrayList<YCoordMap>(2);
        ycoordmap_list.add(world_viewmap);
        ycoordmap_list.add(comm_viewmap);
        return ycoordmap_list;
    }
}

