/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FileBlockPtr {
    public static final int BYTESIZE = 12;
    private long fptr;
    private int size;

    public FileBlockPtr() {
        this.fptr = 0L;
        this.size = 0;
    }

    public FileBlockPtr(long in_fptr, int in_size) {
        this.fptr = in_fptr;
        this.size = in_size;
    }

    public boolean isNULL() {
        return this.fptr == 0L || this.size <= 0;
    }

    public void setFileBlockPtr(long in_fptr, int in_size) {
        this.fptr = in_fptr;
        this.size = in_size;
    }

    public void setFilePointer(long in_fptr) {
        this.fptr = in_fptr;
    }

    public long getFilePointer() {
        return this.fptr;
    }

    public void setBlockSize(int in_size) {
        this.size = in_size;
    }

    public int getBlockSize() {
        return this.size;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeLong(this.fptr);
        outs.writeInt(this.size);
    }

    public FileBlockPtr(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.fptr = ins.readLong();
        this.size = ins.readInt();
    }

    public String toString() {
        return "FBinfo(" + this.size + " @ " + this.fptr + ")";
    }
}

