/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import logformat.slog2.input.InputLog;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;

public class PrintRecursively {
    private static boolean printNode = true;
    private static String in_filename;
    private static double time_init_ftr;
    private static double time_final_ftr;
    private static short lowest_depth;
    private static String help_msg;

    public static final void main(String[] args) {
        String err_msg;
        PrintRecursively.parseCmdLineArgs(args);
        InputLog slog_ins = new InputLog(in_filename);
        if (slog_ins == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!slog_ins.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((err_msg = slog_ins.getCompatibleHeader()) != null) {
            System.err.print(err_msg);
            InputLog.stdoutConfirmation();
        }
        slog_ins.initialize();
        System.out.println(slog_ins);
        TreeTrunk treetrunk = new TreeTrunk(slog_ins, Drawable.INCRE_STARTTIME_ORDER);
        treetrunk.initFromTreeTop();
        TreeNode treeroot = treetrunk.getTreeRoot();
        if (treeroot == null) {
            System.out.println("SLOG-2 file, " + in_filename + " " + "contains no drawables");
            slog_ins.close();
            System.exit(0);
        }
        TimeBoundingBox timebounds = new TimeBoundingBox(treeroot);
        PrintRecursively.resetTimeBounds(timebounds);
        System.err.println("Time Window is " + timebounds);
        treetrunk.growInTreeWindow(treeroot, lowest_depth, timebounds);
        if (printNode) {
            System.out.println(treetrunk.toString());
        } else {
            System.out.println(treetrunk.toString(timebounds));
        }
        slog_ins.close();
    }

    private static void resetTimeBounds(TimeBoundingBox endtimes) {
        double time_init = endtimes.getEarliestTime();
        double time_final = endtimes.getLatestTime();
        double time_range = time_final - time_init;
        endtimes.setEarliestTime(time_init + time_init_ftr * time_range);
        endtimes.setLatestTime(time_init + time_final_ftr * time_range);
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    String arg_str;
                    if (argv[idx].equals("-h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (argv[idx].equals("-n") || argv[idx].equals("-node")) {
                        printNode = true;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-t") || argv[idx].equals("-time")) {
                        printNode = false;
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-ts")) {
                        arg_str = argv[++idx];
                        time_init_ftr = Double.parseDouble(arg_str);
                        err_msg.append("\n time_start_factor = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-tf")) {
                        arg_str = argv[++idx];
                        time_final_ftr = Double.parseDouble(arg_str);
                        err_msg.append("\n time_final_factor = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-d")) {
                        arg_str = argv[++idx];
                        lowest_depth = Short.parseShort(arg_str);
                        err_msg.append("\n lowest_depth = " + arg_str);
                        ++idx;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + PrintRecursively.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = argv[idx];
                ++idx;
            }
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            String idx_order_str = PrintRecursively.indexOrderStr(idx);
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + PrintRecursively.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
        if (time_init_ftr > time_final_ftr || time_init_ftr < 0.0 || time_final_ftr > 1.0) {
            System.err.println("Invalid time_init_factor and time_final_factor!");
            System.err.println("time_init_factor = " + time_init_ftr);
            System.err.println("time_final_factor = " + time_final_ftr);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        time_init_ftr = 0.0;
        time_final_ftr = 1.0;
        lowest_depth = 0;
        help_msg = "Usage: java slog2.input.Print [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]             \t Display this message.\n\t [-n|-node] (default)          \t Print drawables in TreeNodes.\n\t [-t|-time]                    \t Print drawables within endtimes.\n\t [-ts time_start_factor]       \t Default value is 0.0 (min).\n\t [-tf time_final_factor]       \t Default value is 1.0 (max).\n\t [-d lowest_depth]             \t Default value is 0 (leaf level).\n";
    }
}

