/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import viewer.common.ActableTextField;
import viewer.common.Routines;

public class LabeledTextField
extends JPanel {
    private static final int TEXT_HEIGHT = 20;
    protected static Font FONT = null;
    private JLabel tag;
    private ActableTextField fld;
    protected DecimalFormat fmt;
    private FieldDocumentListener self_listener;

    public LabeledTextField(String label, String format) {
        this(false, label, format);
    }

    public LabeledTextField(boolean isIndentedLabel, String label, String format) {
        super.setLayout(new BoxLayout(this, 1));
        this.tag = new JLabel(label);
        if (isIndentedLabel) {
            JPanel tag_panel = new JPanel();
            tag_panel.setLayout(new BoxLayout(tag_panel, 0));
            tag_panel.add(Box.createHorizontalStrut(5));
            tag_panel.add(this.tag);
            tag_panel.add(Box.createHorizontalGlue());
            tag_panel.setAlignmentX(0.0f);
            super.add(tag_panel);
        } else {
            this.tag.setAlignmentX(0.0f);
            super.add(this.tag);
        }
        this.fld = new ActableTextField();
        this.tag.setLabelFor(this.fld);
        this.fld.setAlignmentX(0.0f);
        super.add(this.fld);
        if (format != null) {
            this.fmt = (DecimalFormat)NumberFormat.getInstance();
            this.fmt.applyPattern(format);
            int num_col = Routines.getAdjNumOfTextColumns(this.fld, format.length());
            this.fld.setColumns(num_col);
        } else {
            this.fmt = null;
        }
        this.self_listener = null;
        this.fld.setBorder(BorderFactory.createEtchedBorder());
        if (FONT != null) {
            this.tag.setFont(FONT);
            this.fld.setFont(FONT);
        }
    }

    public static void setDefaultFont(Font font) {
        FONT = font;
    }

    public void setLabelFont(Font font) {
        this.tag.setFont(font);
    }

    public void setFieldFont(Font font) {
        this.fld.setFont(font);
    }

    public void setHorizontalAlignment(int alignment) {
        this.fld.setHorizontalAlignment(alignment);
    }

    public void setText(String str) {
        this.fld.setText(str);
    }

    public String getText() {
        if (this.self_listener != null) {
            return this.self_listener.getLastUpdatedText();
        }
        return this.fld.getText();
    }

    public void setBoolean(boolean bval) {
        this.fld.setText(String.valueOf(bval));
    }

    public boolean getBoolean() {
        String bool_str = null;
        bool_str = this.self_listener != null ? this.self_listener.getLastUpdatedText() : this.fld.getText();
        return bool_str.equalsIgnoreCase("true") || bool_str.equalsIgnoreCase("yes");
    }

    public void setShort(short sval) {
        this.fld.setText(this.fmt.format(sval));
    }

    public short getShort() {
        String short_str = null;
        short_str = this.self_listener != null ? this.self_listener.getLastUpdatedText() : this.fld.getText();
        try {
            return this.fmt.parse(short_str).shortValue();
        }
        catch (ParseException perr) {
            perr.printStackTrace();
            return Short.MIN_VALUE;
        }
    }

    public void setInteger(int ival) {
        this.fld.setText(this.fmt.format(ival));
    }

    public int getInteger() {
        String int_str = null;
        int_str = this.self_listener != null ? this.self_listener.getLastUpdatedText() : this.fld.getText();
        try {
            return this.fmt.parse(int_str).intValue();
        }
        catch (ParseException perr) {
            perr.printStackTrace();
            return Integer.MIN_VALUE;
        }
    }

    public void setFloat(float fval) {
        this.fld.setText(this.fmt.format(fval));
    }

    public float getFloat() {
        String float_str = null;
        float_str = this.self_listener != null ? this.self_listener.getLastUpdatedText() : this.fld.getText();
        try {
            return this.fmt.parse(float_str).floatValue();
        }
        catch (ParseException perr) {
            perr.printStackTrace();
            return Float.MIN_VALUE;
        }
    }

    public void setDouble(double dval) {
        this.fld.setText(this.fmt.format(dval));
    }

    public double getDouble() {
        String double_str = null;
        double_str = this.self_listener != null ? this.self_listener.getLastUpdatedText() : this.fld.getText();
        try {
            return this.fmt.parse(double_str).doubleValue();
        }
        catch (ParseException perr) {
            perr.printStackTrace();
            return Double.MIN_VALUE;
        }
    }

    public void setEditable(boolean flag) {
        this.fld.setEditable(flag);
    }

    public void setEnabled(boolean flag) {
        this.fld.setEnabled(flag);
    }

    public void addActionListener(ActionListener listener) {
        this.fld.addActionListener(listener);
    }

    public void addSelfDocumentListener() {
        this.self_listener = new FieldDocumentListener();
        this.fld.getDocument().addDocumentListener(this.self_listener);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.fld.getPreferredSize().height + 20);
    }

    public void fireActionPerformed() {
        this.fld.fireActionPerformed();
    }

    private class FieldDocumentListener
    implements DocumentListener {
        private Document last_updated_document = null;

        public void changedUpdate(DocumentEvent evt) {
            this.last_updated_document = evt.getDocument();
        }

        public void insertUpdate(DocumentEvent evt) {
            this.last_updated_document = evt.getDocument();
        }

        public void removeUpdate(DocumentEvent evt) {
            this.last_updated_document = evt.getDocument();
        }

        public String getLastUpdatedText() {
            if (this.last_updated_document != null) {
                try {
                    return this.last_updated_document.getText(0, this.last_updated_document.getLength());
                }
                catch (BadLocationException err) {
                    return null;
                }
            }
            return null;
        }
    }
}

