/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import logformat.slog2.LineIDMap;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.histogram.CanvasStatline;
import viewer.histogram.StatBoxStatusPanel;
import viewer.histogram.StatlineToolBar;
import viewer.histogram.SummaryStateComboBox;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ModelTimePanel;
import viewer.zoomable.RowAdjustments;
import viewer.zoomable.RulerTime;
import viewer.zoomable.ScrollbarTime;
import viewer.zoomable.ViewportTime;
import viewer.zoomable.ViewportTimePanel;
import viewer.zoomable.ViewportTimeYaxis;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class StatlinePanel
extends JPanel {
    private Window root_window;
    private TimeBoundingBox timebox;
    private BufForTimeAveBoxes buf4statboxes;
    private StatlineToolBar toolbar;
    private StatBoxStatusPanel status_panel;
    private BoundedRangeModel y_model;
    private YaxisMaps y_maps;
    private YaxisTree y_tree;
    private JScrollPane y_scroller;
    private JScrollBar y_scrollbar;
    private ModelTime time_model;
    private ScrollbarTime time_scrollbar;
    private ModelTimePanel time_display_panel;
    private RulerTime time_ruler;
    private ViewportTime time_ruler_vport;
    private ViewportTimePanel time_ruler_panel;
    private CanvasStatline stat_canvas;
    private ViewportTimeYaxis stat_canvas_vport;
    private ViewportTimePanel stat_canvas_panel;
    private SummaryStateComboBox summary_state_combobox;
    private RowAdjustments row_adjs;
    private String err_msg;

    public StatlinePanel(Window parent_window, TimeBoundingBox times, LineIDMap lineIDmap, BufForTimeAveBoxes statboxes) {
        this.root_window = parent_window;
        this.timebox = times;
        this.buf4statboxes = statboxes;
        String[] y_colnames = lineIDmap.getColumnLabels();
        this.y_maps = new YaxisMaps(lineIDmap);
        this.y_tree = new YaxisTree(this.y_maps.getTreeRoot());
        this.y_maps.setTreeView(this.y_tree);
        this.y_scroller = new JScrollPane(this.y_tree, 22, 32);
        this.y_scrollbar = this.y_scroller.getVerticalScrollBar();
        this.y_model = this.y_scrollbar.getModel();
        this.time_model = Parameters.HISTOGRAM_ZERO_ORIGIN ? new ModelTime(this.root_window, 0.0, this.timebox.getDuration()) : new ModelTime(this.root_window, this.timebox.getEarliestTime(), this.timebox.getLatestTime());
        this.setLayout(new BorderLayout());
        JPanel center_panel = new JPanel();
        center_panel.setLayout(new BoxLayout(center_panel, 1));
        this.time_ruler = new RulerTime(this.time_model);
        this.time_ruler_vport = new ViewportTime(this.time_model);
        this.time_ruler_vport.setView(this.time_ruler);
        this.time_ruler_panel = new ViewportTimePanel(this.time_ruler_vport);
        if (Parameters.HISTOGRAM_ZERO_ORIGIN) {
            this.time_ruler_panel.setBorderTitle(" Duration (seconds) ", 3, 5, Const.FONT, Color.red);
        } else {
            this.time_ruler_panel.setBorderTitle(" Time (seconds) ", 3, 5, Const.FONT, Color.red);
        }
        this.time_ruler_vport.initLeftMouseToZoom(false);
        this.time_model.addTimeListener(this.time_ruler_vport);
        Insets ruler_panel_insets = this.time_ruler_panel.getInsets();
        int ruler_panel_height = ruler_panel_insets.top + this.time_ruler.getJComponentHeight() + ruler_panel_insets.bottom;
        this.time_ruler_panel.setPreferredSize(new Dimension(100, ruler_panel_height));
        this.stat_canvas = new CanvasStatline(this.time_model, this.buf4statboxes, this.y_model, this.y_maps, y_colnames);
        this.stat_canvas_vport = new ViewportTimeYaxis(this.time_model, this.y_model, this.y_tree);
        this.stat_canvas_vport.setView(this.stat_canvas);
        this.stat_canvas_panel = new ViewportTimePanel(this.stat_canvas_vport);
        this.stat_canvas_panel.setBorderTitle(" Statistics ", 3, 2, null, Color.blue);
        this.stat_canvas_vport.initLeftMouseToZoom(true);
        this.time_model.addTimeListener(this.stat_canvas_vport);
        this.time_display_panel = new ModelTimePanel(this.time_model);
        this.time_model.setParamDisplay(this.time_display_panel);
        this.time_display_panel.addViewportTime(this.time_ruler_vport);
        this.time_display_panel.addViewportTime(this.stat_canvas_vport);
        JPanel canvas_lmouse = this.stat_canvas_vport.createLeftMouseModePanel(0);
        canvas_lmouse.setToolTipText("Operation for left mouse button click on Statistics canvas");
        this.time_display_panel.add(canvas_lmouse);
        this.time_scrollbar = new ScrollbarTime(this.time_model);
        this.time_scrollbar.setEnabled(true);
        this.time_model.setScrollBar(this.time_scrollbar);
        center_panel.add(this.time_display_panel);
        center_panel.add(this.stat_canvas_panel);
        center_panel.add(this.time_scrollbar);
        center_panel.add(this.time_ruler_panel);
        JPanel left_panel = new JPanel();
        left_panel.setLayout(new BoxLayout(left_panel, 1));
        this.status_panel = new StatBoxStatusPanel(this.buf4statboxes);
        int panel_height = this.time_display_panel.getPreferredSize().height;
        this.status_panel.setMinimumSize(new Dimension(85, panel_height));
        this.status_panel.setMaximumSize(new Dimension(Short.MAX_VALUE, panel_height));
        this.status_panel.setPreferredSize(new Dimension(85, panel_height));
        this.status_panel.setAlignmentX(0.5f);
        Insets canvas_panel_insets = this.stat_canvas_panel.getInsets();
        this.summary_state_combobox = new SummaryStateComboBox();
        this.summary_state_combobox.setMinimumSize(new Dimension(0, canvas_panel_insets.top));
        this.summary_state_combobox.setMaximumSize(new Dimension(Short.MAX_VALUE, canvas_panel_insets.top));
        this.summary_state_combobox.setPreferredSize(new Dimension(20, canvas_panel_insets.top));
        this.summary_state_combobox.setAlignmentX(0.5f);
        this.y_scroller.setAlignmentX(0.5f);
        this.y_scrollbar.addAdjustmentListener(this.stat_canvas_vport);
        int left_bottom_height = ruler_panel_height + canvas_panel_insets.bottom;
        JTextArea y_colarea = new JTextArea();
        StringBuffer text_space = new StringBuffer(" ");
        for (int idx = 0; idx < y_colnames.length; ++idx) {
            y_colarea.append(text_space.toString() + "@ " + y_colnames[idx] + "\n");
            text_space.append("    ");
        }
        JScrollPane y_colpanel = new JScrollPane(y_colarea, 22, 32);
        y_colpanel.setMinimumSize(new Dimension(0, left_bottom_height));
        y_colpanel.setMaximumSize(new Dimension(Short.MAX_VALUE, left_bottom_height));
        y_colpanel.setPreferredSize(new Dimension(20, left_bottom_height));
        left_panel.add(this.status_panel);
        left_panel.add(this.summary_state_combobox);
        left_panel.add(this.y_scroller);
        left_panel.add(y_colpanel);
        JPanel right_panel = new JPanel();
        right_panel.setLayout(new BoxLayout(right_panel, 1));
        this.row_adjs = new RowAdjustments(this.stat_canvas_vport, this.y_tree);
        JPanel row_resize = this.row_adjs.getComboBoxPanel();
        row_resize.setMinimumSize(new Dimension(0, canvas_panel_insets.top));
        row_resize.setMaximumSize(new Dimension(Short.MAX_VALUE, canvas_panel_insets.top));
        row_resize.setPreferredSize(new Dimension(20, canvas_panel_insets.top));
        row_resize.setAlignmentX(0.5f);
        JPanel row_txtfld = this.row_adjs.getTextFieldPanel();
        row_txtfld.setAlignmentX(0.5f);
        JPanel row_slider = this.row_adjs.getSliderPanel();
        JScrollPane slider_scroller = new JScrollPane(row_slider, 21, 32);
        slider_scroller.setAlignmentX(0.5f);
        JPanel row_misc = this.row_adjs.getMiscPanel();
        row_misc.setAlignmentX(0.5f);
        JPanel ruler_lmouse = this.time_ruler_vport.createLeftMouseModePanel(0);
        ruler_lmouse.setToolTipText("Operation for left mouse button click on Time Ruler");
        ruler_lmouse.setAlignmentX(0.0f);
        row_misc.add(ruler_lmouse);
        JScrollPane row_colpanel = new JScrollPane(row_misc, 20, 30);
        row_colpanel.setMinimumSize(new Dimension(0, left_bottom_height));
        row_colpanel.setMaximumSize(new Dimension(Short.MAX_VALUE, left_bottom_height));
        row_colpanel.setPreferredSize(new Dimension(20, left_bottom_height));
        right_panel.add(row_resize);
        right_panel.add(row_txtfld);
        right_panel.add(slider_scroller);
        right_panel.add(row_colpanel);
        JSplitPane left_splitter = new JSplitPane(1, false, left_panel, center_panel);
        JSplitPane right_splitter = new JSplitPane(1, false, left_splitter, right_panel);
        right_splitter.setOneTouchExpandable(true);
        this.err_msg = null;
        try {
            left_splitter.setOneTouchExpandable(true);
            right_splitter.setResizeWeight(1.0);
        }
        catch (NoSuchMethodError err) {
            this.err_msg = "Method JSplitPane.setResizeWeight() cannot be found.\nThis indicates you are running an older Java2 RunTime,\nlike the one in J2SDK 1.2.2 or older. If this is the case,\nsome features in Statline window may not work correctly,\nFor instance, automatic resize of the Statline canvas\nduring window resizing and auto-update of the canvas\nafter adjustment of the slider's knob may fail silently,\nmanuel refresh of the canvas will be needed.";
        }
        this.add((Component)right_splitter, "Center");
        this.toolbar = new StatlineToolBar(this.root_window, this.stat_canvas_vport, this.y_scrollbar, this.y_tree, this.y_maps, this.time_scrollbar, this.time_model, this.row_adjs);
        this.add((Component)this.toolbar, "North");
        this.y_tree.init();
        this.row_adjs.initYLabelTreeSize();
        this.status_panel.addRedrawListener(this.toolbar.getPropertyRefreshButton());
        this.summary_state_combobox.addRedrawListener(this.toolbar.getPropertyRefreshButton());
    }

    public void init() {
        this.toolbar.init();
        this.row_adjs.initSlidersAndTextFields();
        this.status_panel.init();
        this.summary_state_combobox.init();
        if (this.err_msg != null) {
            Dialogs.error(this.root_window, this.err_msg);
        }
        if (Debug.isActive()) {
            Debug.println("StatlinePanel.init(): time_model = " + this.time_model);
            Debug.println("StatlinePanel.init(): time_scrollbar = " + this.time_scrollbar);
            Debug.println("StatlinePanel.init(): time_ruler = " + this.time_ruler);
        }
    }
}

