/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import viewer.legends.LegendComparators;
import viewer.legends.LegendTableModel;

public class OperationStringMenu
extends JPopupMenu {
    private static String index_order_icon_path = "/images/checkbox/IndexOrder.gif";
    private static String case_sensitive_topo_order_icon_path = "/images/checkbox/CaseSensitiveTopoOrder.gif";
    private static String case_insensitive_topo_order_icon_path = "/images/checkbox/CaseInsensitiveTopoOrder.gif";
    private static String case_sensitive_order_icon_path = "/images/checkbox/CaseSensitiveOrder.gif";
    private static String case_insensitive_order_icon_path = "/images/checkbox/CaseInsensitiveOrder.gif";
    private static String reverse_order_icon_path = "/images/checkbox/ReverseOrder.gif";
    private JTable table_view;
    private LegendTableModel table_model;
    private int str_column;

    public OperationStringMenu(JTable in_table, int in_column) {
        this.table_view = in_table;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        this.str_column = in_column;
        super.setLabel(this.table_model.getColumnName(this.str_column));
        super.setToolTipText(this.table_model.getColumnToolTip(this.str_column));
        this.addMenuItems();
    }

    private void addMenuItems() {
        URL icon_URL = null;
        icon_URL = this.getURL(case_sensitive_topo_order_icon_path);
        ImageIcon icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        JMenuItem menu_item = new JMenuItem("A...Z a...z", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationStringMenu.this.table_model.arrangeOrder(LegendComparators.CASE_SENSITIVE_ORDER);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(case_sensitive_topo_order_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("z...a Z...A", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationStringMenu.this.table_model.reverseOrder(LegendComparators.CASE_SENSITIVE_ORDER);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(case_sensitive_topo_order_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Aa...Zz", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationStringMenu.this.table_model.arrangeOrder(LegendComparators.CASE_INSENSITIVE_ORDER);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(case_sensitive_topo_order_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("zZ...aA", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationStringMenu.this.table_model.reverseOrder(LegendComparators.CASE_INSENSITIVE_ORDER);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(index_order_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Creation Order", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationStringMenu.this.table_model.arrangeOrder(LegendComparators.INDEX_ORDER);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(index_order_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Reverse Creation Order", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationStringMenu.this.table_model.reverseOrder(LegendComparators.INDEX_ORDER);
            }
        });
        super.add(menu_item);
    }

    private URL getURL(String filename) {
        return this.getClass().getResource(filename);
    }
}

