/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.CoordPixelXform;
import base.drawable.TimeBoundingBox;
import viewer.zoomable.ScrollableObject;

public class CoordPixelImage
implements CoordPixelXform {
    private ScrollableObject img_obj;
    private int row_hgt;
    private int row_half_hgt;
    private TimeBoundingBox img_endtimes;
    private double img_starttime;
    private double img_finaltime;
    private int ipix_start;
    private int ipix_final;
    private int ipix_width;

    public CoordPixelImage(ScrollableObject image_object) {
        this.img_obj = image_object;
        this.row_hgt = 0;
        this.row_half_hgt = 0;
    }

    public CoordPixelImage(ScrollableObject image_object, int row_height, TimeBoundingBox image_timebounds) {
        this(image_object);
        this.resetRowHeight(row_height);
        this.resetTimeBounds(image_timebounds);
    }

    public void resetRowHeight(int row_height) {
        this.row_hgt = row_height;
        this.row_half_hgt = row_height / 2 + 1;
    }

    public void resetTimeBounds(TimeBoundingBox image_timebounds) {
        this.img_endtimes = image_timebounds;
        this.img_starttime = image_timebounds.getEarliestTime();
        this.img_finaltime = image_timebounds.getLatestTime();
        this.ipix_start = this.img_obj.time2pixel(this.img_starttime);
        this.ipix_final = this.img_obj.time2pixel(this.img_finaltime);
        this.ipix_width = this.ipix_final - this.ipix_start + 1;
    }

    public int convertTimeToPixel(double time_coord) {
        return this.img_obj.time2pixel(time_coord) - this.ipix_start;
    }

    public double convertPixelToTime(int hori_pixel) {
        return this.img_obj.pixel2time(hori_pixel + this.ipix_start);
    }

    public int convertRowToPixel(float rowID) {
        return Math.round(rowID * (float)this.row_hgt + (float)this.row_half_hgt);
    }

    public float convertPixelToRow(int vert_pixel) {
        return (float)(vert_pixel - this.row_half_hgt) / (float)this.row_hgt;
    }

    public boolean contains(double time_coord) {
        return this.img_endtimes.contains(time_coord);
    }

    public boolean overlaps(TimeBoundingBox timebox) {
        return this.img_endtimes.overlaps(timebox);
    }

    public int getImageWidth() {
        return this.ipix_width;
    }
}

