/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import viewer.common.Routines;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.OperationDurationPanel;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.SummarizableView;
import viewer.zoomable.TimeFormat;

public class InfoDialogForDuration
extends InfoDialog {
    private static final String FORMAT = "#,##0.000000####";
    private static DecimalFormat fmt = null;
    private static TimeFormat tfmt = null;
    private TimeBoundingBox timebox;
    private ScrollableObject scrollable;

    public InfoDialogForDuration(Frame frame, TimeBoundingBox times, ScrollableObject scrollobj) {
        super(frame, "Duration Info Box", times.getLatestTime());
        this.timebox = times;
        this.scrollable = scrollobj;
        this.init();
    }

    public InfoDialogForDuration(Dialog dialog, TimeBoundingBox times, ScrollableObject scrollobj) {
        super(dialog, "Duration Info Box", times.getLatestTime());
        this.timebox = times;
        this.scrollable = scrollobj;
        this.init();
    }

    private void init() {
        if (fmt == null) {
            fmt = (DecimalFormat)NumberFormat.getInstance();
            fmt.applyPattern(FORMAT);
        }
        if (tfmt == null) {
            tfmt = new TimeFormat();
        }
        Container root_panel = this.getContentPane();
        root_panel.setLayout(new BoxLayout(root_panel, 1));
        StringBuffer textbuf = new StringBuffer();
        int num_cols = 0;
        int num_rows = 3;
        StringBuffer linebuf = new StringBuffer();
        linebuf.append("duration = " + tfmt.format(this.timebox.getDuration()));
        num_cols = linebuf.length();
        textbuf.append(linebuf.toString() + "\n");
        linebuf = new StringBuffer();
        linebuf.append("[0]: time = " + fmt.format(this.timebox.getEarliestTime()));
        if (num_cols < linebuf.length()) {
            num_cols = linebuf.length();
        }
        textbuf.append(linebuf.toString() + "\n");
        linebuf = new StringBuffer();
        linebuf.append("[1]: time = " + fmt.format(this.timebox.getLatestTime()));
        if (num_cols < linebuf.length()) {
            num_cols = linebuf.length();
        }
        textbuf.append(linebuf.toString());
        JTextArea text_area = new JTextArea(textbuf.toString());
        int adj_num_cols = Routines.getAdjNumOfTextColumns(text_area, num_cols);
        text_area.setColumns(adj_num_cols);
        text_area.setRows(num_rows);
        text_area.setEditable(false);
        text_area.setLineWrap(true);
        JScrollPane scroller = new JScrollPane(text_area);
        scroller.setAlignmentX(0.0f);
        root_panel.add(scroller);
        if (this.scrollable instanceof SummarizableView) {
            SummarizableView summarizable = (SummarizableView)((Object)this.scrollable);
            OperationDurationPanel ops4d_panel = new OperationDurationPanel(this.timebox, summarizable);
            ops4d_panel.setAlignmentX(0.0f);
            root_panel.add(ops4d_panel);
        }
        root_panel.add(super.getCloseButtonPanel());
    }

    public TimeBoundingBox getTimeBoundingBox() {
        return this.timebox;
    }
}

