/*  NETMAJ-XUI -- X User Interface --  Copyright Notice
 *
 *      Copyright (c) 1995,1996 Todo Software All rights reserved.
 *
 *   You can redistribute it and/or modify this software under the terms
 *  of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *   This software is provided 'as-is', without any express or implied
 *  warranty.  In no event will the author be held liable for any damages
 *  arising from the use of this software.
 *  See the gpl.text for more details.
 *
 *   If you would like to do something with NETMAJ that this copyright
 *  prohibits (such as distributing it with a commercial product,
 *  using portions of the source in some other program, etc.), please
 *  contact the author (preferably via email).  Arrangements can
 *  probably be worked out.
 *
 *   Todo Software : NBC02365@niftyserve.or.jp
 */
/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * class.c -- 
 * 
 * $Id: class.c,v 1.2 1996/07/31 22:49:36 suz Exp $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:13:27 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Tue Sep 26 19:53:21 1995
 *   draw class and points window
 *  Copyright (C) 1995,1996 Todo Software All rights reserved
 */

#include "xnet.h"
#include "pixread.h"
#include "xnetmaj.h"
#include "gt/widget/text.h"
#include "pfinfo.h"

extern integer_t xwidth, xheight;
extern struct playerinfo playerinfo;

static widget_t class;
static widget_t header, myname;
static widget_t currentclass;
static widget_t nextclass;
static widget_t message, message2, message3;
extern integer_t red;

static void
class_keywait_callback ()
{
  widget_unmap (class);
  board_redraw (1);
}

extern integer_t yellow, white;

widget_t
create_class_frame (parent)
     widget_t parent;
{
  widget_t frame0, frame1, frame2, frame3, frame4, baseframe, name;
  widget_t okbutton, quitbutton;
  integer_t x;
  integer_t frame1h, frame2h, frame3h, frame4h;


  baseframe = widget_create ("frame", parent);
  header = frame0 = widget_create ("text", baseframe);
  frame1 = widget_create ("frame", baseframe);
  frame2 = widget_create ("frame", baseframe);
  frame3 = widget_create ("pmcontainer", baseframe);
  frame4 = widget_create ("frame", baseframe);

  widget_set_geometry (frame0, xwidth, 16);
  widget_configure (frame0, resource_textcolor, red);
  widget_configure (frame0, resource_textfont, XLARGETIMESIB);
  widget_configure (frame0, resource_textshadow, 1);
  widget_configure (frame0, resource_text, "     NETMAJ Class Evaluation");

  widget_set_geometry (frame1, xwidth, 16);
  widget_configure (frame1, resource_packed, resource_horizontal);
  widget_configure (frame1, resource_frame_start, 50);
  if (pm_taku.pm)
    pmcontainer_add (frame3, pm_taku.pm, pm_taku.Mpm, 1);
  widget_set_geometry (frame3, xwidth, 388);
/*  widget_configure (frame3, resource_packed, resource_horizontal);              */
  widget_configure (frame3, resource_pixmapstart, 130);

  myname = widget_create ("text", frame1);
  currentclass = widget_create ("text", frame1);
  nextclass = widget_create ("text", frame1);
  widget_set_geometry (myname, 150, 16);
  widget_set_geometry (currentclass, 200, 16);
  widget_set_geometry (nextclass, 200, 16);
  widget_configure (myname, resource_textfont, MEDIUMJP);
  widget_configure (currentclass, resource_textfont, MEDIUMJP);
  widget_configure (nextclass, resource_textfont, MEDIUMJP);

  widget_pack (frame1);

  message = widget_create ("text", frame2);
  widget_set_geometry (message, xwidth, 16);
  widget_configure (message, resource_textfont, MEDIUMJP);
  message2 = widget_create ("text", frame2);
  widget_set_geometry (message2, xwidth, 16);
  widget_configure (message2, resource_textfont, MEDIUMJP);
  message3 = widget_create ("text", frame2);
  widget_set_geometry (message3, xwidth, 16);
  widget_configure (message3, resource_textfont, MEDIUMJP);

  widget_pack (frame2);

  widget_configure (frame4, resource_packed, resource_horizontal);
  widget_configure (frame4, resource_frame_start, 270);
  widget_set_geometry (frame4, xwidth, BUTTON_H + 10);
  okbutton = widget_create ("button", frame4);
  widget_set_geometry (okbutton, BUTTON_W, BUTTON_H);
  widget_configure (okbutton, resource_text, "ok");
  widget_configure (okbutton, resource_textcolor, yellow);
  widget_configure (okbutton, resource_textfont, TIMESI);
  widget_add_callback (okbutton,
		       resource_buttonpress_callback,
		       (void *) class_keywait_callback, "");
  widget_pack (frame4);
  widget_pack (baseframe);

  widget_set_geometry (baseframe, xwidth, xheight);
  widget_fix (baseframe);


  return baseframe;
}


static struct classinfo
{
  int n_last;
  int point;
  char *name;
}
classinfo[] =
{
  {
    4, 20, ""
  }
  ,
  {
    4, 21, ""
  }
  ,
  {
    4, 22, "Ȭ"
  }
  ,
  {
    4, 23, ""
  }
  ,
  {
    4, 26, "ϻ"
  }
  ,
  {
    8, 27, "޵"
  }
  ,
  {
    12, 27, "͵"
  }
  ,
  {
    12, 29, ""
  }
  ,
  {
    10, 30, ""
  }
  ,
  {
    10, 31, ""
  }
  ,
  {
    60, 33, ""
  }
  ,
  {
    4, 37, ""
  }
  ,
  {
    28, 35, ""
  }
  ,
  {
    12, 40, ""
  }
  ,
  {
    16, 42, ""
  }
  ,
  {
    20, 43, "ϻ"
  }
  ,
  {
    10, 44, ""
  }
  ,
  {
    15, 45, "Ȭ"
  }
  ,
  {
    15, 46, ""
  }
  ,
  {
    15, 48, ""
  }
  ,
  {
    20, 53, "̾"
  }
  ,
  {
    30, 63, ""
  }
  ,
  {
    0, 0, 0,
  }
  ,
};

static widget_t class;
integer_t myclass;

static char *
fightmessage (i)
     int i;
{
  if (i < 1)
    {
      return "ȰǤ";
    }
  if (i < 2)
    {
      return "ˤǤ͡";
    }
  if (i < 3)
    {
      return "⤦ҤȤǤ";
    }
  if (i < 4)
    {
      return "ޤޤǤ";
    }
  if (i < 5)
    {
      return "ϤФǤ";
    }
  if (i < 6)
    {
      return "ľ褤⡣";
    }
  if (i < 7)
    {
      return "ФäƤ";
    }
  if (i < 8)
    {
      return "⤦ҤȤդФǤ";
    }
  if (i < 9)
    {
      return "ϤФޤ礦";
    }
  if (i < 10)
    {
      return "äǤ";
    }
  if (i < 11)
    {
      return "äȤҤɤǤ͡";
    }
  if (i < 12)
    {
      return "ߤޤ";
    }
  return "Ԥ­ޤ";
}

void
info_class (name)
     char *name;
{
  int count;
  char buf[255];

  if (!class)
    {
      extern widget_t root_widget;
      class = create_class_frame (root_widget);
    }
  myclass = flag_myclass;

  sprintf (buf, "̾ %s", name);
  widget_configure (myname, resource_text, buf);

  if (myclass < 0 || myclass >= sizeof (classinfo) / sizeof (classinfo[0]) - 1)
    {
      myclass = 0;
    }

  if (!classinfo[myclass + 1].name)
    {
      /* sennin */
      widget_configure (currentclass,
			resource_text,
		"ʤϡͤǤ褯ԤѤȴޤ");
      widget_configure (message,
			resource_text,
		     "NBC02365@niftyserve.co.jpޤǼΥ᡼򤷤Ƥ͡");
      return;
    }
  else
    {
      count = classinfo[myclass + 1].n_last;
    }
  if (count == 0)
    {
      count = 30;
    }

  read_player_info_last (name, count);
  if (playerinfo.game >= count && classinfo[myclass + 1].point <= (playerinfo.pnt / count))
    {
      sprintf (buf,
	       "ǤȤޤ%s  %s ؾʤޤ",
	       classinfo[myclass].name, classinfo[myclass + 1].name);
      widget_configure (message, resource_textcolor, yellow);
      widget_configure (message, resource_text, buf);
      myclass++;
      widget_configure (message2, resource_text, "");
      widget_configure (message3, resource_text, "");
    }
  else
    {
      sprintf (buf,
	       "ʤξϡľ %d ʿ %d ݥȤǤߤϡʿ%dݥȤǤ",
	       count,
	       classinfo[myclass].point,
	       (playerinfo.pnt / count));
      widget_configure (message, resource_text, buf);
      widget_configure (message, resource_textcolor, white);
      if (playerinfo.game < count)
	{
	  sprintf (buf,
	   "ʾΥ­ޤ󡣤 %d ԤʤäƲ",
		   count - playerinfo.game);
	  widget_configure (message2, resource_text, buf);
	  widget_configure (message3, resource_text, "");
	}
      else
	{
	  widget_configure (message2, resource_text, "");
	  widget_configure (message3, resource_text, fightmessage (classinfo[myclass].point - (playerinfo.pnt / count)));
	}
    }

  sprintf (buf, "ʤϡ %s Ǥ", classinfo[myclass].name);
  widget_configure (currentclass, resource_text, buf);
  sprintf (buf, "ĤΥ٥ %s Ǥ", classinfo[myclass + 1].name);
  widget_configure (nextclass, resource_text, buf);



  widget_map (class);

  widget_display (class);
  widget_flush (class);
}

extern widget_t about;

void
class_callback callbackarg_param
{
  widget_unmap (about);
  if (flag_username)
    {
      info_class (flag_username);
    }
}
