/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../mainwin.h"

void nmapClass::readBuffer()
{
	QString * StdoutStr;
	QString * StderrorStr;
	QString title = "NmapSI4 ";
	int open_port = 0;
	int close_port = 0;
	int filtered_port = 0;
	int error_count = 0;

	QList<int> vector;

	StdoutStr = new QString(proc-> readAllStandardOutput()); // read std buffer
	StderrorStr = new QString(proc->readAllStandardError()); // read error buffer

	progressScan->setValue(75);
	this->setWindowTitle(title.append("(75%)"));

	QTextStream stream( StdoutStr );
	QString tmp,buffer,buffer2,bufferInfo;

	while ( !stream.atEnd() )
	{
		tmp = stream.readLine();

		if((tmp.contains("open") || tmp.contains("closed")
					  || tmp.contains("filtered")
					  || tmp.contains("unfiltered"))
					  && !tmp.contains("Not shown:")
					  && !tmp.contains("Discovered")) {

			buffer2.append(tmp);
			buffer2.append("\n");
		}

		if(tmp.contains("Hosts:") || tmp.contains("Host:")) {
			buffer.append(tmp);
		}

		if(tmp.contains("MAC") 	|| tmp.contains("OS details:")
					|| tmp.contains("Device type:")
					|| tmp.contains("Uptime:")
					|| tmp.contains("TCP Sequence Prediction:")
					|| tmp.contains("IPID Sequence Generation:")
					|| tmp.contains("Network Distance:")) {

			bufferInfo.append(tmp);
			bufferInfo.append("\n");
		}

	}


	root = new QTreeWidgetItem(listWscan);
	root2 = new QTreeWidgetItem(listScan);
	error = new QTreeWidgetItem(listScanError);

	infoItem = new QTreeWidgetItem(treeWinfo);

	listWscan->setIconSize(QSize::QSize (22, 22));
	listWscan->header()->setResizeMode(0, QHeaderView::Interactive );
	listScanError->setIconSize(QSize::QSize (22, 22));
	listScanError->header()->setResizeMode(0, QHeaderView::Interactive );
	listScan->header()->setResizeMode(0, QHeaderView::Interactive );
	treeWinfo->setIconSize(QSize::QSize (22, 22));
	treeWinfo->header()->setResizeMode(0, QHeaderView::Interactive );

	if(!hostEdit->text().contains("(Stopped)"))
	  root->setIcon( 0, QIcon(QString::fromUtf8(":/images/images/viewmagfit.png")));
	else
	  root->setIcon(0, QIcon(QString::fromUtf8(":/images/images/messagebox_critical.png")));

	root2->setIcon(0, QIcon(QString::fromUtf8(":/images/images/book.png")));
	error->setIcon(0, QIcon(QString::fromUtf8(":/images/images/messagebox_critical.png")));
	infoItem->setIcon(0, QIcon(QString::fromUtf8(":/images/images/messagebox_info.png")));

	if(!buffer.isEmpty()) { // Host line scan
  		root->setForeground(0, Qt::white);
  		root->setBackground(0, Qt::gray);
		root->setText(0,buffer);
		root2->setText(0,buffer);
		error->setText(0,buffer);
		infoItem->setText(0,buffer);
	}
	else {
  		root->setForeground(0, Qt::white);
  		root->setBackground(0, Qt::gray);
		root->setText(0,hostEdit->text());
		root2->setText(0,hostEdit->text());
		error->setText(0,hostEdit->text());
		infoItem->setText(0,hostEdit->text());
	}

	QTextStream b2(&buffer2); // QString to QtextStrem (scan Tree)
	QString b2_line;

	if(!b2.atEnd()) { // check for scan informations
		while( !b2.atEnd() )
		{
			b2_line = b2.readLine();
			item2 = new QTreeWidgetItem(root);

			if(b2_line.contains("open")	|| b2_line.contains("filtered")
							|| b2_line.contains("unfiltered")) {

				if(b2_line.contains("filtered") || b2_line.contains("unfiltered")) {
					item2->setIcon( 0, QIcon(QString::fromUtf8(":/images/images/flag_yellow.png")));
					filtered_port++;
				} else {
					item2->setIcon( 0, QIcon(QString::fromUtf8(":/images/images/flag_green.png")));
					open_port++;
				}
			}
			else {
				item2->setIcon( 0, QIcon(QString::fromUtf8(":/images/images/flag_red.png")));
				close_port++;
			}


 			if(!b2_line.isEmpty()) {
				  item2->setText(0,b2_line);
			} else
				item2->setText(0,tr("No Ports"));

 			vector << item2->text(0).length(); // vector of item text length

		}
	} else { // insert message for no info
		QString tmp_mess = root->text(0);
		tmp_mess.append(tr("\n(No scan informations)"));
		root->setText(0,tmp_mess);
	}

	QTextStream b3(&bufferInfo); // QString to QtextStrem (scan Tree)
	QString b3_line;

	if(!b3.atEnd()) { // check for scan informations
		while( !b3.atEnd() )
		{
			b3_line = b3.readLine();
			infoItemObj = new QTreeWidgetItem(infoItem);

			if(!b3_line.isEmpty()) {
				infoItemObj->setIcon( 0, QIcon(QString::fromUtf8(":/images/images/messagebox_info.png")));
				infoItemObj->setText(0,b3_line);
			} else
				infoItemObj->setText(0,tr("No Info"));

		}
	} else { // insert message for no info
		QString tmp_mess = root->text(0);
		tmp_mess.append(tr("\n(No Host Informations)"));
		infoItem->setText(0,tmp_mess);
	}

	/* Check max item length for widget extension*/
	int maxDim = 0;
	int i;

	if(vector.size())
	{
		maxDim = vector[0];
		for( i=1; i < vector.size(); i++){ // O(n) linear time
			if(maxDim < vector[i])
				maxDim = vector[i];
		}

		buttonClearHistory->setEnabled(TRUE);
		QString tmp_buffer = root->text(0);
		tmp_buffer.append(tr("\n(Report: "));
		tmp_buffer.append(tr("OPEN: "));
		tmp_buffer.append(QString("%1").arg(open_port));
		tmp_buffer.append(tr(", CLOSE: "));
		tmp_buffer.append(QString("%1").arg(close_port));
		tmp_buffer.append(tr(", FI/UNFILTERED: "));
		tmp_buffer.append(QString("%1").arg(filtered_port));
		tmp_buffer.append(" )");
		root->setText(0,tmp_buffer);
	}

	maxDim *= 8; // resize constant

	listWscan->header()->resizeSection(0, maxDim);

	QTextStream b_log(StdoutStr);
	QString blog_line;

	QTextStream *out = NULL;

	if(checkLog) {
		out = new QTextStream(PFile);
		QString nmap_command;
		nmap_command.append("\nnmap ");
		nmap_command.append(lineOptions->text());
		nmap_command.append(hostEdit->text());
		*out << nmap_command << "\n";
	}


	while(!b_log.atEnd())
	{
		blog_line = b_log.readLine();
		item_root2 = new QTreeWidgetItem(root2); // append scan log
		item_root2->setText(0,blog_line);

		if(checkLog) {
			*out << blog_line << "\n";
		}
	}

 	if(checkLog) delete out;

	QTextStream b_error(StderrorStr);
	QString error_line;

	if(!b_error.atEnd()) { // check for no error
		while(!b_error.atEnd()) { // print error buffer informations
			item_error = new QTreeWidgetItem(error); // item_error memory allocation
			error_line = b_error.readLine();
			item_error->setText(0,error_line);
			error_count++;
		}

	} else {
		QString tmp_mess = error->text(0);
		tmp_mess.append(tr("\n(No Errors or Warnings)"));
		error->setText(0,tmp_mess);
	}

	if(error_count) {
		QString tmp_buffer_error = error->text(0);
		tmp_buffer_error.append(tr("\n(Report: "));
		tmp_buffer_error.append(tr("ERRORS or WARNINGS: "));
		tmp_buffer_error.append(QString("%1").arg(error_count));
		tmp_buffer_error.append(" )");
		error->setText(0,tmp_buffer_error);
	}


	delete StdoutStr;
	delete StderrorStr;

	progressScan->setValue(85);
	this->setWindowTitle(title.replace("(75%)","(85%)"));
	progressScan->setValue(100);
	this->setWindowTitle(title.replace("(85%)","(100%)"));

	buttonScan->setEnabled(TRUE); // enable scan button
	action_Scan_menu->setEnabled(TRUE);
	hostEdit->setEnabled(TRUE);
	stopButton->setEnabled(FALSE);

}
