/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "nmapsi4File.h"

void nmapsi4File::configBase(QTextStream *Stream) {

	/*
	* Profile for new configuration file.
	*/
	QStringList config; // conf file options List

	QString path_string = "confPath=";
	path_string.append(QDir::homePath());
	path_string.append("/");

	QString logCheck = "logCheck=";
	logCheck.append("NO");

	config << path_string;
	config << logCheck;

	QString token;

	*Stream << "[Log Config]\n";
	foreach(QString token, config) {
		*Stream << token << "\n"; // write config standard option
	}

	// Profile Information
	QString profile = "configProfile=";
	profile.append("normal");

	*Stream << "\n[Profile Config]\n";
	*Stream << profile << "\n";
}
