/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_bulletin_board.h,v 1.27.2.5 2005/08/15 17:15:07 fuyu Exp $
 */

#ifndef _OCHUSHA_BULLETIN_BOARD_H_
#define _OCHUSHA_BULLETIN_BOARD_H_

#include "ochusha.h"
#include "ochusha_async_buffer.h"
#include "ochusha_network_broker.h"
#include "monitor.h"

#include <glib-object.h>
#include <glib.h>

#include <zlib.h>


#ifdef __cplusplus
extern "C" {
#endif


#define OCHUSHA_TYPE_BULLETIN_BOARD		(ochusha_bulletin_board_get_type())
#define OCHUSHA_BULLETIN_BOARD(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BULLETIN_BOARD, OchushaBulletinBoard))
#define OCHUSHA_BULLETIN_BOARD_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BULLETIN_BOARD, OchushaBulletinBoardClass))
#define OCHUSHA_IS_BULLETIN_BOARD(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BULLETIN_BOARD))
#define OCHUSHA_IS_BULLETIN_BOARD_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BULLETIN_BOARD))
#define OCHUSHA_BULLETIN_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BULLETIN_BOARD, OchushaBulletinBoardClass))


typedef struct _OchushaBulletinBoard OchushaBulletinBoard;
typedef struct _OchushaBulletinBoardClass OchushaBulletinBoardClass;

enum
{
  OCHUSHA_BBS_TYPE_UNKNOWN = -1,
  OCHUSHA_BBS_TYPE_2CH = 0,
  OCHUSHA_BBS_TYPE_2CHLIKE_EUCJP,
  OCHUSHA_BBS_TYPE_JBBS,
  OCHUSHA_BBS_TYPE_MACHIBBS,
  OCHUSHA_BBS_TYPE_JBBS_SHITARABA,
  OCHUSHA_BBS_TYPE_MITINOKU,
  OCHUSHA_BBS_TYPE_2CH_COMPATIBLE,
  OCHUSHA_BBS_TYPE_2CH_HEADLINE,
  OCHUSHA_BBS_TYPE_2CH_BE,
};


struct _OchushaBulletinBoard
{
  GObject parent_object;

  gchar *name;			/* 㤨 "UNIX" */
  char *base_url;		/* 㤨 "http://pc.2ch.net/unix/" */

  /* ʲλĤbase_url롣*/
  char *server;			/* 㤨 "pc.2ch.net" */
  char *base_path;		/* 㤨 "/" */
  char *id;			/* 㤨 "unix" */

  /* JBBSФĤξbase_pathidϼΤ褦ˤʤ롣
   * base_url="http://jbbs.shitaraba.com/computer/351/"Ϳ줿
   * server="jbbs.shitaraba.com"
   * base_path="/computer/"
   * id="351"
   */

  GSList *thread_list;		/* Ƥ륹(OchushaBBSThread *)ꥹ */
  GHashTable *thread_table;	/* ID(DATե̾)=>(OchushaBBSThread *) */
  GSList *dropped_list;		/* DAT(OchushaBBSThread *)ꥹ */

  int bbs_type;			/* ǼĤμ */

  gboolean hidden;		/* İ鱣 */
  gboolean killed;		/* İ¸˼ΤƤ */

  /* 񤭹ߥե饰(BeȤɤʤ) */
  int post_mode;

  Monitor *monitor;
};


struct _OchushaBulletinBoardClass
{
  GObjectClass parent_class;

  /* signals */
  void (*read_boardlist_element)(OchushaBulletinBoard *board,
				 GHashTable *board_attributes);
  void (*write_boardlist_element)(OchushaBulletinBoard *board,
				  gzFile boardlist_xml);
  void (*threadlist_read_thread_element)(OchushaBulletinBoard *board,
					 OchushaBBSThread *thread,
					 GHashTable *thread_attributes);
  void (*threadlist_write_thread_element)(OchushaBulletinBoard *board,
					  OchushaBBSThread *thread,
					  gzFile threadlist_xml);

  /* virtual function table */
  void (*recover_threadlist)(OchushaBulletinBoard *board,
			     OchushaConfig *config);
  char *(*generate_base_path)(OchushaBulletinBoard *board, const char *url);
  char *(*generate_board_id)(OchushaBulletinBoard *board, const char *url);
  void (*server_changed)(OchushaBulletinBoard *board, const char *prev_server);
  OchushaBBSThread *(*thread_new)(OchushaBulletinBoard *board,
				  const char *id, const gchar *title);
  OchushaBBSThread *(*lookup_thread_by_url)(OchushaBulletinBoard *board,
					    OchushaNetworkBroker *broker,
					    const char *url);
  OchushaBBSThread *(*lookup_kako_thread_by_url)(OchushaBulletinBoard *board,
						 OchushaNetworkBroker *broker,
						 const char *url);
  OchushaAsyncBuffer *(*get_threadlist_source)(OchushaBulletinBoard *board,
					OchushaNetworkBroker *broker,
					OchushaAsyncBuffer *buffer,
					OchushaNetworkBrokerCacheMode mode);
  gboolean (*refresh_threadlist)(OchushaBulletinBoard *board,
				 OchushaAsyncBuffer *buffer,
				 EachThreadCallback *cb,
				 StartParsingCallback *start_parsing_cb,
				 BeforeWaitCallback *before_wait_cb,
				 AfterWaitCallback *after_wait_cb,
				 EndParsingCallback *end_parsing_cb,
				 gpointer callback_data);

  const char *(*get_response_character_encoding)(OchushaBulletinBoard *board);
  iconv_helper *(*get_response_iconv_helper)(OchushaBulletinBoard *board);

  gboolean (*preview_new_thread)(OchushaBulletinBoard *board,
				 const gchar *title,
				 const OchushaBBSResponse *response,
				 StartThreadCallback *start_cb,
				 EachResponseCallback *response_cb,
				 EndThreadCallback *end_cb,
				 gpointer callback_data);
  gboolean (*new_thread_supported)(OchushaBulletinBoard *board);
  gboolean (*create_new_thread)(OchushaBulletinBoard *board,
				OchushaNetworkBroker *broker,
				const gchar *title,
				const OchushaBBSResponse *response);
};


GType ochusha_bulletin_board_get_type(void) G_GNUC_CONST;
OchushaBulletinBoard *ochusha_bulletin_board_new(const gchar *name,
						 const char *url);

void ochusha_bulletin_board_set_name(OchushaBulletinBoard *board,
				     const gchar *name);
const gchar *ochusha_bulletin_board_get_name(OchushaBulletinBoard *board);

void ochusha_bulletin_board_set_base_url(OchushaBulletinBoard *board,
					 const char *url);
const char *ochusha_bulletin_board_get_base_url(OchushaBulletinBoard *board);

const char *ochusha_bulletin_board_get_server(OchushaBulletinBoard *board);
const char *ochusha_bulletin_board_get_base_path(OchushaBulletinBoard *board);
const char *ochusha_bulletin_board_get_id(OchushaBulletinBoard *board);

void ochusha_bulletin_board_process_board_move(OchushaBulletinBoard *board,
					       const char *new_url,
					       OchushaConfig *config);

void ochusha_bulletin_board_set_bbs_type(OchushaBulletinBoard *board,
					 int bbs_type);
int ochusha_bulletin_board_get_bbs_type(OchushaBulletinBoard *board);

void ochusha_bulletin_board_lock_thread_list(OchushaBulletinBoard *board);
gboolean ochusha_bulletin_board_trylock_thread_list(OchushaBulletinBoard *board);
void ochusha_bulletin_board_unlock_thread_list(OchushaBulletinBoard *board);

OchushaBBSThread *ochusha_bulletin_board_bbs_thread_new(
					OchushaBulletinBoard *board,
					const char *id, const gchar *title);
OchushaBBSThread *ochusha_bulletin_board_lookup_bbs_thread_by_id(
					OchushaBulletinBoard *board,
					const char *id);
OchushaBBSThread *ochusha_bulletin_board_lookup_bbs_thread_by_url(
					OchushaBulletinBoard *board,
					OchushaNetworkBroker *broker,
					const char *url);
OchushaBBSThread *ochusha_bulletin_board_lookup_kako_thread_by_url(
					OchushaBulletinBoard *board,
					OchushaNetworkBroker *broker,
					const char *url);

OchushaAsyncBuffer *ochusha_bulletin_board_get_threadlist_source(
					OchushaBulletinBoard *board,
					OchushaNetworkBroker *broker,
					OchushaAsyncBuffer *buffer,
					OchushaNetworkBrokerCacheMode mode);

gboolean ochusha_bulletin_board_refresh_threadlist(OchushaBulletinBoard *board,
						   OchushaAsyncBuffer *buffer,
						   EachThreadCallback *cb,
						   StartParsingCallback *start_parsing_cb,
						   BeforeWaitCallback *before_wait_cb,
						   AfterWaitCallback *after_wait_cb,
						   EndParsingCallback *end_parsing_cb,
						   gpointer callback_data);
const char *ochusha_bulletin_board_get_response_character_encoding(
						OchushaBulletinBoard *board);
iconv_helper *ochusha_bulletin_board_get_response_iconv_helper(
						OchushaBulletinBoard *board);

gboolean ochusha_bulletin_board_is_new_thread_preview_supported(
						OchushaBulletinBoard *board);
gboolean ochusha_bulletin_board_preview_new_thread(OchushaBulletinBoard *board,
					const gchar *title,
					const OchushaBBSResponse *response,
					StartThreadCallback *start_cb,
					EachResponseCallback *response_cb,
					EndThreadCallback *end_cb,
					gpointer callback_data);
gboolean ochusha_bulletin_board_is_new_thread_supported(
						OchushaBulletinBoard *board);
gboolean ochusha_bulletin_board_create_new_thread(OchushaBulletinBoard *board,
					OchushaNetworkBroker *broker,
					const gchar *title,
					const OchushaBBSResponse *response);

gboolean ochusha_bulletin_board_read_threadlist_xml(
					OchushaBulletinBoard *board,
					OchushaConfig *config,
					const char *subdir,
					gboolean recover_mode);
gboolean ochusha_bulletin_board_write_threadlist_xml(
					OchushaBulletinBoard *board,
					OchushaConfig *config,
					const char *subdir);

gboolean ochusha_bulletin_board_get_post_use_2ch_be(OchushaBulletinBoard *board,
						const OchushaConfig *config);
void ochusha_bulletin_board_set_post_use_2ch_be(OchushaBulletinBoard *board,
						gboolean use_2ch_be);
gboolean ochusha_bulletin_board_get_post_use_2ch_viewer(OchushaBulletinBoard *board,
						const OchushaConfig *config);
void ochusha_bulletin_board_set_post_use_2ch_viewer(OchushaBulletinBoard *board,
						    gboolean use_2ch_viewer);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BULLETIN_BOARD_H_ */
