/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2005 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart, 
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2006 The Regents of the University of California.
 *                         All rights reserved.
 * $COPYRIGHT$
 * 
 * Additional copyrights may follow
 * 
 * $HEADER$
 */

#include "ompi_config.h"
#include "opal/sys/cache.h"
#include "opal/event/event.h"
#include "mpi.h"
#include "ompi/mca/bml/bml.h"
#include "ompi/mca/btl/btl.h"
#include "ompi/mca/btl/base/base.h"
#include "opal/mca/base/mca_base_param.h"
#include "bml_r2.h"


mca_bml_base_component_1_0_0_t mca_bml_r2_component = {

    /* First, the mca_base_component_t struct containing meta
       information about the component itself */

    {
        /* Indicate that we are a bml v1.0.0 component (which also implies
         a specific MCA version) */
        MCA_BML_BASE_VERSION_1_0_0,
        "r2", /* MCA component name */
        OMPI_MAJOR_VERSION,  /* MCA component major version */
        OMPI_MINOR_VERSION,  /* MCA component minor version */
        OMPI_RELEASE_VERSION,  /* MCA component release version */
        mca_bml_r2_component_open,  /* component open */
        mca_bml_r2_component_close  /* component close */
    },

    /* Next the MCA v1.0.0 component meta data */
    {
      /* Whether the component is checkpointable or not */
      false
    },
    mca_bml_r2_component_init
};



static inline int mca_bml_r2_param_register_int(
    const char* param_name,
    int default_value)
{
    int id = mca_base_param_register_int("bml","r2",param_name,NULL,default_value);
    int param_value = default_value;
    mca_base_param_lookup_int(id,&param_value);
    return param_value;
}
                                                                                                                        

int mca_bml_r2_component_open(void)
{
    return OMPI_SUCCESS; 
}


int mca_bml_r2_component_close(void)
{
        
    /* OBJ_DESTRUCT(&mca_bml_r2.lock); */

    return OMPI_SUCCESS;
}


mca_bml_base_module_t* mca_bml_r2_component_init( 
                                                 int* priority, 
                                                 bool enable_progress_threads,
                                                 bool enable_mpi_threads,
                                                 opal_class_t* endpoint_class
                                                 )
{
    /* initialize BTLs */
    
    if(OMPI_SUCCESS != mca_btl_base_select(enable_progress_threads,enable_mpi_threads))
        return NULL;
    
    *priority = 100; 
    mca_bml_r2.btls_added = false; 
    mca_bml_r2.endpoint_class = endpoint_class;
    return &mca_bml_r2.super;
}
