/*
** PHREL
** $Id: data_hash.h,v 1.7 2006/03/25 21:14:14 sella Exp $
** Copyright (c) 2004 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

#ifndef __DGS_DATA_HASH_H
#define __DGS_DATA_HASH_H

#include "config.h"

#include "phrel.h"

#include <arpa/inet.h>

#define HASH_WIDTH 75011 /* Must be prime number. */
#define HASH_ALGO_INT1
//#define HASH_ALGO_DJB2 /* Use the DJB2 hash algo. */
//#define HASH_DEBUG

struct hash_entry_t {
	struct data_t *data;
	struct hash_entry_t *next;
};

struct hash_key_t {
	struct hash_entry_t *entry;
	unsigned int depth;
};

/* Public functions */
void hash_init();
void hash_free();
void hash_add(struct in_addr *key, struct data_t *data);
int hash_del(struct in_addr *key);
struct data_t* hash_find(struct in_addr *key);
struct data_t* hash_index(unsigned long index);
int hash_stats_print(void);
int hash_stats(char* stats, size_t len);

/* Private functions. */
unsigned long hash(struct in_addr *key);

#endif

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
